/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

class FilesystemInterceptor
extends ProvidedExtensions
implements FileChangeListener {
    private static final String ATTRIBUTE_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    private static final String ATTRIBUTE_REFRESH = "ProvidedExtensions.Refresh";
    private static final String ATTRIBUTE_VCS_MANAGED = "ProvidedExtensions.VCSManaged";
    private VersioningManager master;
    private final Map<FileEx, DelegatingInterceptor> filesBeingCreated = new HashMap<FileEx, DelegatingInterceptor>(10);
    private final DelegatingInterceptor nullDelegatingInterceptor = new DelegatingInterceptor(){

        public boolean beforeDelete() {
            return false;
        }

        public void doDelete() throws IOException {
        }

        public void afterDelete() {
        }

        public boolean beforeMove() {
            return false;
        }

        public void doMove() throws IOException {
        }

        public boolean beforeCreate() {
            return false;
        }

        public void doCreate() throws IOException {
        }

        public void afterCreate() {
        }

        public void beforeChange() {
        }

        public void beforeEdit() {
        }

        public void afterChange() {
        }

        public void afterMove() {
        }

        public void handle() throws IOException {
        }

        public boolean delete(File file) {
            throw new UnsupportedOperationException();
        }
    };
    private final VCSInterceptor nullVCSInterceptor = new VCSInterceptor(){};
    private final Set<File> deletedFiles = new HashSet<File>(5);

    FilesystemInterceptor() {
    }

    void init(VersioningManager versioningManager) {
        assert (this.master == null);
        this.master = versioningManager;
        FileSystem fileSystem = Utils.getRootFilesystem();
        fileSystem.addFileChangeListener((FileChangeListener)this);
    }

    void shutdown() {
        FileSystem fileSystem = Utils.getRootFilesystem();
        fileSystem.removeFileChangeListener((FileChangeListener)this);
    }

    public boolean canWrite(File file) {
        if (Utils.canWrite(file)) {
            return true;
        }
        if (!Utils.exists(file)) {
            return false;
        }
        return this.getInterceptor(file, false, "isMutable").isMutable(file);
    }

    public Object getAttribute(File file, String string) {
        if (ATTRIBUTE_REMOTE_LOCATION.equals(string) || ATTRIBUTE_REFRESH.equals(string)) {
            return this.getInterceptor(file, file.isDirectory(), "getAttribute").getAttribute(string);
        }
        if (ATTRIBUTE_VCS_MANAGED.equals(string)) {
            return this.master.getOwner(file) != null;
        }
        return null;
    }

    public void fileChanged(FileEvent fileEvent) {
        this.removeFromDeletedFiles(fileEvent.getFile());
        this.getInterceptor(fileEvent, "afterChange").afterChange();
    }

    public void beforeChange(FileObject fileObject) {
        this.getInterceptor(FileUtil.toFile((FileObject)fileObject), fileObject.isFolder(), "beforeChange").beforeChange();
    }

    private boolean needsLH(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.master.needsLocalHistory(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(File file) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            this.deletedFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(FileObject fileObject) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            if (this.deletedFiles.size() > 0) {
                this.deletedFiles.remove(FileUtil.toFile((FileObject)fileObject));
            }
        }
    }

    public ProvidedExtensions.DeleteHandler getDeleteHandler(File file) {
        this.removeFromDeletedFiles(file);
        DelegatingInterceptor delegatingInterceptor = this.getInterceptor(file, false, "beforeDelete", "doDelete");
        return delegatingInterceptor.beforeDelete() ? delegatingInterceptor : null;
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.removeFromDeletedFiles(fileEvent.getFile());
        this.getInterceptor(fileEvent, "afterDelete").afterDelete();
    }

    public void beforeCreate(FileObject fileObject, String string, boolean bl) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return;
        }
        file = new File(file, string);
        DelegatingInterceptor delegatingInterceptor = this.getInterceptor(file, bl, "beforeCreate");
        if (delegatingInterceptor.beforeCreate()) {
            this.filesBeingCreated.put(new FileEx(fileObject, string, bl), delegatingInterceptor);
        }
    }

    public void createFailure(FileObject fileObject, String string, boolean bl) {
        this.filesBeingCreated.remove(new FileEx(fileObject, string, bl));
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.fileDataCreated(fileEvent);
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        FileEx fileEx = new FileEx(fileObject.getParent(), fileObject.getNameExt(), fileObject.isFolder());
        DelegatingInterceptor delegatingInterceptor = this.filesBeingCreated.remove(fileEx);
        if (delegatingInterceptor != null) {
            try {
                delegatingInterceptor.doCreate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeFromDeletedFiles(fileEvent.getFile());
        if (delegatingInterceptor == null) {
            delegatingInterceptor = this.getInterceptor(fileEvent, "afterCreate");
        }
        delegatingInterceptor.afterCreate();
    }

    public ProvidedExtensions.IOHandler getMoveHandler(File file, File file2) {
        DelegatingInterceptor delegatingInterceptor = this.getInterceptor(file, file2, "beforeMove", "doMove");
        return delegatingInterceptor.beforeMove() ? delegatingInterceptor : null;
    }

    public ProvidedExtensions.IOHandler getRenameHandler(File file, String string) {
        File file2 = new File(file.getParentFile(), string);
        return this.getMoveHandler(file, file2);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.removeFromDeletedFiles(fileRenameEvent.getFile());
        this.getInterceptor((FileEvent)fileRenameEvent, "afterMove").afterMove();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileLocked(FileObject fileObject) {
        this.getInterceptor(new FileEvent(fileObject), "beforeEdit").beforeEdit();
    }

    private DelegatingInterceptor getInterceptor(FileEvent fileEvent, String ... stringArray) {
        VCSInterceptor vCSInterceptor;
        if (this.master == null) {
            return this.nullDelegatingInterceptor;
        }
        FileObject fileObject = fileEvent.getFile();
        if (fileObject == null) {
            return this.nullDelegatingInterceptor;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem versioningSystem = this.needsLH(stringArray) ? this.master.getLocalHistory(file) : null;
        VersioningSystem versioningSystem2 = this.master.getOwner(file);
        VCSInterceptor vCSInterceptor2 = versioningSystem2 != null ? versioningSystem2.getVCSInterceptor() : null;
        VCSInterceptor vCSInterceptor3 = vCSInterceptor = versioningSystem != null ? versioningSystem.getVCSInterceptor() : null;
        if (vCSInterceptor2 == null && vCSInterceptor == null) {
            return this.nullDelegatingInterceptor;
        }
        if (fileEvent instanceof FileRenameEvent) {
            FileRenameEvent fileRenameEvent = (FileRenameEvent)fileEvent;
            File file2 = file.getParentFile();
            if (file2 != null) {
                String string = fileRenameEvent.getName();
                String string2 = fileRenameEvent.getExt();
                if (string2 != null && string2.length() > 0) {
                    string = string + "." + string2;
                }
                File file3 = new File(file2, string);
                return new DelegatingInterceptor(vCSInterceptor2, vCSInterceptor, file3, file, false);
            }
            return this.nullDelegatingInterceptor;
        }
        return new DelegatingInterceptor(vCSInterceptor2, vCSInterceptor, file, null, false);
    }

    private DelegatingInterceptor getInterceptor(File file, boolean bl, String ... stringArray) {
        if (file == null || this.master == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem versioningSystem = this.master.getOwner(file);
        VCSInterceptor vCSInterceptor = versioningSystem != null ? versioningSystem.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem versioningSystem2 = this.needsLH(stringArray) ? this.master.getLocalHistory(file) : null;
        VCSInterceptor vCSInterceptor2 = versioningSystem2 != null ? versioningSystem2.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vCSInterceptor, vCSInterceptor2, file, null, bl);
    }

    private DelegatingInterceptor getInterceptor(File file, File file2, String ... stringArray) {
        if (file == null || file2 == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem versioningSystem = this.master.getOwner(file);
        VCSInterceptor vCSInterceptor = versioningSystem != null ? versioningSystem.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem versioningSystem2 = this.needsLH(stringArray) ? this.master.getLocalHistory(file) : null;
        VCSInterceptor vCSInterceptor2 = versioningSystem2 != null ? versioningSystem2.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vCSInterceptor, vCSInterceptor2, file, file2, false);
    }

    private class FileEx {
        final FileObject parent;
        final String name;
        final boolean isFolder;

        public FileEx(FileObject fileObject, String string, boolean bl) {
            this.parent = fileObject;
            this.name = string;
            this.isFolder = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof FileEx)) {
                return false;
            }
            FileEx fileEx = (FileEx)object;
            return this.isFolder == fileEx.isFolder && this.name.equals(fileEx.name) && this.parent.equals(fileEx.parent);
        }

        public int hashCode() {
            int n = this.parent.hashCode();
            n = 17 * n + this.name.hashCode();
            n = 17 * n + (this.isFolder ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingInterceptor
    implements ProvidedExtensions.IOHandler,
    ProvidedExtensions.DeleteHandler {
        final Collection<VCSInterceptor> interceptors;
        final VCSInterceptor interceptor;
        final VCSInterceptor lhInterceptor;
        final File file;
        final File to;
        private final boolean isDirectory;

        private DelegatingInterceptor() {
            this((VCSInterceptor)null, null, null, null, false);
        }

        public DelegatingInterceptor(VCSInterceptor vCSInterceptor, VCSInterceptor vCSInterceptor2, File file, File file2, boolean bl) {
            this.interceptor = vCSInterceptor != null ? vCSInterceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.interceptors = Collections.singleton(this.interceptor);
            this.lhInterceptor = vCSInterceptor2 != null ? vCSInterceptor2 : FilesystemInterceptor.this.nullVCSInterceptor;
            this.file = file;
            this.to = file2;
            this.isDirectory = bl;
        }

        public DelegatingInterceptor(Collection<VCSInterceptor> collection, VCSInterceptor vCSInterceptor, File file, File file2, boolean bl) {
            this.interceptors = collection != null && collection.size() > 0 ? collection : Collections.singleton(FilesystemInterceptor.this.nullVCSInterceptor);
            this.interceptor = this.interceptors.iterator().next();
            this.lhInterceptor = vCSInterceptor != null ? vCSInterceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.file = file;
            this.to = file2;
            this.isDirectory = bl;
        }

        public boolean isMutable(File file) {
            return this.interceptor.isMutable(file);
        }

        private Object getAttribute(String string) {
            return this.interceptor.getAttribute(this.file, string);
        }

        public boolean beforeDelete() {
            this.lhInterceptor.beforeDelete(this.file);
            return this.interceptor.beforeDelete(this.file);
        }

        public void doDelete() throws IOException {
            this.lhInterceptor.doDelete(this.file);
            this.interceptor.doDelete(this.file);
        }

        public void afterDelete() {
            this.lhInterceptor.afterDelete(this.file);
            this.interceptor.afterDelete(this.file);
        }

        public boolean beforeMove() {
            this.lhInterceptor.beforeMove(this.file, this.to);
            return this.interceptor.beforeMove(this.file, this.to);
        }

        public void doMove() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
        }

        public void afterMove() {
            this.lhInterceptor.afterMove(this.file, this.to);
            this.interceptor.afterMove(this.file, this.to);
        }

        public boolean beforeCreate() {
            this.lhInterceptor.beforeCreate(this.file, this.isDirectory);
            return this.interceptor.beforeCreate(this.file, this.isDirectory);
        }

        public void doCreate() throws IOException {
            this.lhInterceptor.doCreate(this.file, this.isDirectory);
            this.interceptor.doCreate(this.file, this.isDirectory);
        }

        public void afterCreate() {
            this.lhInterceptor.afterCreate(this.file);
            this.interceptor.afterCreate(this.file);
        }

        public void afterChange() {
            this.lhInterceptor.afterChange(this.file);
            this.interceptor.afterChange(this.file);
        }

        public void beforeChange() {
            this.lhInterceptor.beforeChange(this.file);
            this.interceptor.beforeChange(this.file);
        }

        public void beforeEdit() {
            this.lhInterceptor.beforeEdit(this.file);
            this.interceptor.beforeEdit(this.file);
        }

        public void handle() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
            this.lhInterceptor.afterMove(this.file, this.to);
            this.interceptor.afterMove(this.file, this.to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean delete(File file) {
            Set set;
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    for (File file2 : fileArray) {
                        if (FilesystemInterceptor.this.deletedFiles.contains(file2)) continue;
                        return false;
                    }
                }
            }
            try {
                this.lhInterceptor.doDelete(file);
                this.interceptor.doDelete(file);
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    if (file.isDirectory()) {
                        Iterator iterator = FilesystemInterceptor.this.deletedFiles.iterator();
                        while (iterator.hasNext()) {
                            File file3 = (File)iterator.next();
                            if (!file.equals(file3.getParentFile())) continue;
                            iterator.remove();
                        }
                    }
                    if (Utils.exists(file)) {
                        FilesystemInterceptor.this.deletedFiles.add(file);
                    } else {
                        FilesystemInterceptor.this.deletedFiles.remove(file);
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

