/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makewizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakefileIncludesPanel
extends EnterItemsPanel {
    static final long serialVersionUID = -3932940292545539665L;
    private int key;
    private boolean initialized;

    MakefileIncludesPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_MakefileIncludesPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_IncDir"), this.getString("MNEM_IncDir").charAt(0), 10);
    }

    @Override
    protected String getListLabel() {
        return this.getString("LBL_IncludesList");
    }

    @Override
    protected char getListMnemonic() {
        return this.getString("MNEM_IncludesList").charAt(0);
    }

    @Override
    public void validateData(ArrayList<String> arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String[] stringArray = targetData.getIncludesList();
        if (stringArray == null) {
            this.warn(arrayList, WARN_NO_INC_DIRS, targetData.getName());
        } else {
            int n2;
            String string = this.getMakefileData().getBaseDirectory(true);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string2 = stringArray[n2];
                File file = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2);
                if (file == null) continue;
                if (!file.exists()) {
                    arrayList2.add("\t" + file.getPath() + "\n");
                    continue;
                }
                if (file.isDirectory()) continue;
                arrayList3.add("\t" + file.getPath() + "\n");
            }
            if (arrayList2.size() > 0) {
                if (arrayList2.size() < 5) {
                    this.warn(arrayList, WARN_DNE_INCDIR, targetData.getName());
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList.add((String)arrayList2.get(n2));
                    }
                    arrayList.add("\n");
                } else {
                    this.warn(arrayList, WARN_DNE_COUNT, targetData.getName(), String.valueOf(arrayList2.size()));
                }
            }
            if (arrayList3.size() > 0) {
                if (arrayList3.size() < 5) {
                    this.warn(arrayList, WARN_INC_NOT_DIR, targetData.getName());
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        arrayList.add((String)arrayList3.get(n2));
                    }
                    arrayList.add("\n");
                } else {
                    this.warn(arrayList, WARN_INC_NOT_DIR_COUNT, targetData.getName(), String.valueOf(arrayList3.size()));
                }
            }
        }
    }

    @Override
    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_MIP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    @Override
    protected String validateInput(String string) {
        if (string.startsWith("-I")) {
            return string.substring(2);
        }
        if (string.charAt(0) == '-') {
            return null;
        }
        return string;
    }

    @Override
    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        String[] stringArray = targetData.getIncludesList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        targetData.setIncludesList(this.getListItems());
    }
}

