/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.compilers.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.execution.LinkSupport;
import org.netbeans.modules.cnd.api.utils.Path;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolchainManagerImpl {
    private static final boolean TRACE = Boolean.getBoolean("cnd.toolchain.personality.trace");
    private static final boolean CREATE_SHADOW = Boolean.getBoolean("cnd.toolchain.personality.create_shadow");
    public static final String CONFIG_FOLDER = "CND/ToolChain";
    private List<ToolchainManager.ToolchainDescriptor> descriptors = new ArrayList<ToolchainManager.ToolchainDescriptor>();
    private Logger log = Logger.getLogger("cnd.toolchain.logger");
    private static final WeakHashMap<String, String> commandCache = new WeakHashMap();

    public ToolchainManagerImpl() {
        this.initToolchainManager();
    }

    private void initToolchainManager() {
        try {
            TreeMap<Integer, CompilerVendor> treeMap = new TreeMap<Integer, CompilerVendor>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            FileObject fileObject = FileUtil.getConfigFile((String)CONFIG_FOLDER);
            int n = 0x3FFFFFFF;
            if (fileObject != null && fileObject.isFolder()) {
                Object object;
                for (Object object2 : object = fileObject.getChildren()) {
                    CompilerVendor compilerVendor = new CompilerVendor(object2.getNameExt());
                    Integer n2 = (Integer)object2.getAttribute("position");
                    if (n2 == null || treeMap.containsKey(n2)) {
                        n2 = n++;
                    }
                    if (!this.read((FileObject)object2, (FileObject[])object, compilerVendor, new HashSet<FileObject>(), hashMap)) continue;
                    treeMap.put(n2, compilerVendor);
                }
            }
            if (TRACE) {
                System.err.println("Declared vendors:");
            }
            for (Object object : treeMap.values()) {
                if (TRACE) {
                    System.err.println("\t" + ((CompilerVendor)object).toolChainName);
                }
                this.descriptors.add(new ToolchainDescriptorImpl((CompilerVendor)object));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (CREATE_SHADOW) {
            this.writeToolchains();
        }
    }

    public void reinitToolchainManager() {
        this.descriptors.clear();
        this.initToolchainManager();
    }

    public ToolchainManager.ToolchainDescriptor getToolchain(String string, int n) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : this.descriptors) {
            if (!string.equals(toolchainDescriptor.getName()) || !this.isPlatforSupported(n, toolchainDescriptor) && !this.isPlatforSupported(6, toolchainDescriptor)) continue;
            return toolchainDescriptor;
        }
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : this.descriptors) {
            if (!this.isPlatforSupported(6, toolchainDescriptor)) continue;
            return toolchainDescriptor;
        }
        return null;
    }

    public List<ToolchainManager.ToolchainDescriptor> getAllToolchains() {
        return new ArrayList<ToolchainManager.ToolchainDescriptor>(this.descriptors);
    }

    public List<ToolchainManager.ToolchainDescriptor> getToolchains(int n) {
        ArrayList<ToolchainManager.ToolchainDescriptor> arrayList = new ArrayList<ToolchainManager.ToolchainDescriptor>();
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : this.descriptors) {
            if (!this.isPlatforSupported(n, toolchainDescriptor)) continue;
            arrayList.add(toolchainDescriptor);
        }
        return arrayList;
    }

    public boolean isPlatforSupported(int n, ToolchainManager.ToolchainDescriptor toolchainDescriptor) {
        switch (n) {
            case 0: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_sparc".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_intel".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"linux".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"windows".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"mac".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"unix".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"none".equals(string)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean isMyFolder(String string, ToolchainManager.ToolchainDescriptor toolchainDescriptor, int n, boolean bl) {
        boolean bl2 = this.isMyFolderImpl(string, toolchainDescriptor, n, bl);
        if (TRACE && bl2) {
            System.err.println("Path [" + string + "] belongs to tool chain " + toolchainDescriptor.getName());
        }
        return bl2;
    }

    private boolean isMyFolderImpl(String string, ToolchainManager.ToolchainDescriptor toolchainDescriptor, int n, boolean bl) {
        Object object;
        Object object2;
        ToolchainManager.CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
        if (compilerDescriptor == null || compilerDescriptor.getNames().length == 0) {
            return false;
        }
        Pattern pattern = null;
        if (!bl) {
            if (compilerDescriptor.getPathPattern() != null) {
                pattern = n == 3 ? Pattern.compile(compilerDescriptor.getPathPattern(), 2) : Pattern.compile(compilerDescriptor.getPathPattern());
            }
            if (pattern != null && !pattern.matcher(string).find()) {
                object2 = compilerDescriptor.getExistFolder();
                if (object2 == null) {
                    return false;
                }
                object = new File(string + "/" + (String)object2);
                if (!((File)object).exists() || !((File)object).isDirectory()) {
                    return false;
                }
            }
        }
        if (!(((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0]))).exists() || ((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0] + ".exe"))).exists() || ((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0] + ".exe.lnk"))).exists())) {
            return false;
        }
        object = compilerDescriptor.getVersionFlags();
        if (object == null) {
            return true;
        }
        if (compilerDescriptor.getVersionPattern() == null) {
            return true;
        }
        pattern = Pattern.compile(compilerDescriptor.getVersionPattern());
        String string2 = LinkSupport.resolveWindowsLink(((File)object2).getAbsolutePath());
        String string3 = ToolchainManagerImpl.getCommandOutput(string, string2 + " " + (String)object);
        boolean bl2 = pattern.matcher(string3).find();
        if (TRACE && !bl2) {
            System.err.println("No match for pattern [" + compilerDescriptor.getVersionPattern() + "]:");
        }
        if (TRACE && !bl2) {
            System.err.println("Run " + string + "/" + compilerDescriptor.getNames()[0] + " " + (String)object + "\n" + string3);
        }
        return bl2;
    }

    public String getBaseFolder(ToolchainManager.ToolchainDescriptor toolchainDescriptor, int n) {
        if (n != 3) {
            return null;
        }
        List<ToolchainManager.BaseFolder> list = toolchainDescriptor.getBaseFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ToolchainManager.BaseFolder baseFolder : list) {
            String string;
            String string2 = baseFolder.getFolderPattern();
            String string3 = baseFolder.getFolderKey();
            if (string3 == null || string2 == null || (string = this.readRegistry(string3, string2)) == null) continue;
            if (baseFolder.getFolderSuffix() != null) {
                string = string + "/" + baseFolder.getFolderSuffix();
            }
            return string;
        }
        return null;
    }

    public String getCommandFolder(ToolchainManager.ToolchainDescriptor toolchainDescriptor, int n) {
        Object object;
        String string;
        if (n != 3) {
            return null;
        }
        List<ToolchainManager.BaseFolder> list = toolchainDescriptor.getCommandFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string2 = null;
        for (ToolchainManager.BaseFolder baseFolder : list) {
            string = baseFolder.getFolderPattern();
            object = baseFolder.getFolderKey();
            if (object == null || string == null) continue;
            string2 = this.readRegistry((String)object, string);
            if (string2 != null && baseFolder.getFolderSuffix() != null) {
                string2 = string2 + "\\" + baseFolder.getFolderSuffix();
            }
            if (string2 == null) continue;
            return string2;
        }
        for (ToolchainManager.BaseFolder baseFolder : list) {
            string = baseFolder.getFolderPathPattern();
            if (string == null || string.length() <= 0) continue;
            object = Pattern.compile(string);
            for (String string3 : Path.getPath()) {
                if (!((Pattern)object).matcher(string3).find()) continue;
                return string3;
            }
        }
        return null;
    }

    private String readRegistry(String string, String string2) {
        String string3;
        block6: {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("C:/Windows/System32/reg.exe");
            arrayList.add("query");
            arrayList.add(string);
            arrayList.add("/s");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            string3 = null;
            try {
                String string4;
                if (TRACE) {
                    System.err.println("Read registry " + string);
                }
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Pattern pattern = Pattern.compile(string2);
                while ((string4 = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    string4 = string4.trim();
                    if (TRACE) {
                        System.err.println("\t" + string4);
                    }
                    if (!(matcher = pattern.matcher(string4)).find() || matcher.groupCount() != 1) continue;
                    string3 = matcher.group(1).trim();
                    if (!TRACE) continue;
                    System.err.println("\tFound " + string3);
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block6;
                exception.printStackTrace();
            }
        }
        if (string3 == null && string.startsWith("hklm\\")) {
            string3 = this.readRegistry("hkcu\\" + string.substring(5), string2);
        }
        return string3;
    }

    private static String getCommandOutput(String string, String string2) {
        StringBuilder stringBuilder;
        block22: {
            Object object;
            Object iOException;
            if (string == null) {
                string = "";
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String charSequence2 : System.getenv().keySet()) {
                iOException = System.getenv().get(charSequence2);
                if (charSequence2.equals(Path.getPathName())) {
                    arrayList.add(Path.getPathName() + "=" + string + File.pathSeparatorChar + (String)iOException);
                    continue;
                }
                object = charSequence2 + "=" + (String)(iOException != null ? iOException : "");
                arrayList.add(object);
            }
            String string3 = commandCache.get(string2);
            if (string3 != null) {
                return string3;
            }
            stringBuilder = new StringBuilder();
            try {
                block21: {
                    BufferedReader bufferedReader;
                    block20: {
                        block19: {
                            iOException = Runtime.getRuntime().exec(string2, arrayList.toArray(new String[arrayList.size()]));
                            object = ((Process)iOException).getInputStream();
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                            try {
                                while ((iOException = bufferedReader.readLine()) != null) {
                                    stringBuilder.append(iOException);
                                    stringBuilder.append('\n');
                                }
                            }
                            catch (IOException iOException2) {
                                if (!TRACE) break block19;
                                iOException2.printStackTrace();
                            }
                        }
                        try {
                            if (object != null) {
                                ((InputStream)object).close();
                            }
                        }
                        catch (IOException iOException2) {
                            if (!TRACE) break block20;
                            iOException2.printStackTrace();
                        }
                    }
                    object = ((Process)iOException).getErrorStream();
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                    try {
                        while ((iOException = bufferedReader.readLine()) != null) {
                            stringBuilder.append(iOException);
                            stringBuilder.append('\n');
                        }
                    }
                    catch (IOException iOException3) {
                        if (!TRACE) break block21;
                        iOException3.printStackTrace();
                    }
                }
                try {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException3) {
                    if (TRACE) {
                        iOException3.printStackTrace();
                    }
                }
            }
            catch (IOException iOException4) {
                if (!TRACE) break block22;
                iOException4.printStackTrace();
            }
        }
        commandCache.put(string2, stringBuilder.toString());
        return stringBuilder.toString();
    }

    private boolean read(FileObject fileObject, FileObject[] fileObjectArray, CompilerVendor compilerVendor, Set<FileObject> set, Map<String, String> map) {
        if (set.contains(fileObject)) {
            return false;
        }
        set.add(fileObject);
        String string = (String)fileObject.getAttribute("extends");
        if (string != null && string.length() > 0) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (!string.equals(fileObject2.getName()) || this.read(fileObject2, fileObjectArray, compilerVendor, set, map)) continue;
                return false;
            }
        }
        try {
            this.read(fileObject.getInputStream(), compilerVendor, map);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private boolean read(InputStream inputStream, CompilerVendor compilerVendor, Map<String, String> map) {
        Object object;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        XMLReader xMLReader = null;
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        object = new SAXHandler(compilerVendor, map);
        xMLReader.setContentHandler((ContentHandler)object);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String unsplit(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToolchains() {
        FileObject fileObject = FileUtil.getConfigFile((String)CONFIG_FOLDER);
        if (fileObject != null && fileObject.isFolder()) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                String string = fileObject2.getNameExt();
                for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : this.descriptors) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (!string.equals(toolchainDescriptor.getFileName())) continue;
                    Document document = XMLUtil.createDocument((String)"toolchaindefinition", (String)"http://www.netbeans.org/ns/cnd-toolchain-definition/1", null, null);
                    Element element = document.getDocumentElement();
                    Element element2 = document.createElement("toolchain");
                    element2.setAttribute("name", toolchainDescriptor.getName());
                    element2.setAttribute("display", toolchainDescriptor.getDisplayName());
                    element2.setAttribute("family", this.unsplit(toolchainDescriptor.getFamily()));
                    if (toolchainDescriptor.getQmakeSpec() != null) {
                        element2.setAttribute("qmakespec", toolchainDescriptor.getQmakeSpec());
                    }
                    if (toolchainDescriptor.isAbstract()) {
                        element2.setAttribute("abstract", "true");
                    }
                    element.appendChild(element2);
                    if (toolchainDescriptor.getUpdateCenterUrl() != null && toolchainDescriptor.getModuleID() != null) {
                        element2 = document.createElement("download");
                        element2.setAttribute("uc_url", toolchainDescriptor.getUpdateCenterUrl());
                        element2.setAttribute("module_id", toolchainDescriptor.getModuleID());
                        element2.setAttribute("uc_display", toolchainDescriptor.getUpdateCenterDisplayName());
                        element2.setAttribute("upgrade_url", toolchainDescriptor.getUpgradeUrl());
                        element.appendChild(element2);
                    }
                    element2 = document.createElement("platforms");
                    element2.setAttribute("stringvalue", this.unsplit(toolchainDescriptor.getPlatforms()));
                    element.appendChild(element2);
                    if (toolchainDescriptor.getDriveLetterPrefix() != null) {
                        element2 = document.createElement("drive_letter_prefix");
                        element2.setAttribute("stringvalue", toolchainDescriptor.getDriveLetterPrefix());
                        element.appendChild(element2);
                    }
                    if (toolchainDescriptor.getMakefileWriter() != null) {
                        element2 = document.createElement("makefile_writer");
                        element2.setAttribute("class", toolchainDescriptor.getMakefileWriter());
                        element.appendChild(element2);
                    }
                    if (toolchainDescriptor.getBaseFolders() != null) {
                        element2 = document.createElement("base_folders");
                        element.appendChild(element2);
                        object5 = toolchainDescriptor.getBaseFolders().iterator();
                        while (object5.hasNext()) {
                            object4 = object5.next();
                            object3 = document.createElement("base_folder");
                            if (object4.getFolderKey() != null) {
                                object3.setAttribute("regestry", object4.getFolderKey());
                            }
                            if (object4.getFolderPattern() != null) {
                                object3.setAttribute("pattern", object4.getFolderPattern());
                            }
                            if (object4.getFolderPathPattern() != null) {
                                object3.setAttribute("path_patern", object4.getFolderPathPattern());
                            }
                            if (object4.getFolderSuffix() != null) {
                                object3.setAttribute("suffix", object4.getFolderSuffix());
                            }
                            element2.appendChild((Node)object3);
                        }
                    }
                    if (toolchainDescriptor.getCommandFolders() != null) {
                        element2 = document.createElement("command_folders");
                        element.appendChild(element2);
                        object5 = toolchainDescriptor.getCommandFolders().iterator();
                        while (object5.hasNext()) {
                            object4 = object5.next();
                            object3 = document.createElement("command_folder");
                            if (object4.getFolderKey() != null) {
                                object3.setAttribute("regestry", object4.getFolderKey());
                            }
                            if (object4.getFolderPattern() != null) {
                                object3.setAttribute("pattern", object4.getFolderPattern());
                            }
                            if (object4.getFolderPathPattern() != null) {
                                object3.setAttribute("path_patern", object4.getFolderPathPattern());
                            }
                            if (object4.getFolderSuffix() != null) {
                                object3.setAttribute("suffix", object4.getFolderSuffix());
                            }
                            element2.appendChild((Node)object3);
                        }
                    }
                    if (toolchainDescriptor.getDefaultLocations() != null) {
                        element2 = document.createElement("default_locations");
                        element.appendChild(element2);
                        object5 = toolchainDescriptor.getDefaultLocations().entrySet().iterator();
                        while (object5.hasNext()) {
                            object4 = (Map.Entry)object5.next();
                            object3 = ((List)object4.getValue()).iterator();
                            while (object3.hasNext()) {
                                object2 = (String)object3.next();
                                object = document.createElement("platform");
                                object.setAttribute("os", (String)object4.getKey());
                                object.setAttribute("directory", (String)object2);
                                element2.appendChild((Node)object);
                            }
                        }
                    }
                    if ((object5 = toolchainDescriptor.getC()) != null) {
                        element2 = document.createElement("c");
                        this.writeCompiler(document, element2, (ToolchainManager.CompilerDescriptor)object5);
                        element.appendChild(element2);
                    }
                    if ((object5 = toolchainDescriptor.getCpp()) != null) {
                        element2 = document.createElement("cpp");
                        this.writeCompiler(document, element2, (ToolchainManager.CompilerDescriptor)object5);
                        element.appendChild(element2);
                    }
                    if ((object5 = toolchainDescriptor.getFortran()) != null) {
                        element2 = document.createElement("fortran");
                        this.writeCompiler(document, element2, (ToolchainManager.CompilerDescriptor)object5);
                        element.appendChild(element2);
                    }
                    if ((object5 = toolchainDescriptor.getAssembler()) != null) {
                        element2 = document.createElement("assembler");
                        this.writeCompiler(document, element2, (ToolchainManager.CompilerDescriptor)object5);
                        element.appendChild(element2);
                    }
                    if ((object4 = toolchainDescriptor.getScanner()) != null) {
                        element2 = document.createElement("scanner");
                        element2.setAttribute("id", object4.getID());
                        this.writeScanner(document, element2, (ToolchainManager.ScannerDescriptor)object4);
                        element.appendChild(element2);
                    }
                    if ((object3 = toolchainDescriptor.getLinker()) != null) {
                        element2 = document.createElement("linker");
                        this.writeLinker(document, element2, (ToolchainManager.LinkerDescriptor)object3);
                        element.appendChild(element2);
                    }
                    if ((object2 = toolchainDescriptor.getMake()) != null) {
                        element2 = document.createElement("make");
                        this.writeMake(document, element2, (ToolchainManager.MakeDescriptor)object2);
                        element.appendChild(element2);
                    }
                    if ((object = toolchainDescriptor.getDebugger()) != null) {
                        element2 = document.createElement("debugger");
                        this.writeDebugger(document, element2, (ToolchainManager.DebuggerDescriptor)object);
                        element.appendChild(element2);
                    }
                    try {
                        FileLock fileLock = fileObject2.lock();
                        try {
                            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                            try {
                                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                                fileObject2.setAttribute("extends", (Object)"");
                            }
                            finally {
                                outputStream.close();
                            }
                        }
                        finally {
                            fileLock.releaseLock();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
    }

    private void writeCompiler(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        Element element2 = document.createElement("compiler");
        element2.setAttribute("name", this.unsplit(compilerDescriptor.getNames()));
        if (compilerDescriptor.skipSearch()) {
            element2.setAttribute("skip", "true");
        }
        element.appendChild(element2);
        if (compilerDescriptor.getPathPattern() != null || compilerDescriptor.getExistFolder() != null) {
            element2 = document.createElement("recognizer");
            if (compilerDescriptor.getPathPattern() != null) {
                element2.setAttribute("pattern", compilerDescriptor.getPathPattern());
            }
            if (compilerDescriptor.getExistFolder() != null) {
                element2.setAttribute("or_exist_folder", compilerDescriptor.getExistFolder());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getVersionFlags() != null || compilerDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (compilerDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getVersionFlags());
            }
            if (compilerDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", compilerDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
        this.writeAlternativePath(document, element, compilerDescriptor);
        if (compilerDescriptor.getIncludeFlags() != null || compilerDescriptor.getIncludeParser() != null || compilerDescriptor.getRemoveIncludePathPrefix() != null || compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
            element2 = document.createElement("system_include_paths");
            if (compilerDescriptor.getIncludeFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getIncludeFlags());
            }
            if (compilerDescriptor.getIncludeParser() != null) {
                element2.setAttribute("parser", compilerDescriptor.getIncludeParser());
            }
            if (compilerDescriptor.getRemoveIncludePathPrefix() != null) {
                element2.setAttribute("remove_in_path", compilerDescriptor.getRemoveIncludePathPrefix());
            }
            if (compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
                element2.setAttribute("remove_in_output", compilerDescriptor.getRemoveIncludeOutputPrefix());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getUserIncludeFlag() != null) {
            element2 = document.createElement("user_include");
            element2.setAttribute("flags", compilerDescriptor.getUserIncludeFlag());
            element.appendChild(element2);
        }
        if (compilerDescriptor.getMacroFlags() != null || compilerDescriptor.getMacroParser() != null || compilerDescriptor.getPredefinedMacros() != null) {
            element2 = document.createElement("system_macros");
            if (compilerDescriptor.getMacroFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getMacroFlags());
            }
            if (compilerDescriptor.getMacroParser() != null) {
                element2.setAttribute("parser", compilerDescriptor.getMacroParser());
            }
            element.appendChild(element2);
            if (compilerDescriptor.getPredefinedMacros() != null) {
                for (ToolchainManager.PredefinedMacro predefinedMacro : compilerDescriptor.getPredefinedMacros()) {
                    Element element3 = document.createElement("macro");
                    element3.setAttribute("stringvalue", predefinedMacro.getMacro());
                    if (predefinedMacro.getFlags() != null) {
                        element3.setAttribute("flags", predefinedMacro.getFlags());
                    }
                    element2.appendChild(element3);
                }
            }
        }
        if (compilerDescriptor.getUserMacroFlag() != null) {
            element2 = document.createElement("user_macro");
            element2.setAttribute("flags", compilerDescriptor.getUserMacroFlag());
            element.appendChild(element2);
        }
        this.writeDevelopmentMode(document, element, compilerDescriptor);
        this.writeWarningLevel(document, element, compilerDescriptor);
        this.writeArchitecture(document, element, compilerDescriptor);
        if (compilerDescriptor.getStripFlag() != null) {
            element2 = document.createElement("strip");
            element2.setAttribute("flags", compilerDescriptor.getStripFlag());
            element.appendChild(element2);
        }
        this.writeMultithreading(document, element, compilerDescriptor);
        this.writeStandard(document, element, compilerDescriptor);
        this.writeLanguageExtension(document, element, compilerDescriptor);
        this.writeLibrary(document, element, compilerDescriptor);
        if (compilerDescriptor.getOutputObjectFileFlags() != null) {
            element2 = document.createElement("output_object_file");
            element2.setAttribute("flags", compilerDescriptor.getOutputObjectFileFlags());
            element.appendChild(element2);
        }
        if (compilerDescriptor.getDependencyGenerationFlags() != null) {
            element2 = document.createElement("dependency_generation");
            element2.setAttribute("flags", compilerDescriptor.getDependencyGenerationFlags());
            element.appendChild(element2);
        }
        if (compilerDescriptor.getPrecompiledHeaderFlags() != null || compilerDescriptor.getPrecompiledHeaderSuffix() != null) {
            element2 = document.createElement("precompiled_header");
            if (compilerDescriptor.getPrecompiledHeaderFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getPrecompiledHeaderFlags());
            }
            if (compilerDescriptor.getPrecompiledHeaderSuffix() != null) {
                element2.setAttribute("suffix", compilerDescriptor.getPrecompiledHeaderSuffix());
            }
            if (compilerDescriptor.getPrecompiledHeaderSuffixAppend()) {
                element2.setAttribute("append", "true");
            }
            element.appendChild(element2);
        }
    }

    private void writeDevelopmentMode(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getDevelopmentModeFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).developmentMode.default_selection;
        }
        Element element2 = document.createElement("development_mode");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"fast_build", "debug", "performance_debug", "test_coverage", "diagnosable_release", "release", "performance_release"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeWarningLevel(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getWarningLevelFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).warningLevel.default_selection;
        }
        Element element2 = document.createElement("warning_level");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"no_warnings", "default", "more_warnings", "warning2error"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeArchitecture(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getArchitectureFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).architecture.default_selection;
        }
        Element element2 = document.createElement("architecture");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"default", "bits_32", "bits_64"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeMultithreading(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getMultithreadingFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).multithreading.default_selection;
        }
        Element element2 = document.createElement("multithreading");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "safe", "automatic", "open_mp"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeStandard(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getStandardFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).standard.default_selection;
        }
        Element element2 = document.createElement("standard");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"old", "legacy", "default", "modern"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeLanguageExtension(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getLanguageExtensionFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).languageExtension.default_selection;
        }
        Element element2 = document.createElement("language_extension");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "default", "all"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeLibrary(Document document, Element element, ToolchainManager.CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getLibraryFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).library.default_selection;
        }
        Element element2 = document.createElement("library");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "runtime", "classic", "binary_standard", "conforming_standard"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeScanner(Document document, Element element, ToolchainManager.ScannerDescriptor scannerDescriptor) {
        Element element2;
        for (ToolchainManager.ScannerPattern object : scannerDescriptor.getPatterns()) {
            element2 = document.createElement(object.getSeverity());
            element2.setAttribute("pattern", object.getPattern());
            if (object.getLanguage() != null) {
                element2.setAttribute("language", object.getLanguage());
            }
            element.appendChild(element2);
        }
        if (scannerDescriptor.getStackHeaderPattern() != null) {
            element2 = document.createElement("stack_header");
            element2.setAttribute("pattern", scannerDescriptor.getStackHeaderPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getStackNextPattern() != null) {
            element2 = document.createElement("stack_next");
            element2.setAttribute("pattern", scannerDescriptor.getStackNextPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getEnterDirectoryPattern() != null) {
            element2 = document.createElement("enter_directory");
            element2.setAttribute("pattern", scannerDescriptor.getEnterDirectoryPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getChangeDirectoryPattern() != null) {
            element2 = document.createElement("change_directory");
            element2.setAttribute("pattern", scannerDescriptor.getChangeDirectoryPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getMakeAllInDirectoryPattern() != null) {
            element2 = document.createElement("making_all_in_directory");
            element2.setAttribute("pattern", scannerDescriptor.getMakeAllInDirectoryPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getLeaveDirectoryPattern() != null) {
            element2 = document.createElement("leave_directory");
            element2.setAttribute("pattern", scannerDescriptor.getLeaveDirectoryPattern());
            element.appendChild(element2);
        }
        for (String string : scannerDescriptor.getFilterOutPatterns()) {
            element2 = document.createElement("filter_out");
            element2.setAttribute("pattern", string);
            element.appendChild(element2);
        }
    }

    private void writeLinker(Document document, Element element, ToolchainManager.LinkerDescriptor linkerDescriptor) {
        Element element2;
        if (linkerDescriptor.getLibraryPrefix() != null) {
            element2 = document.createElement("library_prefix");
            element2.setAttribute("stringvalue", linkerDescriptor.getLibraryPrefix());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getLibrarySearchFlag() != null) {
            element2 = document.createElement("library_search");
            element2.setAttribute("flags", linkerDescriptor.getLibrarySearchFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibrarySearchFlag() != null) {
            element2 = document.createElement("dynamic_library_search");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibrarySearchFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getLibraryFlag() != null) {
            element2 = document.createElement("library_flag");
            element2.setAttribute("flags", linkerDescriptor.getLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getPICFlag() != null) {
            element2 = document.createElement("PIC");
            element2.setAttribute("flags", linkerDescriptor.getPICFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getStaticLibraryFlag() != null) {
            element2 = document.createElement("static_library");
            element2.setAttribute("flags", linkerDescriptor.getStaticLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibraryFlag() != null) {
            element2 = document.createElement("dynamic_library");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibraryBasicFlag() != null) {
            element2 = document.createElement("dynamic_library_basic");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibraryBasicFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getOutputFileFlag() != null) {
            element2 = document.createElement("output_file");
            element2.setAttribute("flags", linkerDescriptor.getOutputFileFlag());
            element.appendChild(element2);
        }
    }

    private void writeMake(Document document, Element element, ToolchainManager.MakeDescriptor makeDescriptor) {
        Element element2 = document.createElement("tool");
        element2.setAttribute("name", this.unsplit(makeDescriptor.getNames()));
        if (makeDescriptor.skipSearch()) {
            element2.setAttribute("skip", "true");
        }
        element.appendChild(element2);
        if (makeDescriptor.getVersionFlags() != null || makeDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (makeDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", makeDescriptor.getVersionFlags());
            }
            if (makeDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", makeDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
        this.writeAlternativePath(document, element, makeDescriptor);
        if (makeDescriptor.getDependencySupportCode() != null) {
            element2 = document.createElement("dependency_support");
            element2.setAttribute("code", makeDescriptor.getDependencySupportCode());
            element.appendChild(element2);
        }
    }

    private void writeDebugger(Document document, Element element, ToolchainManager.DebuggerDescriptor debuggerDescriptor) {
        Element element2 = document.createElement("tool");
        element2.setAttribute("name", this.unsplit(debuggerDescriptor.getNames()));
        if (debuggerDescriptor.skipSearch()) {
            element2.setAttribute("skip", "true");
        }
        element.appendChild(element2);
        if (debuggerDescriptor.getVersionFlags() != null || debuggerDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (debuggerDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", debuggerDescriptor.getVersionFlags());
            }
            if (debuggerDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", debuggerDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
        this.writeAlternativePath(document, element, debuggerDescriptor);
    }

    private void writeAlternativePath(Document document, Element element, ToolchainManager.ToolDescriptor toolDescriptor) {
        ToolchainManager.AlternativePath[] alternativePathArray = toolDescriptor.getAlternativePath();
        if (alternativePathArray != null) {
            Element element2 = document.createElement("alternative_path");
            element.appendChild(element2);
            block5: for (ToolchainManager.AlternativePath alternativePath : alternativePathArray) {
                Element element3 = document.createElement("path");
                element2.appendChild(element3);
                switch (alternativePath.getKind()) {
                    case PATH: {
                        element3.setAttribute("directory", alternativePath.getPath());
                        continue block5;
                    }
                    case TOOL_FAMILY: {
                        element3.setAttribute("toolchain_family", alternativePath.getPath());
                        continue block5;
                    }
                    case TOOL_NAME: {
                        element3.setAttribute("toolchain_name", alternativePath.getPath());
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CMakeDescriptorImpl
    extends ToolDescriptorImpl<CMake>
    implements ToolchainManager.CMakeDescriptor {
        public CMakeDescriptorImpl(CMake cMake) {
            super(cMake);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QMakeDescriptorImpl
    extends ToolDescriptorImpl<QMake>
    implements ToolchainManager.QMakeDescriptor {
        public QMakeDescriptorImpl(QMake qMake) {
            super(qMake);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DebuggerDescriptorImpl
    extends ToolDescriptorImpl<Debugger>
    implements ToolchainManager.DebuggerDescriptor {
        public DebuggerDescriptorImpl(Debugger debugger) {
            super(debugger);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MakeDescriptorImpl
    extends ToolDescriptorImpl<Make>
    implements ToolchainManager.MakeDescriptor {
        private MakeDescriptorImpl(Make make) {
            super(make);
        }

        @Override
        public String getDependencySupportCode() {
            return ((Make)this.tool).dependencySupportCode;
        }
    }

    private static final class LinkerDescriptorImpl
    implements ToolchainManager.LinkerDescriptor {
        private Linker l;

        private LinkerDescriptorImpl(Linker linker) {
            this.l = linker;
        }

        public String getLibrarySearchFlag() {
            return this.l.librarySearchFlag;
        }

        public String getDynamicLibrarySearchFlag() {
            return this.l.dynamicLibrarySearchFlag;
        }

        public String getLibraryFlag() {
            return this.l.libraryFlag;
        }

        public String getLibraryPrefix() {
            return this.l.library_prefix;
        }

        public String getPICFlag() {
            return this.l.PICFlag;
        }

        public String getStaticLibraryFlag() {
            return this.l.staticLibraryFlag;
        }

        public String getDynamicLibraryFlag() {
            return this.l.dynamicLibraryFlag;
        }

        public String getDynamicLibraryBasicFlag() {
            return this.l.dynamicLibraryBasicFlag;
        }

        public String getOutputFileFlag() {
            return this.l.outputFileFlag;
        }
    }

    private static final class ScannerPatternImpl
    implements ToolchainManager.ScannerPattern {
        private ErrorPattern e;

        private ScannerPatternImpl(ErrorPattern errorPattern) {
            this.e = errorPattern;
        }

        public String getPattern() {
            return this.e.pattern;
        }

        public String getSeverity() {
            return this.e.severity;
        }

        public String getLanguage() {
            return this.e.language;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerDescriptorImpl
    implements ToolchainManager.ScannerDescriptor {
        private Scanner s;
        private List<ToolchainManager.ScannerPattern> patterns;
        private List<String> filterOut;

        private ScannerDescriptorImpl(Scanner scanner) {
            this.s = scanner;
        }

        @Override
        public String getID() {
            return this.s.id;
        }

        @Override
        public List<ToolchainManager.ScannerPattern> getPatterns() {
            if (this.patterns == null) {
                this.patterns = new ArrayList<ToolchainManager.ScannerPattern>();
                for (ErrorPattern errorPattern : this.s.patterns) {
                    this.patterns.add(new ScannerPatternImpl(errorPattern));
                }
            }
            return this.patterns;
        }

        @Override
        public String getChangeDirectoryPattern() {
            return this.s.changeDirectoryPattern;
        }

        @Override
        public String getEnterDirectoryPattern() {
            return this.s.enterDirectoryPattern;
        }

        @Override
        public String getLeaveDirectoryPattern() {
            return this.s.leaveDirectoryPattern;
        }

        @Override
        public String getMakeAllInDirectoryPattern() {
            return this.s.makingAllInDirectoryPattern;
        }

        @Override
        public String getStackHeaderPattern() {
            return this.s.stackHeaderPattern;
        }

        @Override
        public String getStackNextPattern() {
            return this.s.stackNextPattern;
        }

        @Override
        public List<String> getFilterOutPatterns() {
            if (this.filterOut == null) {
                this.filterOut = new ArrayList<String>();
                if (this.s.filterOut != null) {
                    this.filterOut.addAll(this.s.filterOut);
                }
            }
            return this.filterOut;
        }
    }

    private static final class PredefinedMacroImpl
    implements ToolchainManager.PredefinedMacro {
        String macro;
        String flags;

        PredefinedMacroImpl(String string, String string2) {
            this.macro = string;
            this.flags = string2;
        }

        public String getMacro() {
            return this.macro;
        }

        public String getFlags() {
            return this.flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompilerDescriptorImpl
    extends ToolDescriptorImpl<Compiler>
    implements ToolchainManager.CompilerDescriptor {
        private CompilerDescriptorImpl(Compiler compiler) {
            super(compiler);
        }

        @Override
        public String getPathPattern() {
            return ((Compiler)this.tool).pathPattern;
        }

        @Override
        public String getExistFolder() {
            return ((Compiler)this.tool).existFolder;
        }

        @Override
        public String getIncludeFlags() {
            return ((Compiler)this.tool).includeFlags;
        }

        @Override
        public String getIncludeParser() {
            return ((Compiler)this.tool).includeOutputParser;
        }

        @Override
        public String getRemoveIncludePathPrefix() {
            return ((Compiler)this.tool).removeIncludePathPrefix;
        }

        @Override
        public String getRemoveIncludeOutputPrefix() {
            return ((Compiler)this.tool).removeIncludeOutputPrefix;
        }

        @Override
        public String getUserIncludeFlag() {
            return ((Compiler)this.tool).userIncludeFlag;
        }

        @Override
        public String getMacroFlags() {
            return ((Compiler)this.tool).macrosFlags;
        }

        @Override
        public String getMacroParser() {
            return ((Compiler)this.tool).macrosOutputParser;
        }

        @Override
        public List<ToolchainManager.PredefinedMacro> getPredefinedMacros() {
            return ((Compiler)this.tool).predefinedMacros;
        }

        @Override
        public String getUserMacroFlag() {
            return ((Compiler)this.tool).userMacroFlag;
        }

        @Override
        public String[] getDevelopmentModeFlags() {
            return ((Compiler)this.tool).developmentMode.values();
        }

        @Override
        public String[] getWarningLevelFlags() {
            return ((Compiler)this.tool).warningLevel.values();
        }

        @Override
        public String[] getArchitectureFlags() {
            return ((Compiler)this.tool).architecture.values();
        }

        @Override
        public String getStripFlag() {
            return ((Compiler)this.tool).strip;
        }

        @Override
        public String[] getMultithreadingFlags() {
            return ((Compiler)this.tool).multithreading.values();
        }

        @Override
        public String[] getStandardFlags() {
            return ((Compiler)this.tool).standard.values();
        }

        @Override
        public String[] getLanguageExtensionFlags() {
            return ((Compiler)this.tool).languageExtension.values();
        }

        @Override
        public String[] getLibraryFlags() {
            return ((Compiler)this.tool).library.values();
        }

        @Override
        public String getOutputObjectFileFlags() {
            return ((Compiler)this.tool).outputObjectFileFlags;
        }

        @Override
        public String getDependencyGenerationFlags() {
            return ((Compiler)this.tool).dependencyGenerationFlags;
        }

        @Override
        public String getPrecompiledHeaderFlags() {
            return ((Compiler)this.tool).precompiledHeaderFlags;
        }

        @Override
        public String getPrecompiledHeaderSuffix() {
            return ((Compiler)this.tool).precompiledHeaderSuffix;
        }

        @Override
        public boolean getPrecompiledHeaderSuffixAppend() {
            return ((Compiler)this.tool).precompiledHeaderSuffixAppend;
        }

        public String toString() {
            return "Path=" + this.getPathPattern() + " Folder=" + this.getExistFolder() + " Version=" + this.getVersionPattern();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolDescriptorImpl<T extends Tool>
    implements ToolchainManager.ToolDescriptor {
        protected T tool;

        public ToolDescriptorImpl(T t) {
            this.tool = t;
        }

        @Override
        public String[] getNames() {
            if (((Tool)this.tool).name != null && ((Tool)this.tool).name.length() > 0) {
                return ((Tool)this.tool).name.split(",");
            }
            return new String[0];
        }

        @Override
        public String getVersionFlags() {
            return ((Tool)this.tool).versionFlags;
        }

        @Override
        public String getVersionPattern() {
            return ((Tool)this.tool).versionPattern;
        }

        @Override
        public ToolchainManager.AlternativePath[] getAlternativePath() {
            if (((Tool)this.tool).alternativePath != null) {
                return ((Tool)this.tool).alternativePath.toArray(new ToolchainManager.AlternativePath[((Tool)this.tool).alternativePath.size()]);
            }
            return null;
        }

        @Override
        public boolean skipSearch() {
            return ((Tool)this.tool).skipSearch;
        }
    }

    private static class BaseFolderImpl
    implements ToolchainManager.BaseFolder {
        private FolderInfo info;

        public BaseFolderImpl(FolderInfo folderInfo) {
            this.info = folderInfo;
        }

        public String getFolderKey() {
            return this.info.folderKey;
        }

        public String getFolderPattern() {
            return this.info.folderPattern;
        }

        public String getFolderSuffix() {
            return this.info.folderSuffix;
        }

        public String getFolderPathPattern() {
            return this.info.folderPathPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ToolchainDescriptorImpl
    implements ToolchainManager.ToolchainDescriptor {
        CompilerVendor v;
        private ToolchainManager.CompilerDescriptor c;
        private ToolchainManager.CompilerDescriptor cpp;
        private ToolchainManager.CompilerDescriptor fortran;
        private ToolchainManager.CompilerDescriptor assembler;
        private ToolchainManager.LinkerDescriptor linker;
        private ToolchainManager.ScannerDescriptor scanner;
        private ToolchainManager.MakeDescriptor make;
        private ToolchainManager.DebuggerDescriptor debugger;
        private ToolchainManager.QMakeDescriptor qmake;
        private ToolchainManager.CMakeDescriptor cmake;

        private ToolchainDescriptorImpl(CompilerVendor compilerVendor) {
            this.v = compilerVendor;
        }

        @Override
        public String getFileName() {
            return this.v.toolChainFileName;
        }

        @Override
        public String getName() {
            return this.v.toolChainName;
        }

        @Override
        public String getDisplayName() {
            return this.v.toolChainDisplay;
        }

        @Override
        public String[] getFamily() {
            if (this.v.family != null && this.v.family.length() > 0) {
                return this.v.family.split(",");
            }
            return new String[0];
        }

        @Override
        public String[] getPlatforms() {
            if (this.v.platforms != null && this.v.platforms.length() > 0) {
                return this.v.platforms.split(",");
            }
            return new String[0];
        }

        @Override
        public String getUpdateCenterUrl() {
            return this.v.uc;
        }

        @Override
        public String getUpdateCenterDisplayName() {
            return this.v.ucName;
        }

        @Override
        public String getUpgradeUrl() {
            return this.v.upgrage;
        }

        @Override
        public String getModuleID() {
            return this.v.module;
        }

        @Override
        public boolean isAbstract() {
            return this.v.isAbstract;
        }

        @Override
        public String getDriveLetterPrefix() {
            return this.v.driveLetterPrefix;
        }

        @Override
        public String getMakefileWriter() {
            return this.v.makefileWriter;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getC() {
            if (this.c == null && this.v.c.isValid()) {
                this.c = new CompilerDescriptorImpl(this.v.c);
            }
            return this.c;
        }

        @Override
        public List<ToolchainManager.BaseFolder> getBaseFolders() {
            if (this.v.baseFolder == null) {
                return null;
            }
            ArrayList<ToolchainManager.BaseFolder> arrayList = new ArrayList<ToolchainManager.BaseFolder>(this.v.baseFolder.size());
            for (FolderInfo folderInfo : this.v.baseFolder) {
                arrayList.add(new BaseFolderImpl(folderInfo));
            }
            return arrayList;
        }

        @Override
        public List<ToolchainManager.BaseFolder> getCommandFolders() {
            if (this.v.commandFolder == null) {
                return null;
            }
            ArrayList<ToolchainManager.BaseFolder> arrayList = new ArrayList<ToolchainManager.BaseFolder>(this.v.baseFolder.size());
            for (FolderInfo folderInfo : this.v.commandFolder) {
                arrayList.add(new BaseFolderImpl(folderInfo));
            }
            return arrayList;
        }

        @Override
        public String getQmakeSpec() {
            return this.v.qmakespec;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getCpp() {
            if (this.cpp == null && this.v.cpp.isValid()) {
                this.cpp = new CompilerDescriptorImpl(this.v.cpp);
            }
            return this.cpp;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getFortran() {
            if (this.fortran == null && this.v.fortran.isValid()) {
                this.fortran = new CompilerDescriptorImpl(this.v.fortran);
            }
            return this.fortran;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getAssembler() {
            if (this.assembler == null && this.v.assembler.isValid()) {
                this.assembler = new CompilerDescriptorImpl(this.v.assembler);
            }
            return this.assembler;
        }

        @Override
        public ToolchainManager.ScannerDescriptor getScanner() {
            if (this.scanner == null) {
                this.scanner = new ScannerDescriptorImpl(this.v.scanner);
            }
            return this.scanner;
        }

        @Override
        public ToolchainManager.LinkerDescriptor getLinker() {
            if (this.linker == null) {
                this.linker = new LinkerDescriptorImpl(this.v.linker);
            }
            return this.linker;
        }

        @Override
        public ToolchainManager.MakeDescriptor getMake() {
            if (this.make == null) {
                this.make = new MakeDescriptorImpl(this.v.make);
            }
            return this.make;
        }

        @Override
        public Map<String, List<String>> getDefaultLocations() {
            return this.v.default_locations;
        }

        @Override
        public ToolchainManager.DebuggerDescriptor getDebugger() {
            if (this.debugger == null) {
                this.debugger = new DebuggerDescriptorImpl(this.v.debugger);
            }
            return this.debugger;
        }

        @Override
        public ToolchainManager.QMakeDescriptor getQMake() {
            if (this.qmake == null) {
                this.qmake = new QMakeDescriptorImpl(this.v.qmake);
            }
            return this.qmake;
        }

        @Override
        public ToolchainManager.CMakeDescriptor getCMake() {
            if (this.cmake == null) {
                this.cmake = new CMakeDescriptorImpl(this.v.cmake);
            }
            return this.cmake;
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SAXHandler
    extends DefaultHandler {
        private String path;
        private CompilerVendor v;
        private boolean isScanerOverrided = false;
        private int version = 1;
        private Map<String, String> cache;

        private SAXHandler(CompilerVendor compilerVendor, Map<String, String> map) {
            this.v = compilerVendor;
            this.cache = map;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.path != null) {
                this.path = this.path.equals(string3) ? null : this.path.substring(0, this.path.length() - string3.length() - 1);
            }
        }

        private String getValue(Attributes attributes, String string) {
            String string2 = attributes.getValue(string);
            if (string2 != null) {
                String string3 = this.cache.get(string2);
                if (string3 == null) {
                    this.cache.put(string2, string2);
                } else {
                    string2 = string3;
                }
            }
            return string2;
        }

        private String getValue(String string) {
            String string2 = this.cache.get(string);
            if (string2 == null) {
                this.cache.put(string, string);
            } else {
                string = string2;
            }
            return string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Compiler compiler;
            super.startElement(string, string2, string3, attributes);
            this.path = this.path == null ? string3 : this.path + "." + string3;
            if (this.path.equals("toolchaindefinition")) {
                String string4 = attributes.getValue("xmlns");
                if (string4 != null) {
                    int n = string4.lastIndexOf(47);
                    if (n >= 0 && n + 1 < string4.length()) {
                        String string5 = string4.substring(n + 1);
                        if (string5.length() > 0) {
                            try {
                                this.version = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (TRACE) {
                                    System.err.println("Incorrect version information:" + string4);
                                }
                            }
                        }
                    } else if (TRACE) {
                        System.err.println("Incorrect version information:" + string4);
                    }
                }
                return;
            }
            if (this.path.endsWith(".toolchain")) {
                this.v.toolChainName = this.getValue(attributes, "name");
                this.v.toolChainDisplay = this.getValue(attributes, "display");
                this.v.family = this.getValue(attributes, "family");
                this.v.qmakespec = this.getValue(attributes, "qmakespec");
                this.v.isAbstract = "true".equals(this.getValue(attributes, "abstract"));
                return;
            }
            if (this.path.endsWith(".platforms")) {
                this.v.platforms = this.getValue(attributes, "stringvalue");
                return;
            }
            if (this.path.endsWith(".download")) {
                this.v.uc = this.getValue(attributes, "uc_url");
                this.v.ucName = this.getValue(attributes, "uc_display");
                this.v.module = this.getValue(attributes, "module_id");
                this.v.upgrage = this.getValue(attributes, "upgrade_url");
                return;
            }
            if (this.path.endsWith(".drive_letter_prefix")) {
                this.v.driveLetterPrefix = this.getValue(attributes, "stringvalue");
                return;
            }
            if (this.path.endsWith(".makefile_writer")) {
                this.v.makefileWriter = this.getValue(attributes, "class");
                return;
            }
            if (this.path.endsWith(".base_folders.base_folder")) {
                if (this.v.baseFolder == null) {
                    this.v.baseFolder = new ArrayList<FolderInfo>();
                }
                FolderInfo folderInfo = new FolderInfo();
                this.v.baseFolder.add(folderInfo);
                folderInfo.folderKey = this.getValue(attributes, "regestry");
                folderInfo.folderPattern = this.getValue(attributes, "pattern");
                folderInfo.folderSuffix = this.getValue(attributes, "suffix");
                folderInfo.folderPathPattern = this.getValue(attributes, "path_patern");
                return;
            }
            if (this.path.endsWith(".command_folders.command_folder")) {
                if (this.v.commandFolder == null) {
                    this.v.commandFolder = new ArrayList<FolderInfo>();
                }
                FolderInfo folderInfo = new FolderInfo();
                this.v.commandFolder.add(folderInfo);
                folderInfo.folderKey = this.getValue(attributes, "regestry");
                folderInfo.folderPattern = this.getValue(attributes, "pattern");
                folderInfo.folderSuffix = this.getValue(attributes, "suffix");
                folderInfo.folderPathPattern = this.getValue(attributes, "path_patern");
                return;
            }
            if (this.path.indexOf(".default_locations.") > 0) {
                if (this.path.endsWith(".platform")) {
                    String string6 = this.getValue(attributes, "os");
                    String string7 = this.getValue(attributes, "directory");
                    if (string6 != null && string7 != null) {
                        List<String> list;
                        if (this.v.default_locations == null) {
                            this.v.default_locations = new HashMap<String, List<String>>();
                        }
                        if ((list = this.v.default_locations.get(string6)) == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(string7);
                        this.v.default_locations.put(string6, list);
                    }
                }
                return;
            }
            if (this.path.indexOf(".linker.") > 0) {
                Linker linker = this.v.linker;
                if (this.path.endsWith(".library_prefix")) {
                    linker.library_prefix = this.getValue(attributes, "stringvalue");
                    return;
                }
                if (this.path.endsWith(".library_search")) {
                    linker.librarySearchFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_search")) {
                    linker.dynamicLibrarySearchFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".library_flag")) {
                    linker.libraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".PIC")) {
                    linker.PICFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".static_library")) {
                    linker.staticLibraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library")) {
                    linker.dynamicLibraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_basic")) {
                    linker.dynamicLibraryBasicFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".output_file")) {
                    linker.outputFileFlag = this.getValue(attributes, "flags");
                    return;
                }
                return;
            }
            if (this.path.indexOf(".make.") > 0) {
                Make make = this.v.make;
                if (this.path.endsWith(".tool")) {
                    make.name = this.getValue(attributes, "name");
                    make.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    make.versionFlags = this.getValue(attributes, "flags");
                    make.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    make.alternativePath = new ArrayList();
                } else if (this.path.endsWith(".dependency_support")) {
                    make.dependencySupportCode = this.getValue(this.getValue(attributes, "code").replace("\\n", "\n"));
                } else if (this.checkAlternativePath(attributes, make.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.indexOf(".debugger.") > 0) {
                Debugger debugger = this.v.debugger;
                if (this.path.endsWith(".tool")) {
                    debugger.name = this.getValue(attributes, "name");
                    debugger.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    debugger.versionFlags = this.getValue(attributes, "flags");
                    debugger.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    debugger.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, debugger.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.indexOf(".qmake.") > 0) {
                QMake qMake = this.v.qmake;
                if (this.path.endsWith(".tool")) {
                    qMake.name = this.getValue(attributes, "name");
                    qMake.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    qMake.versionFlags = this.getValue(attributes, "flags");
                    qMake.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    qMake.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, qMake.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.indexOf(".cmake.") > 0) {
                CMake cMake = this.v.cmake;
                if (this.path.endsWith(".tool")) {
                    cMake.name = this.getValue(attributes, "name");
                    cMake.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    cMake.versionFlags = this.getValue(attributes, "flags");
                    cMake.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    cMake.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, cMake.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.endsWith(".scanner")) {
                if (!this.isScanerOverrided) {
                    this.v.scanner = new Scanner();
                    this.isScanerOverrided = true;
                    this.v.scanner.id = this.getValue(attributes, "id");
                }
                return;
            }
            if (this.path.indexOf(".scanner.") > 0) {
                Scanner scanner = this.v.scanner;
                if (this.path.endsWith(".error")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    scanner.patterns.add(errorPattern);
                    errorPattern.severity = "error";
                    errorPattern.pattern = this.getValue(attributes, "pattern");
                    errorPattern.language = this.getValue(attributes, "language");
                } else if (this.path.endsWith(".warning")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    scanner.patterns.add(errorPattern);
                    errorPattern.severity = "warning";
                    errorPattern.pattern = this.getValue(attributes, "pattern");
                    errorPattern.language = this.getValue(attributes, "language");
                } else if (this.path.endsWith(".change_directory")) {
                    scanner.changeDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".enter_directory")) {
                    scanner.enterDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".leave_directory")) {
                    scanner.leaveDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".stack_header")) {
                    scanner.stackHeaderPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".stack_next")) {
                    scanner.stackNextPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".filter_out")) {
                    scanner.filterOut.add(this.getValue(attributes, "pattern"));
                } else if (this.path.endsWith(".making_all_in_directory")) {
                    scanner.makingAllInDirectoryPattern = this.getValue(attributes, "pattern");
                }
                return;
            }
            if (this.path.indexOf(".c.") > 0) {
                compiler = this.v.c;
            } else if (this.path.indexOf(".cpp.") > 0) {
                compiler = this.v.cpp;
            } else if (this.path.indexOf(".fortran.") > 0) {
                compiler = this.v.fortran;
            } else if (this.path.indexOf(".assembler.") > 0) {
                compiler = this.v.assembler;
            } else {
                return;
            }
            if (this.path.endsWith(".compiler")) {
                compiler.name = this.getValue(attributes, "name");
                compiler.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                return;
            }
            if (this.path.endsWith(".recognizer")) {
                compiler.pathPattern = this.getValue(attributes, "pattern");
                compiler.existFolder = this.getValue(attributes, "or_exist_folder");
                return;
            }
            if (this.path.endsWith(".version")) {
                compiler.versionPattern = this.getValue(attributes, "pattern");
                compiler.versionFlags = this.getValue(attributes, "flags");
                return;
            }
            if (this.path.endsWith(".alternative_path")) {
                compiler.alternativePath = new ArrayList();
                return;
            }
            if (this.checkAlternativePath(attributes, compiler.alternativePath)) {
                return;
            }
            if (this.path.endsWith(".system_macros.macro")) {
                if (compiler.predefinedMacros == null) {
                    compiler.predefinedMacros = new ArrayList<ToolchainManager.PredefinedMacro>();
                }
                PredefinedMacroImpl predefinedMacroImpl = new PredefinedMacroImpl(this.getValue(attributes, "stringvalue"), this.getValue(attributes, "flags"));
                compiler.predefinedMacros.add(predefinedMacroImpl);
                return;
            }
            String string8 = this.getValue(attributes, "flags");
            if (string8 == null) {
                return;
            }
            boolean bl = "true".equals(this.getValue(attributes, "default"));
            if (this.path.endsWith(".system_include_paths")) {
                compiler.includeFlags = string8;
                compiler.includeOutputParser = this.getValue(attributes, "parser");
                compiler.removeIncludePathPrefix = this.getValue(attributes, "remove_in_path");
                compiler.removeIncludeOutputPrefix = this.getValue(attributes, "remove_in_output");
            } else if (this.path.endsWith(".user_include")) {
                compiler.userIncludeFlag = string8;
            } else if (this.path.endsWith(".system_macros")) {
                compiler.macrosFlags = string8;
                compiler.macrosOutputParser = this.getValue(attributes, "parser");
            } else if (this.path.endsWith(".user_macro")) {
                compiler.userMacroFlag = string8;
            } else if (this.path.indexOf(".development_mode.") > 0) {
                DevelopmentMode developmentMode = compiler.developmentMode;
                if (this.path.endsWith(".fast_build")) {
                    developmentMode.fast_build = string8;
                    if (bl) {
                        developmentMode.default_selection = 0;
                    }
                } else if (this.path.endsWith(".debug")) {
                    developmentMode.debug = string8;
                    if (bl) {
                        developmentMode.default_selection = 1;
                    }
                } else if (this.path.endsWith(".performance_debug")) {
                    developmentMode.performance_debug = string8;
                    if (bl) {
                        developmentMode.default_selection = 2;
                    }
                } else if (this.path.endsWith(".test_coverage")) {
                    developmentMode.test_coverage = string8;
                    if (bl) {
                        developmentMode.default_selection = 3;
                    }
                } else if (this.path.endsWith(".diagnosable_release")) {
                    developmentMode.diagnosable_release = string8;
                    if (bl) {
                        developmentMode.default_selection = 4;
                    }
                } else if (this.path.endsWith(".release")) {
                    developmentMode.release = string8;
                    if (bl) {
                        developmentMode.default_selection = 5;
                    }
                } else if (this.path.endsWith(".performance_release")) {
                    developmentMode.performance_release = string8;
                    if (bl) {
                        developmentMode.default_selection = 6;
                    }
                }
            } else if (this.path.indexOf(".warning_level.") > 0) {
                WarningLevel warningLevel = compiler.warningLevel;
                if (this.path.endsWith(".no_warnings")) {
                    warningLevel.no_warnings = string8;
                    if (bl) {
                        warningLevel.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    warningLevel.default_level = string8;
                    if (bl) {
                        warningLevel.default_selection = 1;
                    }
                } else if (this.path.endsWith(".more_warnings")) {
                    warningLevel.more_warnings = string8;
                    if (bl) {
                        warningLevel.default_selection = 2;
                    }
                } else if (this.path.endsWith(".warning2error")) {
                    warningLevel.warning2error = string8;
                    if (bl) {
                        warningLevel.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".architecture.") > 0) {
                Architecture architecture = compiler.architecture;
                if (this.path.endsWith(".default")) {
                    architecture.default_architecture = string8;
                    if (bl) {
                        architecture.default_selection = 0;
                    }
                } else if (this.path.endsWith(".bits_32")) {
                    architecture.bits_32 = string8;
                    if (bl) {
                        architecture.default_selection = 1;
                    }
                } else if (this.path.endsWith(".bits_64")) {
                    architecture.bits_64 = string8;
                    if (bl) {
                        architecture.default_selection = 2;
                    }
                }
            } else if (this.path.endsWith(".strip")) {
                compiler.strip = string8;
            } else if (this.path.endsWith(".output_object_file")) {
                compiler.outputObjectFileFlags = string8;
            } else if (this.path.endsWith(".dependency_generation")) {
                compiler.dependencyGenerationFlags = string8;
            } else if (this.path.endsWith(".precompiled_header")) {
                compiler.precompiledHeaderFlags = string8;
                compiler.precompiledHeaderSuffix = this.getValue(attributes, "suffix");
                compiler.precompiledHeaderSuffixAppend = Boolean.valueOf(this.getValue(attributes, "append"));
            } else if (this.path.indexOf(".multithreading.") > 0) {
                MultiThreading multiThreading = compiler.multithreading;
                if (this.path.endsWith(".none")) {
                    multiThreading.none = string8;
                    if (bl) {
                        multiThreading.default_selection = 0;
                    }
                } else if (this.path.endsWith(".safe")) {
                    multiThreading.safe = string8;
                    if (bl) {
                        multiThreading.default_selection = 1;
                    }
                } else if (this.path.endsWith(".automatic")) {
                    multiThreading.automatic = string8;
                    if (bl) {
                        multiThreading.default_selection = 2;
                    }
                } else if (this.path.endsWith(".open_mp")) {
                    multiThreading.open_mp = string8;
                    if (bl) {
                        multiThreading.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".standard.") > 0) {
                Standard standard = compiler.standard;
                if (this.path.endsWith(".old")) {
                    standard.old = string8;
                    if (bl) {
                        standard.default_selection = 0;
                    }
                } else if (this.path.endsWith(".legacy")) {
                    standard.legacy = string8;
                    if (bl) {
                        standard.default_selection = 1;
                    }
                } else if (this.path.endsWith(".default")) {
                    standard.default_standard = string8;
                    if (bl) {
                        standard.default_selection = 2;
                    }
                } else if (this.path.endsWith(".modern")) {
                    standard.modern = string8;
                    if (bl) {
                        standard.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".language_extension.") > 0) {
                LanguageExtension languageExtension = compiler.languageExtension;
                if (this.path.endsWith(".none")) {
                    languageExtension.none = string8;
                    if (bl) {
                        languageExtension.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    languageExtension.default_extension = string8;
                    if (bl) {
                        languageExtension.default_selection = 1;
                    }
                } else if (this.path.endsWith(".all")) {
                    languageExtension.all = string8;
                    if (bl) {
                        languageExtension.default_selection = 2;
                    }
                }
            } else if (this.path.indexOf(".library.") > 0) {
                Library library = compiler.library;
                if (this.path.endsWith(".none")) {
                    library.none = string8;
                    if (bl) {
                        library.default_selection = 0;
                    }
                } else if (this.path.endsWith(".runtime")) {
                    library.runtime = string8;
                    if (bl) {
                        library.default_selection = 1;
                    }
                } else if (this.path.endsWith(".classic")) {
                    library.classic = string8;
                    if (bl) {
                        library.default_selection = 2;
                    }
                } else if (this.path.endsWith(".binary_standard")) {
                    library.binary_standard = string8;
                    if (bl) {
                        library.default_selection = 3;
                    }
                } else if (this.path.endsWith(".conforming_standard")) {
                    library.conforming_standard = string8;
                    if (bl) {
                        library.default_selection = 4;
                    }
                }
            }
        }

        private boolean checkAlternativePath(Attributes attributes, List<ToolchainManager.AlternativePath> list) {
            if (this.path.endsWith(".alternative_path.path") && list != null) {
                String string = this.getValue(attributes, "directory");
                if (string != null) {
                    list.add(new Alternative(string, ToolchainManager.AlternativePath.PathKind.PATH));
                    return true;
                }
                string = this.getValue(attributes, "toolchain_family");
                if (string != null) {
                    list.add(new Alternative(string, ToolchainManager.AlternativePath.PathKind.TOOL_FAMILY));
                    return true;
                }
                string = this.getValue(attributes, "toolchain_name");
                if (string != null) {
                    list.add(new Alternative(string, ToolchainManager.AlternativePath.PathKind.TOOL_NAME));
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    static final class Library {
        String none;
        String runtime;
        String classic;
        String binary_standard;
        String conforming_standard;
        int default_selection = 0;

        Library() {
        }

        public boolean isValid() {
            return this.none != null && this.runtime != null && this.classic != null && this.binary_standard != null && this.conforming_standard != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.runtime, this.classic, this.binary_standard, this.conforming_standard};
            }
            return null;
        }
    }

    static final class LanguageExtension {
        String none;
        String default_extension;
        String all;
        int default_selection = 0;

        LanguageExtension() {
        }

        public boolean isValid() {
            return this.none != null && this.default_extension != null && this.all != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.default_extension, this.all};
            }
            return null;
        }
    }

    static final class Standard {
        String old;
        String legacy;
        String default_standard;
        String modern;
        int default_selection = 0;

        Standard() {
        }

        public boolean isValid() {
            return this.old != null && this.legacy != null && this.default_standard != null && this.modern != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.old, this.legacy, this.default_standard, this.modern};
            }
            return null;
        }
    }

    static final class MultiThreading {
        String none;
        String safe;
        String automatic;
        String open_mp;
        int default_selection = 0;

        MultiThreading() {
        }

        public boolean isValid() {
            return this.none != null && this.safe != null && this.automatic != null && this.open_mp != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.safe, this.automatic, this.open_mp};
            }
            return null;
        }
    }

    static final class Architecture {
        String default_architecture;
        String bits_32;
        String bits_64;
        int default_selection = 0;

        Architecture() {
        }

        public boolean isValid() {
            return this.default_architecture != null && this.bits_32 != null && this.bits_64 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.default_architecture, this.bits_32, this.bits_64};
            }
            return null;
        }
    }

    static final class WarningLevel {
        String no_warnings;
        String default_level;
        String more_warnings;
        String warning2error;
        int default_selection = 0;

        WarningLevel() {
        }

        public boolean isValid() {
            return this.no_warnings != null && this.default_level != null && this.more_warnings != null && this.warning2error != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.no_warnings, this.default_level, this.more_warnings, this.warning2error};
            }
            return null;
        }
    }

    static final class DevelopmentMode {
        String fast_build;
        String debug;
        String performance_debug;
        String test_coverage;
        String diagnosable_release;
        String release;
        String performance_release;
        int default_selection = 0;

        DevelopmentMode() {
        }

        public boolean isValid() {
            return this.fast_build != null && this.debug != null && this.performance_debug != null && this.test_coverage != null && this.diagnosable_release != null && this.release != null && this.performance_release != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.fast_build, this.debug, this.performance_debug, this.test_coverage, this.diagnosable_release, this.release, this.performance_release};
            }
            return null;
        }
    }

    static final class CMake
    extends Tool {
        CMake() {
        }
    }

    static final class QMake
    extends Tool {
        QMake() {
        }
    }

    static final class Debugger
    extends Tool {
        Debugger() {
        }
    }

    static final class Make
    extends Tool {
        String dependencySupportCode;

        Make() {
        }
    }

    static final class Linker {
        String library_prefix;
        String librarySearchFlag;
        String dynamicLibrarySearchFlag;
        String libraryFlag;
        String PICFlag;
        String staticLibraryFlag;
        String dynamicLibraryFlag;
        String dynamicLibraryBasicFlag;
        String outputFileFlag;

        Linker() {
        }
    }

    static final class ErrorPattern {
        String pattern;
        String severity;
        String language;

        ErrorPattern() {
        }
    }

    static final class Scanner {
        String id;
        List<ErrorPattern> patterns = new ArrayList<ErrorPattern>();
        String changeDirectoryPattern;
        String enterDirectoryPattern;
        String leaveDirectoryPattern;
        String makingAllInDirectoryPattern;
        String stackHeaderPattern;
        String stackNextPattern;
        List<String> filterOut = new ArrayList<String>();

        Scanner() {
        }
    }

    public static final class Compiler
    extends Tool {
        String pathPattern;
        String existFolder;
        String includeFlags;
        String includeOutputParser;
        String removeIncludePathPrefix;
        String removeIncludeOutputPrefix;
        String userIncludeFlag;
        String macrosFlags;
        String macrosOutputParser;
        String userMacroFlag;
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        String outputObjectFileFlags;
        String dependencyGenerationFlags;
        String precompiledHeaderFlags;
        String precompiledHeaderSuffix;
        boolean precompiledHeaderSuffixAppend;
        DevelopmentMode developmentMode = new DevelopmentMode();
        WarningLevel warningLevel = new WarningLevel();
        Architecture architecture = new Architecture();
        String strip;
        MultiThreading multithreading = new MultiThreading();
        Standard standard = new Standard();
        LanguageExtension languageExtension = new LanguageExtension();
        Library library = new Library();

        public boolean isValid() {
            return this.name != null && this.name.length() > 0;
        }
    }

    static class Alternative
    implements ToolchainManager.AlternativePath {
        String path;
        ToolchainManager.AlternativePath.PathKind kind;

        Alternative(String string, ToolchainManager.AlternativePath.PathKind pathKind) {
            this.path = string;
            this.kind = pathKind;
        }

        public String getPath() {
            return this.path;
        }

        public ToolchainManager.AlternativePath.PathKind getKind() {
            return this.kind;
        }
    }

    public static class Tool {
        String name;
        String versionFlags;
        String versionPattern;
        boolean skipSearch;
        List<ToolchainManager.AlternativePath> alternativePath;
    }

    static final class FolderInfo {
        String folderKey;
        String folderPattern;
        String folderSuffix;
        String folderPathPattern;

        FolderInfo() {
        }
    }

    static final class CompilerVendor {
        final String toolChainFileName;
        String toolChainName;
        String toolChainDisplay;
        Map<String, List<String>> default_locations;
        String family;
        String platforms;
        String uc;
        String ucName;
        String upgrage;
        String module;
        boolean isAbstract;
        String driveLetterPrefix;
        List<FolderInfo> baseFolder;
        List<FolderInfo> commandFolder;
        String qmakespec;
        String makefileWriter;
        Compiler c = new Compiler();
        Compiler cpp = new Compiler();
        Compiler fortran = new Compiler();
        Compiler assembler = new Compiler();
        Scanner scanner = new Scanner();
        Linker linker = new Linker();
        Make make = new Make();
        Debugger debugger = new Debugger();
        QMake qmake = new QMake();
        CMake cmake = new CMake();

        private CompilerVendor(String string) {
            this.toolChainFileName = string;
        }

        public boolean isValid() {
            return this.toolChainName != null && this.toolChainName.length() > 0 && (this.c.isValid() || this.cpp.isValid() || this.fortran.isValid());
        }
    }
}

