/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public final class MidpVersionable {
    public static final Versionable MIDP = new Versionable(){

        public boolean isCompatibleWith(Versionable versionable) {
            return versionable == MIDP || versionable == MIDP_1 || versionable == MIDP_2;
        }

        public boolean isAvailable(DesignDocument designDocument) {
            if (designDocument == null) {
                return false;
            }
            DesignComponent designComponent = designDocument.getRootComponent();
            if (designComponent == null) {
                return false;
            }
            PropertyValue propertyValue = designComponent.readProperty("version");
            String string = MidpTypes.getString(propertyValue);
            return string != null && string.startsWith("MIDP");
        }
    };
    public static final Versionable MIDP_1 = new Versionable(){

        public boolean isCompatibleWith(Versionable versionable) {
            return versionable == MIDP || versionable == MIDP_1;
        }

        public boolean isAvailable(DesignDocument designDocument) {
            if (designDocument == null) {
                return false;
            }
            DesignComponent designComponent = designDocument.getRootComponent();
            if (designComponent == null) {
                return false;
            }
            PropertyValue propertyValue = designComponent.readProperty("version");
            String string = MidpTypes.getString(propertyValue);
            return "MIDP-1.0".equals(string);
        }
    };
    public static final Versionable MIDP_2 = new Versionable(){

        public boolean isCompatibleWith(Versionable versionable) {
            return versionable == MIDP || versionable == MIDP_2;
        }

        public boolean isAvailable(DesignDocument designDocument) {
            if (designDocument == null) {
                return false;
            }
            DesignComponent designComponent = designDocument.getRootComponent();
            if (designComponent == null) {
                return false;
            }
            PropertyValue propertyValue = designComponent.readProperty("version");
            String string = MidpTypes.getString(propertyValue);
            return "MIDP-2.0".equals(string);
        }
    };
}

