/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.packets.BaseMessageChildElement;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.w3c.dom.Node;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
extends BaseMessageChildElement {
    static final String PROPERTY = "property";
    private static final String NUMCHILDREN = "numchildren";
    static final String ENCODING = "encoding";
    private static final String KEY = "key";
    private static final String ADDRESS = "address";
    private static final String PAGESIZE = "pagesize";
    private static final String PAGE = "page";
    private static final String NAME = "name";
    private static final String FULL_NAME = "fullname";
    private static final String TYPE = "type";
    private static final String CLASS_NAME = "classname";
    private static final String CONSTANT = "constant";
    private static final String CHILDREN = "children";
    private static final String FACET = "facet";
    static final String SIZE = "size";

    Property(Node node) {
        super(node);
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public void setName(String string) {
        Node node = this.getNode().getAttributes().getNamedItem(NAME);
        if (node == null) {
            node = this.getNode().getOwnerDocument().createAttribute(NAME);
            this.getNode().appendChild(node);
        }
        node.setNodeValue(string);
    }

    public String getFullName() {
        return this.getAttribute(FULL_NAME);
    }

    public String getType() {
        return this.getAttribute(TYPE);
    }

    public String getClassName() {
        return this.getAttribute(CLASS_NAME);
    }

    public boolean isConstant() {
        return this.getInt(CONSTANT) > 0;
    }

    public boolean hasChildren() {
        return this.getInt(CHILDREN) > 0;
    }

    public int getSize() {
        return this.getInt(SIZE);
    }

    public int getPage() {
        return this.getInt(PAGE);
    }

    public int getPageSize() {
        return this.getInt(PAGESIZE);
    }

    public int getAddress() {
        return this.getInt(ADDRESS);
    }

    public String getKey() {
        return this.getAttribute(KEY);
    }

    public String getFacet() {
        return this.getAttribute(FACET);
    }

    public Encoding getEncoding() {
        String string = this.getAttribute(ENCODING);
        return Encoding.forString(string);
    }

    public int getChildrenSize() {
        return this.getInt(NUMCHILDREN);
    }

    public List<Property> getChildren() {
        List<Node> list = this.getChildren(PROPERTY);
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        for (Node node : list) {
            arrayList.add(new Property(node));
        }
        return arrayList;
    }

    public byte[] getValue() throws UnsufficientValueException {
        String string = DbgpMessage.getNodeValue(this.getNode());
        byte[] byArray = null;
        if (string == null) {
            byArray = new byte[]{};
        } else {
            Encoding encoding = this.getEncoding();
            if (Encoding.NONE.equals((Object)encoding) || encoding == null) {
                try {
                    byArray = string.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    assert (false);
                    byArray = new byte[]{};
                }
            }
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                byArray = bASE64Decoder.decodeBuffer(string);
            }
            catch (IOException iOException) {
                byArray = new byte[]{};
            }
        }
        return this.getValue(byArray);
    }

    public String getStringValue() throws UnsufficientValueException {
        Encoding encoding = this.getEncoding();
        if (Encoding.BASE64.equals((Object)encoding)) {
            return new String(this.getValue());
        }
        String string = DbgpMessage.getNodeValue(this.getNode());
        try {
            if (string != null && string.getBytes("ISO-8859-1").length < this.getSize()) {
                throw new UnsufficientValueException();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return "";
        }
        return string;
    }

    public static boolean equals(Property property, Property property2) {
        byte[] byArray;
        byte[] byArray2;
        if (property == null) {
            return property2 == null;
        }
        try {
            byArray2 = property.getValue();
        }
        catch (UnsufficientValueException unsufficientValueException) {
            return false;
        }
        if (property2 == null) {
            return false;
        }
        try {
            byArray = property2.getValue();
        }
        catch (UnsufficientValueException unsufficientValueException) {
            return false;
        }
        return Arrays.equals(byArray2, byArray);
    }

    private byte[] getValue(byte[] byArray) throws UnsufficientValueException {
        if (byArray.length >= this.getSize()) {
            return byArray;
        }
        throw new UnsufficientValueException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encoding {
        BASE64,
        NONE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        static Encoding forString(String string) {
            Encoding[] encodingArray;
            for (Encoding encoding : encodingArray = Encoding.values()) {
                if (!encoding.toString().equals(string)) continue;
                return encoding;
            }
            return null;
        }
    }
}

