/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;

public class BrkpntSetCommand
extends DbgpCommand {
    public static final String BREAKPOINT_SET = "breakpoint_set";
    private static final String TYPE_ARG = "-t ";
    private static final String FILE_ARG = "-f ";
    private static final String LINE_ARG = "-n ";
    private static final String STATE_ARG = "-s ";
    private static final String TEMP_ARG = "-r ";
    private static final String FUNC_ARG = "-m ";
    private static final String EXCEPTION_ARG = "-x";
    protected static final String SPACE = " ";
    private String myFunction;
    private Types myType;
    private String myFile;
    private String myException;
    private State myState = State.ENABLED;
    private int myLineNumber = -1;
    private String myExpression;
    private boolean isTemporary;
    private int myHitCount = -1;
    private int myHitValue = -1;
    private String myHitCondition;
    private AbstractBreakpoint myBrkpnt;

    BrkpntSetCommand(String string) {
        this(BREAKPOINT_SET, string);
    }

    BrkpntSetCommand(String string, String string2) {
        super(string, string2);
    }

    public boolean wantAcknowledgment() {
        return true;
    }

    public void setBreakpoint(AbstractBreakpoint abstractBreakpoint) {
        this.myBrkpnt = abstractBreakpoint;
    }

    public AbstractBreakpoint getBreakpoint() {
        return this.myBrkpnt;
    }

    public void setType(Types types) {
        this.myType = types;
    }

    public void setFile(String string) {
        this.myFile = string;
    }

    public void setFunction(String string) {
        this.myFunction = string;
    }

    public void setException(String string) {
        this.myException = string;
    }

    public void setState(State state) {
        this.myState = state;
    }

    public void setLineNumber(int n) {
        this.myLineNumber = n;
    }

    public void setExpression(String string) {
        this.myException = string;
    }

    public void setTemporary(boolean bl) {
        this.isTemporary = bl;
    }

    public void setHitCount(int n) {
        this.myHitCount = n;
    }

    public void setHitValue(int n) {
        this.myHitValue = n;
    }

    public void setHitCondition(String string) {
        this.myHitCondition = string;
    }

    protected String getData() {
        return this.myExpression;
    }

    protected String getArguments() {
        assert (this.myType != null);
        StringBuilder stringBuilder = new StringBuilder();
        this.setType(stringBuilder);
        this.setState(stringBuilder);
        this.setTemporary(stringBuilder);
        switch (this.myType) {
            case LINE: {
                this.setLineArguments(stringBuilder);
                break;
            }
            case CALL: {
                this.setCallArguments(stringBuilder);
                break;
            }
            case RETURN: {
                this.setReturnArguments(stringBuilder);
                break;
            }
            case EXCEPTION: {
                this.setExceptionArguments(stringBuilder);
                break;
            }
            case CONDITIONAL: {
                this.setConditionalArguments(stringBuilder);
                break;
            }
            case WATCH: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return stringBuilder.toString();
    }

    private void setTemporary(StringBuilder stringBuilder) {
        if (this.isTemporary) {
            stringBuilder.append(SPACE);
            stringBuilder.append(TEMP_ARG);
            stringBuilder.append(1);
        }
    }

    private void setState(StringBuilder stringBuilder) {
        if (this.myState != null) {
            stringBuilder.append(SPACE);
            stringBuilder.append(STATE_ARG);
            stringBuilder.append(this.myState.toString());
        }
    }

    private void setConditionalArguments(StringBuilder stringBuilder) {
        stringBuilder.append(SPACE);
        stringBuilder.append(FILE_ARG);
        stringBuilder.append(this.myFile);
        if (this.myLineNumber > -1) {
            stringBuilder.append(SPACE);
            stringBuilder.append(FILE_ARG);
            stringBuilder.append(this.myFile);
        }
    }

    private void setExceptionArguments(StringBuilder stringBuilder) {
        stringBuilder.append(SPACE);
        stringBuilder.append(EXCEPTION_ARG);
        stringBuilder.append(this.myException);
    }

    private void setReturnArguments(StringBuilder stringBuilder) {
        this.setCallArguments(stringBuilder);
    }

    private void setCallArguments(StringBuilder stringBuilder) {
        stringBuilder.append(SPACE);
        stringBuilder.append(FUNC_ARG);
        stringBuilder.append(this.myFunction);
    }

    private void setLineArguments(StringBuilder stringBuilder) {
        stringBuilder.append(SPACE);
        stringBuilder.append(FILE_ARG);
        stringBuilder.append(this.myFile);
        stringBuilder.append(SPACE);
        stringBuilder.append(LINE_ARG);
        stringBuilder.append(this.myLineNumber + 1);
    }

    private void setType(StringBuilder stringBuilder) {
        stringBuilder.append(TYPE_ARG);
        stringBuilder.append(this.myType.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ENABLED,
        DISABLED;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static State forString(String string) {
            State[] stateArray;
            for (State state : stateArray = State.values()) {
                if (!state.toString().equals(string)) continue;
                return state;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Types {
        LINE,
        CALL,
        RETURN,
        EXCEPTION,
        CONDITIONAL,
        WATCH;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

