/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.indicators.ClockIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClockIndicator
extends Indicator<ClockIndicatorConfiguration> {
    private static final int SECOND_IN_MILLISECONDS = 1000;
    private ClockPanel panel = new ClockPanel();
    private long currentTime;

    public ClockIndicator(ClockIndicatorConfiguration clockIndicatorConfiguration) {
        super((IndicatorConfiguration)clockIndicatorConfiguration);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updated(List<DataRow> list) {
        if (list.isEmpty()) {
            return;
        }
        DataRow dataRow = list.get(list.size() - 1);
        this.currentTime = dataRow.getLongValue(this.getMetadataColumnName(0));
        this.panel.update();
    }

    protected void tick() {
    }

    protected void repairNeeded(boolean bl) {
    }

    public void reset() {
    }

    public void setIndicatorActionsProviderContext(Lookup lookup) {
    }

    private class ClockPanel
    extends JPanel {
        private JLabel timeLabel = new JLabel("00:00:00");

        public ClockPanel() {
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.timeLabel, "Center");
        }

        private void update() {
            int n = (int)ClockIndicator.this.currentTime / 1000;
            int n2 = n / 3600;
            int n3 = (n - n2 * 60 * 60) / 60;
            int n4 = n - n2 * 60 * 60 - n3 * 60;
            String string = (n2 < 10 ? "0" : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4;
            this.timeLabel.setText(string);
        }
    }
}

