/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;

public abstract class BeanInputDialog
extends InputDialog {
    public static final String USER_DATA_CHANGED = "UserDataChanged";
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private JPanel parentPanel;
    private JPanel dialogPanel;
    private boolean editmode;
    protected ValidationSupport validationSupport;

    public BeanInputDialog(JPanel jPanel, String string, Object[] objectArray) {
        this(jPanel, string, false, objectArray);
    }

    public BeanInputDialog(JPanel jPanel, String string, boolean bl, Object[] objectArray) {
        super(jPanel, string, bl);
        this.editmode = true;
        this.parentPanel = jPanel;
        this.dialogPanel = this.getDialogPanel(objectArray);
        this.validationSupport = new ValidationSupport();
        this.initComponents();
    }

    public BeanInputDialog(JPanel jPanel, String string) {
        this(jPanel, string, false);
    }

    public BeanInputDialog(JPanel jPanel, String string, boolean bl) {
        super(jPanel, string, bl);
        this.editmode = false;
        this.parentPanel = jPanel;
        this.dialogPanel = this.getDialogPanel();
        this.validationSupport = new ValidationSupport();
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.addListeners();
        this.adjustSize();
        this.pack();
        this.setLocationInside(this.parentPanel);
        this.handleErrorDisplay();
    }

    private void adjustSize() {
        int n = this.parentPanel.getWidth() * 3 / 4;
        int n2 = this.getNOofFields();
        if (-1 != n2) {
            Dimension dimension = this.getContentPane().getPreferredSize();
            int n3 = (int)this.dialogPanel.getPreferredSize().getHeight();
            if ((double)n < dimension.getWidth()) {
                n = (int)dimension.getWidth();
            }
            if ((double)n3 < dimension.getHeight()) {
                n3 = (int)dimension.getHeight();
            }
        }
    }

    protected int getNOofFields() {
        return -1;
    }

    protected abstract Object[] getValues();

    protected abstract Collection getErrors();

    protected abstract JPanel getDialogPanel();

    protected abstract JPanel getDialogPanel(Object[] var1);

    protected abstract String getHelpId();

    private void addListeners() {
        this.dialogPanel.addPropertyChangeListener(USER_DATA_CHANGED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BeanInputDialog.this.handleErrorDisplay();
            }
        });
    }

    private void handleErrorDisplay() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.hasDuplicateEntry()) {
            arrayList.add(this.bundle.getString("ERR_ObjectIsDuplicate"));
        } else {
            arrayList.addAll(this.getErrors());
        }
        this.setErrors(arrayList);
    }

    protected boolean hasDuplicateEntry() {
        boolean bl = false;
        if (this.parentPanel instanceof BeanTablePanel) {
            BeanTablePanel beanTablePanel = (BeanTablePanel)this.parentPanel;
            BeanTableModel beanTableModel = beanTablePanel.getModel();
            Object[] objectArray = this.getValues();
            if (!this.editmode && beanTableModel.alreadyExists(objectArray)) {
                bl = true;
            }
        }
        return bl;
    }

    protected BeanTableModel getModel() {
        BeanTableModel beanTableModel = null;
        if (this.parentPanel instanceof BeanTablePanel) {
            BeanTablePanel beanTablePanel = (BeanTablePanel)this.parentPanel;
            beanTableModel = beanTablePanel.getModel();
        }
        return beanTableModel;
    }
}

