/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.awt.event.ItemEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import javax.swing.SwingUtilities;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class Utils
implements Constants {
    private static final String[] booleanStrings = new String[]{"0", "1", "false", "true", "no", "yes", "off", "on"};

    private Utils() {
    }

    public static boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean strEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean strEquals(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 == null : (string2 == null ? false : string.equals(string2));
        return bl;
    }

    public static boolean strEquivalent(String string, String string2) {
        boolean bl = false;
        if (Utils.strEmpty(string) && Utils.strEmpty(string2)) {
            bl = true;
        } else if (string != null && string2 != null) {
            bl = string.equals(string2);
        }
        return bl;
    }

    public static int strCompareTo(String string, String string2) {
        int n = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
        return n;
    }

    public static boolean hasTrailingSlash(String string) {
        return string.charAt(string.length() - 1) == '/';
    }

    public static boolean containsWhitespace(String string) {
        boolean bl = false;
        if (Utils.notEmpty(string)) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!Character.isSpaceChar(string.charAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isJavaIdentifier(String string) {
        boolean bl = true;
        if (!Utils.notEmpty(string) || !Character.isJavaIdentifierStart(string.charAt(0))) {
            bl = false;
        } else {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isJavaPackage(String string) {
        boolean bl = false;
        if (Utils.notEmpty(string)) {
            int n = 0;
            int n2 = string.length();
            block4: for (int i = 0; i < n2 && n < 2; ++i) {
                switch (n) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(string.charAt(i))) {
                            n = 1;
                            continue block4;
                        }
                        n = 2;
                        continue block4;
                    }
                    case 1: {
                        if (string.charAt(i) == '.') {
                            n = 0;
                            continue block4;
                        }
                        if (Character.isJavaIdentifierPart(string.charAt(i))) continue block4;
                        n = 2;
                    }
                }
            }
            if (n == 1) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isJavaClass(String string) {
        return Utils.isJavaPackage(string);
    }

    public static boolean booleanValueOf(String string) {
        boolean bl = false;
        int n = -1;
        if (string != null && string.length() > 0) {
            string = string.trim();
            for (int i = 0; i < booleanStrings.length; ++i) {
                if (string.compareToIgnoreCase(booleanStrings[i]) != 0) continue;
                n = i;
                break;
            }
        }
        if (n >= 0 && n % 2 == 1) {
            bl = true;
        }
        return bl;
    }

    public static String encodeUrlField(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.replace(' ', '_');
        }
        if (string2 != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer(string2.length() + 10);
                String[] stringArray = string2.split("/");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(URLEncoder.encode(stringArray[i], "UTF-8"));
                    if (i == stringArray.length - 1) continue;
                    stringBuffer.append("/");
                }
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return string2;
    }

    public static URL getResourceURL(String string, Class clazz) {
        URL uRL = null;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            uRL = uRLClassLoader.findResource(string);
        } else {
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    public static void invokeHelp(String string) {
        Utils.invokeHelp(new HelpCtx(string));
    }

    public static void invokeHelp(final HelpCtx helpCtx) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Help)Lookup.getDefault().lookup(Help.class)).showHelp(helpCtx);
            }
        });
    }

    public static boolean interpretCheckboxState(ItemEvent itemEvent) {
        boolean bl = false;
        if (itemEvent.getStateChange() == 1) {
            bl = true;
        } else if (itemEvent.getStateChange() == 2) {
            bl = false;
        }
        return bl;
    }
}

