/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorActionListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorRepairActionProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorTickerService;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Indicator<T extends IndicatorConfiguration>
implements DLightTargetListener,
ChangeListener,
IndicatorNotificationsListener {
    private static final int PADDING = 2;
    private final Object lock = new Object();
    private final IndicatorMetadata metadata;
    private final int position;
    private String toolID;
    private String toolDecsription;
    private String actionTooltip;
    private String actionDisplayName;
    private final List<IndicatorActionListener> listeners;
    private final TickerListener tickerListener;
    private IndicatorRepairActionProvider indicatorRepairActionProvider = null;
    private DLightTarget target;
    private boolean visible;
    private final Action defaultAction;
    private final Collection<DataTableMetadata.Column> columnsProvided = new ArrayList<DataTableMetadata.Column>();
    private List<VisualizerConfiguration> visualizerConfigurations;

    protected final void notifyListeners(String string) {
        for (VisualizerConfiguration visualizerConfiguration : this.visualizerConfigurations) {
            if (!visualizerConfiguration.getID().equals(string)) continue;
            this.notifyListeners(visualizerConfiguration);
        }
    }

    protected final String getDescription() {
        return this.toolDecsription;
    }

    protected final String getActionTooltip() {
        if (this.actionTooltip == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.actionTooltip.replaceAll("\n", "<br>"));
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    private void notifyListeners(VisualizerConfiguration visualizerConfiguration) {
        for (IndicatorActionListener indicatorActionListener : this.listeners) {
            indicatorActionListener.openVisualizerForIndicator(this, visualizerConfiguration);
        }
    }

    protected final void notifyListeners() {
        for (IndicatorActionListener indicatorActionListener : this.listeners) {
            indicatorActionListener.mouseClickedOnIndicator(this);
        }
    }

    protected Indicator(T t) {
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.metadata = IndicatorConfigurationAccessor.getDefault().getIndicatorMetadata((IndicatorConfiguration)t);
        this.visualizerConfigurations = IndicatorConfigurationAccessor.getDefault().getVisualizerConfigurations((IndicatorConfiguration)t);
        this.position = IndicatorConfigurationAccessor.getDefault().getIndicatorPosition((IndicatorConfiguration)t);
        this.actionDisplayName = IndicatorConfigurationAccessor.getDefault().getActionDisplayName((IndicatorConfiguration)t);
        this.actionTooltip = IndicatorConfigurationAccessor.getDefault().getActionTooltip((IndicatorConfiguration)t);
        this.tickerListener = new TickerListener(){

            public void tick() {
                Indicator.this.tick();
            }
        };
        this.visible = ((IndicatorConfiguration)t).isVisible();
        this.setIndicatorActionsProviderContext(Lookup.EMPTY);
        this.defaultAction = new AbstractAction(this.actionDisplayName){

            public void actionPerformed(ActionEvent actionEvent) {
                Indicator.this.notifyListeners();
            }
        };
        this.defaultAction.putValue("Name", this.actionDisplayName);
        if (this.actionTooltip != null) {
            this.defaultAction.putValue("ShortDescription", this.getActionTooltip());
        }
    }

    public abstract void setIndicatorActionsProviderContext(Lookup var1);

    public final Action getDefaultAction() {
        return this.defaultAction;
    }

    protected abstract void repairNeeded(boolean var1);

    private void setRepairActionProviderFor(IndicatorRepairActionProvider indicatorRepairActionProvider) {
        this.indicatorRepairActionProvider = indicatorRepairActionProvider;
        this.indicatorRepairActionProvider.addChangeListener(this);
        this.repairNeeded(true);
    }

    public final int getPosition() {
        return this.position;
    }

    protected final IndicatorRepairActionProvider getRepairActionProvider() {
        return this.indicatorRepairActionProvider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl;
        if (this.indicatorRepairActionProvider == null || changeEvent.getSource() != this.indicatorRepairActionProvider) {
            return;
        }
        boolean bl2 = bl = this.indicatorRepairActionProvider.needRepair() || !this.indicatorRepairActionProvider.getValidationStatus().isValid();
        if (!bl) {
            this.indicatorRepairActionProvider.removeChangeListener(this);
        }
        this.repairNeeded(bl);
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                return;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            this.target = dLightTarget;
            IndicatorTickerService.getInstance().subsribe(this.tickerListener);
            this.targetStarted();
        }
    }

    protected void targetStarted() {
    }

    protected final Collection<DataTableMetadata.Column> getColumnsProvided() {
        return this.columnsProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            this.columnsProvided.clear();
            IndicatorTickerService.getInstance().unsubscribe(this.tickerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DLightTarget getTarget() {
        Object object = this.lock;
        synchronized (object) {
            return this.target;
        }
    }

    protected abstract void tick();

    @Override
    public void suggestRepaint() {
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    private void initMouseListener() {
        final JComponent jComponent = this.getComponent();
        if (jComponent == null) {
            return;
        }
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jComponent.requestFocus();
            }
        });
        final Color color = jComponent.getBackground();
        final Color color2 = color == null ? UIManager.getColor("Panel.background") : color.darker();
        jComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEtchedBorder());
                jComponent.setBackground(color2);
                JRootPane jRootPane = jComponent.getRootPane();
                if (jRootPane == null) {
                    return;
                }
                InputMap inputMap = jRootPane.getInputMap(1);
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
                ActionMap actionMap = jRootPane.getActionMap();
                if (jComponent.getActionMap().get("enter") != null) {
                    actionMap.put("enter", jComponent.getActionMap().get("enter"));
                } else {
                    actionMap.put("enter", new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Indicator.this.notifyListeners();
                        }
                    });
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                jComponent.setBackground(color);
            }
        });
    }

    void setToolID(String string) {
        this.toolID = string;
    }

    private final void setToolDescription(String string) {
        this.toolDecsription = string;
        if (string == null) {
            return;
        }
        JComponent jComponent = this.getComponent();
        if (jComponent == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.getDescription().replaceAll("\n", "<br>"));
        stringBuilder.append("</body></html><");
        jComponent.setToolTipText(stringBuilder.toString());
    }

    final List<VisualizerConfiguration> getVisualizerConfigurations() {
        return this.visualizerConfigurations;
    }

    void addIndicatorActionListener(IndicatorActionListener indicatorActionListener) {
        if (!this.listeners.contains(indicatorActionListener)) {
            this.listeners.add(indicatorActionListener);
        }
    }

    void removeIndicatorActionListener(IndicatorActionListener indicatorActionListener) {
        this.listeners.remove(indicatorActionListener);
    }

    public IndicatorMetadata getMetadata() {
        return this.metadata;
    }

    protected List<DataTableMetadata.Column> getMetadataColumns() {
        return this.metadata.getColumns();
    }

    final void columnProvided(DataTableMetadata.Column column) {
        this.columnsProvided.add(column);
    }

    protected String getMetadataColumnName(int n) {
        if (n < 0 || n >= this.metadata.getColumnsCount()) {
            return null;
        }
        DataTableMetadata.Column column = this.metadata.getColumns().get(n);
        return column.getColumnName();
    }

    public abstract JComponent getComponent();

    static {
        IndicatorAccessor.setDefault(new IndicatorAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndicatorAccessorImpl
    extends IndicatorAccessor {
        private IndicatorAccessorImpl() {
        }

        @Override
        public void setToolID(Indicator<?> indicator, String string) {
            indicator.setToolID(string);
        }

        @Override
        public List<DataTableMetadata.Column> getMetadataColumns(Indicator<?> indicator) {
            return indicator.getMetadataColumns();
        }

        @Override
        public String getMetadataColumnName(Indicator<?> indicator, int n) {
            return indicator.getMetadataColumnName(n);
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(Indicator<?> indicator) {
            return indicator.getVisualizerConfigurations();
        }

        @Override
        public void addIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener indicatorActionListener) {
            indicator.addIndicatorActionListener(indicatorActionListener);
        }

        @Override
        public void removeIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener indicatorActionListener) {
            indicator.removeIndicatorActionListener(indicatorActionListener);
        }

        @Override
        public String getToolID(Indicator<?> indicator) {
            return ((Indicator)indicator).toolID;
        }

        @Override
        public void initMouseListener(Indicator<?> indicator) {
            ((Indicator)indicator).initMouseListener();
        }

        @Override
        public void setRepairActionProviderFor(Indicator<?> indicator, IndicatorRepairActionProvider indicatorRepairActionProvider) {
            ((Indicator)indicator).setRepairActionProviderFor(indicatorRepairActionProvider);
        }

        @Override
        public void setToolDescription(Indicator<?> indicator, String string) {
            ((Indicator)indicator).setToolDescription(string);
        }
    }
}

