/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.List;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataRow {
    private List<String> colnames;
    private List<? extends Object> data;

    public DataRow(List<String> list, List<? extends Object> list2) {
        this.colnames = list;
        DLightLogger.assertTrue((list2 != null ? 1 : 0) != 0, (String)"data parameter should not be null");
        this.data = list2;
    }

    public Long getLongValue(String string) {
        Long l = null;
        int n = this.colnames.indexOf(string);
        if (n >= 0) {
            l = (Long)this.data.get(n);
        }
        return l;
    }

    public String getStringValue(String string) {
        return this.getStringValue(this.colnames.indexOf(string));
    }

    public String getStringValue(int n) {
        String string = null;
        if (n >= 0) {
            string = String.valueOf(this.data.get(n));
        }
        return string;
    }

    public Double getDoubleValue(String string) {
        return this.getDoubleValue(this.colnames.indexOf(string));
    }

    public Double getDoubleValue(int n) {
        Double d = null;
        if (n >= 0) {
            d = (Double)this.data.get(n);
        }
        return d;
    }

    public Float getFloatValue(String string) {
        return this.getFloatValue(this.colnames.indexOf(string));
    }

    public Float getFloatValue(int n) {
        Float f = null;
        if (n >= 0) {
            f = (Float)this.data.get(n);
        }
        return f;
    }

    public List<String> getColumnNames() {
        return this.colnames;
    }

    public List<? extends Object> getData() {
        return this.data;
    }

    public Object getData(String string) {
        int n = this.colnames.indexOf(string);
        if (n >= 0) {
            return this.data.get(n);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(" *");
        for (String object : this.colnames) {
            stringBuilder.append(object).append("* | *");
        }
        stringBuilder.append("\n");
        for (Object object : this.data) {
            stringBuilder.append(object.toString()).append(" | ");
        }
        return stringBuilder.toString();
    }
}

