/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakList<T>
implements Iterable<T> {
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    public synchronized void add(T t) {
        this.list.add(new WeakReference<T>(t));
    }

    public synchronized void addAll(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            this.list.add(new WeakReference<T>(iterator.next()));
        }
    }

    public synchronized void remove(T t) {
        Iterator<WeakReference<T>> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> weakReference = iterator.next();
            if (weakReference.get() != t) continue;
            iterator.remove();
        }
    }

    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        ArrayList arrayList = new ArrayList();
        this.addTo(arrayList);
        return arrayList.iterator();
    }

    public synchronized Collection<T> join(Collection<? extends T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size() + this.list.size());
        arrayList.addAll(collection);
        this.addTo(arrayList);
        return arrayList;
    }

    private void addTo(Collection<T> collection) {
        for (WeakReference<T> weakReference : this.list) {
            Object t = weakReference.get();
            if (t == null) continue;
            collection.add(t);
        }
    }
}

