/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseStatistics {
    private static final ParseStatistics instance = new ParseStatistics();
    private Map<CsmUID<CsmProject>, Map<CsmUID<CsmFile>, Entry>> projectMaps = null;
    private boolean enabled = false;

    public static final ParseStatistics getInstance() {
        return instance;
    }

    private ParseStatistics() {
        if (TraceFlags.PARSE_STATISTICS) {
            this.setEnabled(true);
        }
    }

    public synchronized void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.projectMaps = bl ? new HashMap<CsmUID<CsmProject>, Map<CsmUID<CsmFile>, Entry>>() : null;
        }
    }

    public synchronized void fileParsed(FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
        if (this.enabled) {
            ++this.getEntry((FileImpl)fileImpl).cnt;
        }
    }

    public synchronized int getParseCount(FileImpl fileImpl) {
        if (this.enabled) {
            return this.getEntry((FileImpl)fileImpl).cnt;
        }
        return 0;
    }

    private Entry getEntry(FileImpl fileImpl) {
        Map<CsmUID<CsmFile>, Entry> map = this.getProjectMap(fileImpl.getProjectUID());
        Entry entry = map.get(fileImpl.getUID());
        if (entry == null) {
            entry = new Entry();
            map.put(fileImpl.getUID(), entry);
        }
        return entry;
    }

    private Map<CsmUID<CsmFile>, Entry> getProjectMap(CsmUID<CsmProject> csmUID) {
        Map<CsmUID<CsmFile>, Entry> map = this.projectMaps.get(csmUID);
        if (map == null) {
            map = new HashMap<CsmUID<CsmFile>, Entry>();
            this.projectMaps.put(csmUID, map);
        }
        return map;
    }

    public synchronized void clear() {
        if (this.enabled) {
            this.projectMaps.clear();
        }
    }

    public synchronized void clear(CsmProject csmProject) {
        if (this.enabled) {
            this.projectMaps.remove(UIDs.get((Object)csmProject));
        }
    }

    public synchronized void printResults(CsmProject csmProject) {
        this.printResults(csmProject, new PrintWriter(System.out));
    }

    public synchronized void printResults(CsmProject csmProject, PrintWriter printWriter) {
        if (this.enabled) {
            this.printResults((CsmUID<CsmProject>)UIDs.get((Object)csmProject), printWriter);
        } else {
            printWriter.printf("Statistics is disabled", new Object[0]);
        }
        printWriter.flush();
    }

    public synchronized void printResults() {
        this.printResults(new PrintWriter(System.out));
    }

    public synchronized void printResults(PrintWriter printWriter) {
        printWriter.printf("\nPARSING STATISTICS\n", new Object[0]);
        if (this.enabled) {
            for (CsmUID<CsmProject> csmUID : this.projectMaps.keySet()) {
                this.printResults(csmUID, printWriter);
            }
        } else {
            printWriter.printf("Statistics is disabled", new Object[0]);
        }
        printWriter.flush();
    }

    private void printResults(CsmUID<CsmProject> csmUID, PrintWriter printWriter) {
        ArrayList<Map.Entry<CsmUID<CsmFile>, Entry>> arrayList = new ArrayList<Map.Entry<CsmUID<CsmFile>, Entry>>(this.getProjectMap(csmUID).entrySet());
        if (arrayList.isEmpty()) {
            return;
        }
        printWriter.printf("\nPARSING STATISTICS FOR %s\n", UIDUtilities.getProjectName(csmUID));
        Collections.sort(arrayList, new Comparator<Map.Entry<CsmUID<CsmFile>, Entry>>(){

            @Override
            public int compare(Map.Entry<CsmUID<CsmFile>, Entry> entry, Map.Entry<CsmUID<CsmFile>, Entry> entry2) {
                return entry.getValue().cnt - entry2.getValue().cnt;
            }
        });
        int n = 0;
        for (Map.Entry entry : arrayList) {
            int n2 = ((Entry)entry.getValue()).cnt;
            printWriter.printf("\t%6d %s\n", n2, UIDUtilities.getFileName((CsmUID<CsmFile>)((CsmUID)entry.getKey())));
            n += n2;
        }
        float f = arrayList.size() == 0 ? 0.0f : (float)n / (float)arrayList.size();
        printWriter.printf("\t%6.1f avg", Float.valueOf(f));
        printWriter.printf("\nEND OF PARSING STATISTICS FOR %s\n", UIDUtilities.getProjectName(csmUID));
    }

    private static class Entry {
        public int cnt = 0;

        private Entry() {
        }
    }
}

