/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnUtils {
    public static final String SVN_ADMIN_DIR;
    public static final String SVN_ENTRIES_DIR;
    private static final Pattern metadataPattern;
    public static final HashSet<Character> autoEscapedCharacters;
    private static final FileFilter svnFileFilter;
    private static Logger TY9_LOG;

    public static String createAnnotationFormat(String string) {
        String string2 = string;
        string2 = Utils.skipUnsupportedVariables((String)string2, (String[])new String[]{"{status}", "{folder}", "{revision}", "{mime_type}"});
        string2 = string2.replaceAll("\\{revision\\}", "\\{0\\}");
        string2 = string2.replaceAll("\\{status\\}", "\\{1\\}");
        string2 = string2.replaceAll("\\{folder\\}", "\\{2\\}");
        string2 = string2.replaceAll("\\{mime_type\\}", "\\{3\\}");
        return string2;
    }

    public static SVNUrl decodeAndEncodeUrl(SVNUrl sVNUrl) throws MalformedURLException {
        return SvnUtils.encodeUrl(SvnUtils.decode(sVNUrl));
    }

    public static SVNUrl encodeUrl(SVNUrl sVNUrl) throws MalformedURLException {
        String string = sVNUrl.toString();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            if (autoEscapedCharacters.contains(c)) {
                char[] cArray = Character.toChars(c.charValue());
                for (int j = 0; j < cArray.length; ++j) {
                    stringBuilder.append('%');
                    stringBuilder.append(Integer.toHexString(cArray[j]).toUpperCase());
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return new SVNUrl(stringBuilder.toString());
    }

    public static Context getCurrentContext(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = TopComponent.getRegistry().getActivatedNodes();
        }
        VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
        return new Context(new ArrayList<File>(vCSContext.computeFiles(svnFileFilter)), new ArrayList<File>(vCSContext.getRootFiles()), new ArrayList<File>(vCSContext.getExclusions()));
    }

    public static Context getCurrentContext(Node[] nodeArray, int n, int n2, boolean bl) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = bl ? fileStatusCache.getCachedStatus(file) : fileStatusCache.getStatus(file);
            int n3 = fileInformation != null ? fileInformation.getStatus() : 8;
            if (!(file.isDirectory() ? (n3 & n2) == 0 : (n3 & n) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static Context getCurrentContext(Node[] nodeArray, int n, int n2) {
        return SvnUtils.getCurrentContext(nodeArray, n, n2, false);
    }

    public static boolean isAnnotationFormatValid(String string) {
        boolean bl = true;
        if (string != null) {
            try {
                new MessageFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Subversion.LOG.log(Level.FINER, "Bad user input - annotation format", illegalArgumentException);
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                File file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (file == null || (fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Collection<File> collection3, Project project) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null || (fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            collection2.add(file);
            boolean bl = false;
            FileObject[] fileObjectArray = fileObject.getChildren();
            HashSet<File> hashSet = new HashSet<File>(fileObjectArray.length);
            for (int j = 0; j < fileObjectArray.length; ++j) {
                File file2;
                FileObject fileObject2 = fileObjectArray[j];
                if (SvnUtils.isAdministrative(fileObject2.getNameExt()) || (file2 = FileUtil.toFile((FileObject)fileObject2)) == null) continue;
                if (sourceGroup.contains(fileObject2)) {
                    hashSet.add(file2);
                    continue;
                }
                int n = fileStatusCache.getStatus(file2).getStatus();
                if (n == 2) continue;
                collection3.add(file2);
                bl = true;
            }
            if (bl) {
                collection.addAll(hashSet);
                continue;
            }
            collection.add(file);
        }
    }

    public static Context getProjectsContext(Project[] projectArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        for (int i = 0; i < projectArray.length; ++i) {
            SvnUtils.addProjectFiles(arrayList, arrayList2, arrayList3, projectArray[i]);
        }
        return new Context(arrayList, arrayList2, arrayList3);
    }

    public static File[] toFileArray(Collection<FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        Iterator<FileObject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = FileUtil.toFile((FileObject)iterator.next());
            if (file == null) continue;
            hashSet.add(file);
        }
        hashSet.remove(null);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static boolean isAdministrative(File file) {
        String string = file.getName();
        boolean bl = SvnUtils.isAdministrative(string);
        return bl && !file.exists() || bl && file.exists() && file.isDirectory();
    }

    public static boolean isAdministrative(String string) {
        return string.equals(SVN_ADMIN_DIR);
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public static String previousRevision(String string) {
        return string == null ? null : Long.toString(Long.parseLong(string) - 1L);
    }

    public static String getRelativePath(File object) throws SVNClientException {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (SvnUtils.isManaged((File)object)) {
            Object object2;
            ISVNInfo iSVNInfo;
            block11: {
                bl = true;
                iSVNInfo = null;
                try {
                    object2 = Subversion.getInstance().getClient(false);
                    iSVNInfo = object2.getInfoFromWorkingCopy((File)object);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block11;
                    if (SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                        WorkingCopyAttributesCache.getInstance().logUnsupportedWC(sVNClientException, (File)object);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNInfo != null && iSVNInfo.getUrl() != null) {
                object2 = SvnUtils.decode(iSVNInfo.getUrl());
                sVNUrl = iSVNInfo.getRepository();
                if (object2 != null && sVNUrl != null) {
                    String string2 = object2.toString();
                    String string3 = SvnUtils.decode(sVNUrl).toString();
                    try {
                        string = string2.substring(string3.length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        Subversion.LOG.log(Level.INFO, "repoUrl: " + sVNUrl.toString() + "\nfileURL: " + string2, stringIndexOutOfBoundsException);
                        throw stringIndexOutOfBoundsException;
                    }
                    Iterator iterator = arrayList.iterator();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        stringBuffer.append("/");
                        stringBuffer.append(string4);
                    }
                    string = string + stringBuffer.toString();
                    break;
                }
            }
            arrayList.add(0, ((File)object).getName());
            object2 = ((File)object).getParentFile();
            if (object2 == null) break;
            object = object2;
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{object});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{object});
        }
        return string;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        Object object;
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (SvnUtils.isManaged(file)) {
            File file2;
            block9: {
                bl = true;
                object = null;
                try {
                    object = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block9;
                    if (SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                        WorkingCopyAttributesCache.getInstance().logUnsupportedWC(sVNClientException, file);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (object != null && (sVNUrl = SvnUtils.decode(object.getRepository())) != null || (file2 = file.getParentFile()) == null) break;
            file = file2;
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
            object = Subversion.LOG.getLevel();
            Subversion.LOG.setLevel(Level.FINE);
            Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} {1}", new Object[]{file, VersioningSupport.getOwner((File)file)});
            Subversion.LOG.setLevel((Level)object);
            if (!file.exists()) {
                Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} does not exist", new Object[]{file});
            }
        }
        return sVNUrl;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuffer stringBuffer = new StringBuffer();
        SVNUrl sVNUrl = null;
        SvnClient svnClient = null;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        boolean bl = false;
        while (SvnUtils.isManaged(file)) {
            ISVNStatus iSVNStatus;
            block13: {
                block12: {
                    bl = true;
                    try {
                        iSVNStatus = SvnUtils.getSingleStatus(svnClient, file);
                        if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block12;
                        if (SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                            WorkingCopyAttributesCache.getInstance().logUnsupportedWC(sVNClientException, file);
                        }
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                    }
                }
                iSVNStatus = null;
                try {
                    iSVNStatus = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block13;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) break;
            stringBuffer.insert(0, file.getName()).insert(0, "/");
            File file2 = file.getParentFile();
            if (file2 == null) break;
            file = file2;
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        if (stringBuffer.length() > 0) {
            sVNUrl = sVNUrl.appendPath(stringBuffer.toString());
        }
        return sVNUrl;
    }

    public static Map<File, SVNUrl> getRepositoryUrls(File file) throws SVNClientException {
        HashMap<File, SVNUrl> hashMap;
        block6: {
            SVNUrl sVNUrl = null;
            SvnClient svnClient = null;
            try {
                svnClient = Subversion.getInstance().getClient(false);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                return null;
            }
            hashMap = new HashMap<File, SVNUrl>();
            try {
                ISVNStatus[] iSVNStatusArray;
                for (ISVNStatus iSVNStatus : iSVNStatusArray = svnClient.getStatus(file, true, true)) {
                    if (iSVNStatus == null || (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) == null) continue;
                    hashMap.put(iSVNStatus.getFile(), sVNUrl);
                }
            }
            catch (SVNClientException sVNClientException) {
                if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block6;
                if (SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                    WorkingCopyAttributesCache.getInstance().logUnsupportedWC(sVNClientException, file);
                }
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        return hashMap;
    }

    private static ISVNStatus getSingleStatus(SvnClient svnClient, File file) throws SVNClientException {
        return svnClient.getSingleStatus(file);
    }

    public static SVNUrl decode(SVNUrl sVNUrl) {
        if (sVNUrl == null) {
            return null;
        }
        String string = sVNUrl.toString();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                bl = true;
                continue;
            }
            if (c == '+' && bl) {
                stringBuffer.append(' ');
                continue;
            }
            if (SvnUtils.isEncodedByte(c, string, i)) {
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                do {
                    arrayList.add((byte)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                } while ((i += 3) < string.length() && SvnUtils.isEncodedByte(c = string.charAt(i), string, i));
                if (arrayList.size() <= 0) continue;
                byte[] byArray = new byte[arrayList.size()];
                for (int j = 0; j < arrayList.size(); ++j) {
                    byArray[j] = (Byte)arrayList.get(j);
                }
                try {
                    stringBuffer.append(new String(byArray, "UTF8"));
                }
                catch (Exception exception) {
                    Subversion.LOG.log(Level.INFO, null, exception);
                }
                --i;
                continue;
            }
            stringBuffer.append(c);
        }
        try {
            return new SVNUrl(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static boolean isEncodedByte(char c, String string, int n) {
        return c == '%' && n + 2 < string.length() && SvnUtils.isHexDigit(string.charAt(n + 1)) && SvnUtils.isHexDigit(string.charAt(n + 2));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryUrl(file);
        SVNUrl sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
        return SVNUrlUtils.getRelativePath((SVNUrl)sVNUrl2, (SVNUrl)sVNUrl, (boolean)true);
    }

    public static boolean isBinary(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 || by == 9 || by == 10 || by == 13) continue;
            return true;
        }
        return false;
    }

    public static String fixLineEndings(String string) {
        return string.replaceAll("\r\n", "\n").replace('\r', '\n');
    }

    public static File[] flatten(File[] fileArray, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((n & fileInformation.getStatus()) != 0) {
                linkedList.add(file);
            }
            File[] fileArray2 = fileStatusCache.listFiles(file);
            for (int j = 0; j < fileArray2.length; ++j) {
                File file2 = fileArray2[j];
                fileInformation = fileStatusCache.getStatus(file2);
                if ((n & fileInformation.getStatus()) == 0) continue;
                linkedList.add(file2);
            }
        }
        return linkedList.toArray(new File[linkedList.size()]);
    }

    public static File[] getModifiedFiles(Context context, int n) {
        File[] fileArray;
        File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray = fileArray2[i];
            String string = fileArray.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(string)) continue;
            arrayList.add(fileArray);
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile() || (fileStatusCache.getStatus(file).getStatus() & n) == 0 || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    public static String getCopy(File file) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            if (!SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
            return null;
        }
        return SvnUtils.getCopy(sVNUrl, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl sVNUrl) {
        return SvnUtils.getCopy(sVNUrl, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(SVNUrl sVNUrl, List<AnnotationExpression> list) {
        if (sVNUrl != null) {
            String string = sVNUrl.toString();
            Iterator<AnnotationExpression> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getCopyName(string);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    public static void refreshParents(File file) {
        if (file == null) {
            return;
        }
        SvnUtils.refreshParents(file.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static SVNRevision getSVNRevision(String string) {
        try {
            return SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            return new SVNRevision.Number(Long.parseLong(string));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> list, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null) {
            return arrayList;
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string2 = iterator.next();
                String string3 = SvnUtils.regExpToFilePatterns(string2);
                Pattern pattern = Pattern.compile(string3);
                if (!pattern.matcher(string).matches()) continue;
                arrayList.add(string2);
                if (!bl) continue;
                return arrayList;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Subversion.LOG.log(Level.INFO, null, patternSyntaxException);
            }
        }
        return arrayList;
    }

    private static String regExpToFilePatterns(String string) {
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*");
        string = string.replaceAll("\\?", ".");
        string = string.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\^", "\\\\^");
        string = string.replaceAll("\\<", "\\\\<");
        string = string.replaceAll("\\>", "\\\\>");
        string = SvnUtils.patchRegExpClassCharacters(string);
        string = string.replaceAll("\\{", "\\\\{");
        string = string.replaceAll("\\}", "\\\\}");
        string = string.replaceAll("\\(", "\\\\(");
        string = string.replaceAll("\\)", "\\\\)");
        string = string.replaceAll("\\+", "\\\\+");
        string = string.replaceAll("\\|", "\\\\|");
        return string;
    }

    private static String patchRegExpClassCharacters(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                stringBuilder.append(c);
                if (++n < string.length()) {
                    ++n2;
                    stringBuilder.append(string.charAt(n));
                }
            } else if (c == '[') {
                stringBuilder.append(c);
                linkedList.add(n2);
            } else {
                if (c == ']') {
                    if (linkedList.isEmpty()) {
                        stringBuilder.append("\\");
                        ++n2;
                    } else {
                        linkedList.removeLast();
                    }
                }
                stringBuilder.append(c);
            }
            ++n;
            ++n2;
        }
        for (Integer n3 : linkedList) {
            stringBuilder.insert((int)n3, "\\");
        }
        return stringBuilder.toString();
    }

    public static String getMimeType(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string = fileObject == null ? "content/unknown" : fileObject.getMIMEType();
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        if ((fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            if (string.startsWith("text")) {
                return string;
            }
            return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
        }
        PropertiesClient propertiesClient = new PropertiesClient(file);
        try {
            byte[] byArray = propertiesClient.getProperties().get("svn:mime-type");
            if (byArray == null) {
                return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static <T> boolean equals(List<T> list, List<T> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null && list2.size() > 0 || list2 == null && list != null && list.size() > 0) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (T t : list) {
            if (list2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static List<File> listRecursively(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file == null) {
            return arrayList;
        }
        arrayList.add(file);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (SvnUtils.isPartOfSubversionMetadata(file2) || SvnUtils.isAdministrative(file2)) continue;
                if (file2.isDirectory()) {
                    arrayList.addAll(SvnUtils.listRecursively(file2));
                    continue;
                }
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static SvnFileNode[] getNodes(Context context, int n) {
        File[] fileArray = Subversion.getInstance().getStatusCache().listFiles(context, n);
        SvnFileNode[] svnFileNodeArray = new SvnFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            svnFileNodeArray[i] = new SvnFileNode(fileArray[i]);
        }
        return svnFileNodeArray;
    }

    public static SVNRevision toSvnRevision(String string) {
        Object object = "HEAD".equals(string) ? SVNRevision.HEAD : new SVNRevision.Number(Long.parseLong(string));
        return object;
    }

    public static ISVNLogMessage[] getLogMessages(ISVNClientAdapter iSVNClientAdapter, SVNUrl sVNUrl, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        HashSet<Long> hashSet = new HashSet<Long>();
        ArrayList<ISVNLogMessage> arrayList = new ArrayList<ISVNLogMessage>();
        boolean bl3 = true;
        long l = -1L;
        for (String string : stringArray) {
            ISVNLogMessage[] iSVNLogMessageArray;
            for (ISVNLogMessage iSVNLogMessage : iSVNLogMessageArray = iSVNClientAdapter.getLogMessages(sVNUrl.appendPath(string), null, sVNRevision, sVNRevision2, bl, bl2, 0L)) {
                long l2 = iSVNLogMessage.getRevision().getNumber();
                if (hashSet.contains(l2)) continue;
                arrayList.add(iSVNLogMessage);
                hashSet.add(l2);
                bl3 &= l2 > l;
                l = l2;
            }
        }
        if (!bl3) {
            Collections.sort(arrayList, new Comparator<ISVNLogMessage>(){

                @Override
                public int compare(ISVNLogMessage iSVNLogMessage, ISVNLogMessage iSVNLogMessage2) {
                    long l;
                    long l2 = iSVNLogMessage.getRevision().getNumber();
                    return l2 == (l = iSVNLogMessage2.getRevision().getNumber()) ? 0 : (l2 > l ? 1 : -1);
                }
            });
        }
        return arrayList.toArray(new ISVNLogMessage[arrayList.size()]);
    }

    public static void logT9Y(String string) {
        if (TY9_LOG == null) {
            TY9_LOG = Logger.getLogger("org.netbeans.modules.subversion.t9y");
        }
        TY9_LOG.log(Level.FINEST, string);
    }

    public static File[] getActionRoots(Context context) {
        File[] fileArray = context.getRootFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (!SvnUtils.isManaged(file)) continue;
            arrayList.add(file);
        }
        fileArray = arrayList.toArray(new File[arrayList.size()]);
        if (Utils.shareCommonDataObject((File[])fileArray)) {
            return fileArray;
        }
        if (fileArray.length > 1) {
            File[] fileArray2 = new FileSelector(NbBundle.getMessage(SvnUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(SvnUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.subversion.FileSelector"), SvnModuleConfig.getDefault().getPreferences());
            if (fileArray2.show(fileArray)) {
                return new File[]{fileArray2.getSelectedFile()};
            }
            return null;
        }
        return new File[]{fileArray[0]};
    }

    public static File getPrimaryFile(File file) {
        File file2 = null;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Subversion.LOG.log(Level.INFO, "No DataObject found for " + file, dataObjectNotFoundException);
            }
            if (dataObject != null) {
                file2 = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            }
        }
        if (file2 == null) {
            file2 = file;
        }
        return file2;
    }

    public static boolean isJava64() {
        String string = System.getProperty("java.vm.name");
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains("64-bit");
    }

    public static CommitOptions[] createDefaultCommitOptions(SvnFileNode[] svnFileNodeArray, boolean bl) {
        CommitOptions[] commitOptionsArray = new CommitOptions[svnFileNodeArray.length];
        block4: for (int i = 0; i < svnFileNodeArray.length; ++i) {
            SvnFileNode svnFileNode = svnFileNodeArray[i];
            File file = svnFileNode.getFile();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) {
                commitOptionsArray[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (svnFileNode.getInformation().getStatus()) {
                case 4: {
                    commitOptionsArray[i] = bl ? CommitOptions.EXCLUDE : SvnUtils.getDefaultCommitOptions(svnFileNode.getFile());
                    continue block4;
                }
                case 256: 
                case 2048: {
                    commitOptionsArray[i] = CommitOptions.COMMIT_REMOVE;
                    continue block4;
                }
                default: {
                    commitOptionsArray[i] = CommitOptions.COMMIT;
                }
            }
        }
        return commitOptionsArray;
    }

    public static String getTunnelName(String string) {
        assert (string.startsWith("svn+"));
        int n = string.indexOf(":", 4);
        if (n < 0) {
            n = string.length();
        }
        return string.substring(4, n);
    }

    private static CommitOptions getDefaultCommitOptions(File file) {
        if (file.isFile()) {
            if (SvnUtils.getMimeType(file).startsWith("text")) {
                return CommitOptions.ADD_TEXT;
            }
            return CommitOptions.ADD_BINARY;
        }
        return CommitOptions.ADD_DIRECTORY;
    }

    static {
        String string;
        autoEscapedCharacters = new HashSet(6);
        autoEscapedCharacters.add(Character.valueOf(';'));
        autoEscapedCharacters.add(Character.valueOf('?'));
        autoEscapedCharacters.add(Character.valueOf('#'));
        autoEscapedCharacters.add(Character.valueOf('%'));
        autoEscapedCharacters.add(Character.valueOf('['));
        autoEscapedCharacters.add(Character.valueOf(']'));
        SVN_ADMIN_DIR = Utilities.isWindows() ? ((string = System.getenv("SVN_ASP_DOT_NET_HACK")) != null ? "_svn" : ".svn") : ".svn";
        SVN_ENTRIES_DIR = SVN_ADMIN_DIR + "/entries";
        metadataPattern = Pattern.compile(".*\\" + File.separatorChar + SVN_ADMIN_DIR + "(\\" + File.separatorChar + ".*|$)");
        svnFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (SvnUtils.isAdministrative(file)) {
                    return false;
                }
                return SharabilityQuery.getSharability((File)file) != 2;
            }
        };
        TY9_LOG = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation fileInformation, FileInformation fileInformation2) {
            return SvnUtils.getComparableStatus(fileInformation.getStatus()) - SvnUtils.getComparableStatus(fileInformation2.getStatus());
        }
    }
}

