/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class StatusAction
extends ContextAction {
    private static final int enabledForStatus = -2;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_ShowChanges";
    }

    protected int getFileEnabledStatus() {
        return -2;
    }

    public void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = SvnUtils.getCurrentContext(nodeArray);
        SvnVersioningTopComponent svnVersioningTopComponent = SvnVersioningTopComponent.getInstance();
        svnVersioningTopComponent.setContentTitle(this.getContextDisplayName(nodeArray));
        svnVersioningTopComponent.setContext(context);
        svnVersioningTopComponent.open();
        svnVersioningTopComponent.requestActive();
        svnVersioningTopComponent.performRefreshAction();
    }

    public static void executeStatus(Context context, SvnProgressSupport svnProgressSupport) {
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            Subversion.getInstance().getStatusCache().refreshCached(context);
            File[] fileArray = context.getRootFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                StatusAction.executeStatus(fileArray[i], svnClient, svnProgressSupport);
                if (!svnProgressSupport.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException sVNClientException) {
            if (!svnProgressSupport.isCanceled()) {
                svnProgressSupport.annotate(sVNClientException);
            }
            Subversion.LOG.log(Level.INFO, "Action canceled", sVNClientException);
        }
    }

    public static void executeStatus(File file, SvnClient svnClient, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
            return;
        }
        ISVNStatus[] iSVNStatusArray = svnClient.getStatus(file, true, false, true);
        if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
            return;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < iSVNStatusArray.length; ++i) {
            if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
                return;
            }
            ISVNStatus iSVNStatus = iSVNStatusArray[i];
            File file2 = iSVNStatus.getFile();
            if (file2.isDirectory() && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                fileStatusCache.refreshRecursively(file2);
                continue;
            }
            fileStatusCache.refresh(file2, iSVNStatus);
        }
    }
}

