/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BlameCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final BlameType type;
    private SVNUrl url;
    private File file;
    private SVNRevision revStart;
    private SVNRevision revEnd;
    private byte[] output;

    public BlameCommand(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        this.url = sVNUrl;
        this.revStart = sVNRevision;
        this.revEnd = sVNRevision2;
        this.file = null;
        this.type = BlameType.url;
    }

    public BlameCommand(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        this.file = file;
        this.revStart = sVNRevision;
        this.revEnd = sVNRevision2;
        this.url = null;
        this.type = BlameType.file;
    }

    protected boolean hasBinaryOutput() {
        return true;
    }

    protected boolean notifyOutput() {
        return false;
    }

    protected int getCommand() {
        return 25;
    }

    public void output(byte[] byArray) {
        this.output = byArray;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("blame");
        arguments.add("--xml");
        if (this.revStart != null) {
            arguments.add(this.revStart, this.revEnd);
        } else {
            arguments.add(this.revEnd);
        }
        switch (this.type) {
            case url: {
                arguments.add(this.url);
                break;
            }
            case file: {
                arguments.add(this.file);
                this.setCommandWorkingDirectory(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal blametype: " + (Object)((Object)this.type));
            }
        }
    }

    public Annotations.Annotation[] getAnnotation() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new Annotations.Annotation[0];
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            xMLReader.setContentHandler(xmlEntriesHandler);
            xMLReader.setErrorHandler(xmlEntriesHandler);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(this.output));
            xMLReader.parse(inputSource);
            return xmlEntriesHandler.getAnnotations();
        }
        catch (SAXException sAXException) {
            throw new SVNClientException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new SVNClientException((Throwable)iOException);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String BLAME_ELEMENT_NAME = "blame";
        private static final String TARGET_ELEMENT_NAME = "target";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String LINE_NUMBER_ATTRIBUTE = "line-number";
        private static final String REVISION_ATTRIBUTE = "revision";
        private String REVISION_ATTR = "revision_attr";
        private List<Annotations.Annotation> annotations = new ArrayList<Annotations.Annotation>();
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.tag = string3.trim();
            if (TARGET_ELEMENT_NAME.equals(string3)) {
                this.values = new HashMap<String, String>();
            } else if (COMMIT_ELEMENT_NAME.equals(string3)) {
                this.values.put(this.REVISION_ATTR, attributes.getValue(REVISION_ATTRIBUTE));
            } else if (ENTRY_ELEMENT_NAME.equals(string3)) {
                this.values.put(LINE_NUMBER_ATTRIBUTE, attributes.getValue(LINE_NUMBER_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String string = this.toString(n2, cArray, n);
            String string2 = this.values.get(this.tag);
            if (string2 == null) {
                this.values.put(this.tag, string);
            } else {
                this.values.put(this.tag, string2 + string);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                if (this.values != null) {
                    String string4 = this.values.get(COMMIT_ELEMENT_NAME);
                    if (string4 != null) {
                        String string5 = this.values.get(AUTHOR_ELEMENT_NAME);
                        Date date = null;
                        String string6 = this.values.get(DATE_ELEMENT_NAME);
                        if (string6 != null) {
                            try {
                                date = dateFormat.parse(string6);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        SVNRevision.Number number = null;
                        String string7 = this.values.get(this.REVISION_ATTR);
                        if (string7 != null && !string7.trim().equals("")) {
                            try {
                                number = new SVNRevision.Number(Long.parseLong(string7));
                            }
                            catch (NumberFormatException numberFormatException) {
                                number = new SVNRevision.Number(-1L);
                            }
                        }
                        this.annotations.add(new Annotations.Annotation(number.getNumber(), string5, date, null));
                    } else {
                        this.annotations.add(null);
                    }
                }
            } else if (TARGET_ELEMENT_NAME.equals(string3)) {
                this.values = null;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public Annotations.Annotation[] getAnnotations() {
            return this.annotations.toArray(new Annotations.Annotation[this.annotations.size()]);
        }

        private String toString(int n, char[] cArray, int n2) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, n2, cArray2, 0, n);
            return new String(cArray2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BlameType {
        url,
        file;

    }
}

