/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import javax.swing.JFormattedTextField;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class TimeFormatter
extends JFormattedTextField.AbstractFormatter
implements ValueFormatter {
    private static final String MAX = "max";

    public Object stringToValue(String string) throws ParseException {
        if (MAX.equalsIgnoreCase(string)) {
            return Long.MAX_VALUE;
        }
        long l = 0L;
        int n = string.indexOf(58);
        if (0 <= n) {
            try {
                l = Long.parseLong(string.substring(0, n));
                string = string.substring(n + 1);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(string, 0);
            }
        }
        long l2 = 0L;
        int n2 = string.indexOf(46);
        if (0 <= n2) {
            l2 = TimeFormatter.parseNanos(string.substring(n2 + 1));
            string = string.substring(0, n2);
        }
        long l3 = 0L;
        try {
            l3 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(string, 0);
        }
        return TimeFormatter.minutesToNanos(l) + TimeUnit.SECONDS.toNanos(l3) + l2;
    }

    public String valueToString(Object object) {
        return this.format((Long)object);
    }

    public String format(long l) {
        if (l == Long.MAX_VALUE) {
            return MAX;
        }
        long l2 = TimeFormatter.nanosToMinutes(l);
        long l3 = TimeUnit.NANOSECONDS.toSeconds(l - TimeFormatter.minutesToNanos(l2));
        long l4 = l - TimeFormatter.minutesToNanos(l2) - TimeUnit.SECONDS.toNanos(l3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%d:%02d", l2, l3));
        if (1000000L <= l4) {
            stringBuilder.append('.');
            stringBuilder.append(l4 / 100000000L);
            if (0L < (l4 %= 100000000L)) {
                stringBuilder.append(l4 / 10000000L);
                if (0L < (l4 %= 10000000L)) {
                    stringBuilder.append(l4 / 1000000L);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static long parseNanos(String string) throws ParseException {
        long l = 0L;
        for (int i = 0; i < 9; ++i) {
            int n;
            int n2 = n = i < string.length() ? (int)string.charAt(i) : 48;
            if (n < 48 || 57 < n) {
                throw new ParseException(string, i);
            }
            l = 10L * l + (long)(n - 48);
        }
        return l;
    }

    private static long minutesToNanos(long l) {
        return TimeUnit.SECONDS.toNanos(60L * l);
    }

    private static long nanosToMinutes(long l) {
        return TimeUnit.NANOSECONDS.toSeconds(l) / 60L;
    }
}

