/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.persistence.mapping.ejb.util;

import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.mapping.ejb.SunCmpMappingsUtils;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.ColumnPair;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.sun.persistence.mapping.ejb.util.SunOneUtilsCMP;

public class MappingConverter {
    private EJBInfoHelper ejbInfoHelper;
    private SourceFileMap sourceFileMap;

    public MappingConverter(EJBInfoHelper ejbInfoHelper, SourceFileMap sourceFileMap) {
        this.ejbInfoHelper = ejbInfoHelper;
        this.sourceFileMap = sourceFileMap;
    }

    public MappingClassElement toMappingClass(String ejbName) throws ModelException, DBException, ConversionException {
        SunCmpMappings mappings = SunOneUtilsCMP.prepare(null);
        SunCmpMapping mapping = SunCmpMappingsUtils.getFirstSunCmpMapping((SunCmpMappings)mappings, (boolean)false);
        EntityMapping em = SunCmpMappingsUtils.findEntityMapping((SunCmpMappings)mappings, (String)ejbName, (boolean)true);
        Collection fields = this.ejbInfoHelper.getFieldsForEjb(ejbName);
        Collection rels = this.ejbInfoHelper.getRelationshipsForEjb(ejbName);
        Iterator<Object> iterator = null;
        fields.removeAll(rels);
        for (String fieldName : fields) {
            SunCmpMappingsUtils.findCmpFieldMapping((EntityMapping)em, (String)fieldName, (boolean)true);
        }
        for (String fieldName : rels) {
            SunCmpMappingsUtils.findCmrFieldMapping((EntityMapping)em, (String)fieldName, (boolean)true);
        }
        iterator = SunOneUtilsCMP.getMappingClasses(mappings, this.ejbInfoHelper).values().iterator();
        return (MappingClassElement)iterator.next();
    }

    public Collection toMappingClasses(OriginalCMPMapping[] cmpMappings) throws ModelException, DBException, ConversionException {
        SunCmpMappings mappings = SunOneUtilsCMP.prepare(null);
        SunCmpMapping mapping = SunCmpMappingsUtils.getFirstSunCmpMapping((SunCmpMappings)mappings, (boolean)false);
        SchemaElement schemaObject = null;
        String schemaName = null;
        for (int i = 0; i < cmpMappings.length; ++i) {
            OriginalCMPMapping nextMapping = cmpMappings[i];
            String ejbName = nextMapping.getEjbName();
            EntityMapping em = SunCmpMappingsUtils.findEntityMapping((SunCmpMappings)mappings, (String)ejbName, (boolean)true);
            String tableName = nextMapping.getTableName();
            Collection fields = this.ejbInfoHelper.getFieldsForEjb(ejbName);
            Collection rels = this.ejbInfoHelper.getRelationshipsForEjb(ejbName);
            Iterator iterator = null;
            if (schemaName == null) {
                schemaName = this.getSchema(nextMapping);
                schemaObject = this.ejbInfoHelper.getSchema(schemaName);
                mapping.setSchema(schemaName);
            }
            em.setTableName(tableName);
            fields.removeAll(rels);
            for (String fieldName : fields) {
                CmpFieldMapping field = SunCmpMappingsUtils.findCmpFieldMapping((EntityMapping)em, (String)fieldName, (boolean)true);
                String columnName = nextMapping.getFieldColumn(fieldName);
                if (columnName == null) continue;
                field.addColumnName(tableName + '.' + columnName);
            }
            this.mapRelationships(nextMapping, mappings, em, schemaName, tableName, rels);
        }
        return SunOneUtilsCMP.getMappingClasses(mappings, this.ejbInfoHelper).values();
    }

    private String getSchema(OriginalCMPMapping cmpMapping) {
        String schemaName = this.sourceFileMap.getDistributionPath(cmpMapping.getSchema()).getPath();
        return SunOneUtilsCMP.removeSchemaFileNameExtension(schemaName);
    }

    private void mapRelationships(OriginalCMPMapping cmpMapping, SunCmpMappings mappings, EntityMapping em, String schema, String tableName, Collection rels) {
        ConversionHelper conversionHelper = this.ejbInfoHelper.createConversionHelper();
        TableElement thisTable = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)schema, (String)tableName));
        Iterator iterator = rels.iterator();
        conversionHelper.setEnsureValidation(false);
        conversionHelper.setGenerateFields(false);
        while (iterator.hasNext()) {
            ForeignKeyElement fk;
            String fieldName = (String)iterator.next();
            CmrFieldMapping field = SunCmpMappingsUtils.findCmrFieldMapping((EntityMapping)em, (String)fieldName, (boolean)true);
            String joinTableName = cmpMapping.getRelationshipJoinTable(fieldName);
            if (joinTableName != null) {
                int p;
                TableElement joinTable = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)schema, (String)joinTableName));
                ForeignKeyElement[] fks = joinTable.getForeignKeys();
                if (fks == null || fks.length != 2) continue;
                ForeignKeyElement testKey = fks[0];
                TableElement testTable = testKey.getReferencedTable();
                ColumnPair[] pairset1 = null;
                ColumnPair[] pairset2 = null;
                if (testTable.equals((Object)thisTable)) {
                    pairset1 = this.getColumnPairs(testKey);
                } else {
                    pairset2 = this.getColumnPairs(testKey);
                }
                testKey = fks[1];
                testTable = testKey.getReferencedTable();
                if (testTable.equals((Object)thisTable)) {
                    pairset1 = this.getColumnPairs(testKey);
                } else {
                    pairset2 = this.getColumnPairs(testKey);
                }
                pairset1 = this.swapPairs(pairset1);
                for (p = 0; p < pairset1.length; ++p) {
                    field.addColumnPair(pairset1[p]);
                }
                for (p = 0; p < pairset2.length; ++p) {
                    field.addColumnPair(pairset2[p]);
                }
                continue;
            }
            String[] columnNames = cmpMapping.getRelationshipColumn(fieldName);
            if (columnNames == null || (fk = this.getMatchingFK(columnNames, thisTable)) == null) continue;
            ColumnPair[] pairs = this.getColumnPairs(fk);
            field.setColumnPair(pairs);
            this.mapInverse(conversionHelper, mappings, cmpMapping.getEjbName(), fieldName, pairs);
        }
    }

    private ColumnPair[] getColumnPairs(ForeignKeyElement foreignKey) {
        ColumnPairElement[] cpes = foreignKey.getColumnPairs();
        int count = cpes.length;
        ColumnPair[] pairs = new ColumnPair[count];
        for (int i = 0; i < count; ++i) {
            ColumnPairElement cpe = cpes[i];
            ColumnPair pair = new ColumnPair();
            pair.addColumnName(NameUtil.getRelativeMemberName((String)cpe.getLocalColumn().getName().getFullName()));
            pair.addColumnName(NameUtil.getRelativeMemberName((String)cpe.getReferencedColumn().getName().getFullName()));
            pairs[i] = pair;
        }
        return pairs;
    }

    private ColumnPair[] swapPairs(ColumnPair[] pairs) {
        int count = pairs.length;
        ColumnPair[] swappedPairs = new ColumnPair[count];
        for (int i = 0; i < count; ++i) {
            ColumnPair pair = pairs[i];
            String[] columns = pair.getColumnName();
            ColumnPair swappedPair = new ColumnPair();
            swappedPair.setColumnName(new String[]{columns[1], columns[0]});
            swappedPairs[i] = swappedPair;
        }
        return swappedPairs;
    }

    private ForeignKeyElement getMatchingFK(String[] columnNames, TableElement table) {
        ForeignKeyElement[] foreignKeys = table != null ? table.getForeignKeys() : null;
        int count = foreignKeys != null ? foreignKeys.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.matchesFK(columnNames, foreignKeys[i])) continue;
            return foreignKeys[i];
        }
        return null;
    }

    private boolean matchesFK(String[] columnNames, ForeignKeyElement foreignKey) {
        int count;
        ColumnElement[] localColumns = foreignKey.getLocalColumns();
        int fkCount = localColumns != null ? localColumns.length : 0;
        int n = count = columnNames != null ? columnNames.length : 0;
        if (fkCount == count) {
            List<String> columnList = Arrays.asList(columnNames);
            for (int i = 0; i < fkCount; ++i) {
                if (columnList.contains(localColumns[i].getName().getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void mapInverse(ConversionHelper conversionHelper, SunCmpMappings mappings, String ejbName, String fieldName, ColumnPair[] pairs) {
        EntityMapping relatedEm;
        String relatedEjb = conversionHelper.getRelationshipFieldContent(ejbName, fieldName);
        String relatedField = conversionHelper.getInverseFieldName(ejbName, fieldName);
        if (relatedField != null && (relatedEm = SunCmpMappingsUtils.findEntityMapping((SunCmpMappings)mappings, (String)relatedEjb, (boolean)true)) != null) {
            CmrFieldMapping inverseField = SunCmpMappingsUtils.findCmrFieldMapping((EntityMapping)relatedEm, (String)relatedField, (boolean)true);
            inverseField.setColumnPair(this.swapPairs(pairs));
        }
    }
}

