/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.editor.BaseAction;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreprocessorEditorContextAction
extends BaseAction {
    public PreprocessorEditorContextAction(String string) {
        super(string);
    }

    public abstract String getPopupMenuText(ProjectConfigurationsHelper var1, ArrayList<PPLine> var2, JTextComponent var3);

    public abstract boolean isEnabled(ProjectConfigurationsHelper var1, ArrayList<PPLine> var2, JTextComponent var3);

    protected int getSelectionStartLine(JTextComponent jTextComponent) {
        if (jTextComponent == null || !(jTextComponent.getDocument() instanceof StyledDocument)) {
            return 0;
        }
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (int)jTextComponent.getSelectionStart()) + 1;
    }

    protected int getSelectionEndLine(JTextComponent jTextComponent) {
        if (jTextComponent == null || !(jTextComponent.getDocument() instanceof StyledDocument)) {
            return 0;
        }
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (int)jTextComponent.getSelectionEnd());
        return jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd() || NbDocument.findLineColumn((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (int)jTextComponent.getSelectionEnd()) > 0 ? n + 1 : n;
    }

    protected PPBlockInfo getBlock(JTextComponent jTextComponent, ArrayList<PPLine> arrayList) {
        int n = this.getSelectionStartLine(jTextComponent);
        if (n >= arrayList.size()) {
            return null;
        }
        return arrayList.get(n - 1).getBlock();
    }

    protected boolean overlapsBlockBorders(JTextComponent jTextComponent, ArrayList<PPLine> arrayList) {
        int n = this.getSelectionStartLine(jTextComponent);
        int n2 = this.getSelectionEndLine(jTextComponent);
        if (n >= arrayList.size() || n2 >= arrayList.size()) {
            return false;
        }
        PPBlockInfo pPBlockInfo = arrayList.get(n - 1).getBlock();
        return pPBlockInfo != null && (pPBlockInfo.getStartLine() == n || pPBlockInfo.hasFooter() && pPBlockInfo.getEndLine() == n2 || pPBlockInfo != arrayList.get(n2 - 1).getBlock());
    }

    protected boolean overlapsGuardedBlocks(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        if (!(document instanceof StyledDocument)) {
            return false;
        }
        GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)document));
        if (guardedSectionManager == null) {
            return false;
        }
        for (GuardedSection guardedSection : guardedSectionManager.getGuardedSections()) {
            try {
                if (!guardedSection.contains(NbDocument.createPosition((Document)document, (int)jTextComponent.getSelectionStart(), (Position.Bias)Position.Bias.Backward), false) && !guardedSection.contains(NbDocument.createPosition((Document)document, (int)jTextComponent.getSelectionEnd(), (Position.Bias)Position.Bias.Forward), false) && (guardedSection.getStartPosition().getOffset() < jTextComponent.getSelectionStart() || guardedSection.getEndPosition().getOffset() > jTextComponent.getSelectionEnd())) continue;
                return true;
            }
            catch (BadLocationException badLocationException) {
            }
        }
        return false;
    }
}

