/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHighlightsLayerFactory
implements HighlightsLayerFactory {
    static String PROP_HIGLIGHT_HEADER_LAYER = "mobility-embedded-headers-highlighting-layer";
    static String PROP_HIGLIGHT_BLOCKS_LAYER = "mobility-embedded-blocks-highlighting-layer";

    public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
        return new HighlightsLayer[]{HighlightsLayer.create((String)PROP_HIGLIGHT_HEADER_LAYER, (ZOrder)ZOrder.SYNTAX_RACK.forPosition(120), (boolean)true, (HighlightsContainer)new HeadersHighlighting(context.getDocument())), HighlightsLayer.create((String)PROP_HIGLIGHT_BLOCKS_LAYER, (ZOrder)ZOrder.BOTTOM_RACK.forPosition(110), (boolean)true, (HighlightsContainer)new BlocksHighlighting(context.getDocument()))};
    }

    private static AttributeSet getAttributes(HashMap<String, AttributeSet> hashMap, String string, boolean bl, boolean bl2) {
        AttributeSet attributeSet = hashMap.get(string + String.valueOf(bl) + String.valueOf(bl2));
        if (attributeSet != null) {
            return attributeSet;
        }
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)"text/x-java-preprocessor").lookup(FontColorSettings.class);
        attributeSet = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{fontColorSettings.getTokenFontColors(string), AttributesUtilities.createImmutable((Object[])new Object[]{HighlightsContainer.ATTR_EXTENDS_EOL, bl, HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE, bl2})});
        hashMap.put(string + String.valueOf(bl) + String.valueOf(bl2), attributeSet);
        return attributeSet;
    }

    static class BlocksHighlighting
    extends AbstractHighlightsContainer
    implements Highlighting,
    DocumentListener {
        private Document document;
        private OffsetsBag blocksBag;
        private HashMap<String, AttributeSet> attributeCache;

        public BlocksHighlighting(Document document) {
            this.document = document;
            this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
            this.document.putProperty(PROP_HIGLIGHT_BLOCKS_LAYER, this);
            this.attributeCache = new HashMap();
            this.blocksBag = new OffsetsBag(document, true);
            this.blocksBag.addHighlightsChangeListener(new HighlightsChangeListener(){

                public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
                    BlocksHighlighting.this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
                }
            });
            this.updateBags();
        }

        public HighlightsSequence getHighlights(int n, int n2) {
            return this.blocksBag.getHighlights(n, n2);
        }

        public void updateBags() {
            Project project = J2MEProjectUtils.getProjectForDocument((Document)this.document);
            if (project == null || !(project instanceof J2MEProject)) {
                return;
            }
            this.document.render(new Runnable(){

                public void run() {
                    OffsetsBag offsetsBag = new OffsetsBag(BlocksHighlighting.this.document, true);
                    ArrayList arrayList = (ArrayList)BlocksHighlighting.this.document.getProperty("preprocessor.line.list");
                    if (arrayList == null) {
                        return;
                    }
                    for (PPLine pPLine : arrayList) {
                        PPBlockInfo pPBlockInfo = pPLine.getBlock();
                        if (pPBlockInfo == null) continue;
                        StyledDocument styledDocument = (StyledDocument)BlocksHighlighting.this.document;
                        offsetsBag.addHighlight(NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(pPBlockInfo.getStartLine() - 1).getStartOffset(), NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(pPBlockInfo.getEndLine() - 1).getEndOffset(), pPBlockInfo.isActive() ? ConfigurationHighlightsLayerFactory.getAttributes(BlocksHighlighting.this.attributeCache, "pp-active-block", true, true) : ConfigurationHighlightsLayerFactory.getAttributes(BlocksHighlighting.this.attributeCache, "pp-inactive-block", true, true));
                    }
                    BlocksHighlighting.this.blocksBag.setHighlights(offsetsBag);
                }
            });
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.blocksBag.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength(), true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.blocksBag.removeHighlights(documentEvent.getOffset() - 1, documentEvent.getOffset() + documentEvent.getLength() - 1, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    static class HeadersHighlighting
    extends AbstractHighlightsContainer
    implements Highlighting,
    DocumentListener {
        private static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
        private Document document;
        private OffsetsBag headersBag;
        private HashMap<String, AttributeSet> attributeCache;

        public HeadersHighlighting(Document document) {
            this.document = document;
            this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
            this.document.putProperty(PROP_HIGLIGHT_HEADER_LAYER, this);
            this.attributeCache = new HashMap();
            this.headersBag = new OffsetsBag(document);
            this.headersBag.addHighlightsChangeListener(new HighlightsChangeListener(){

                public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
                    HeadersHighlighting.this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
                }
            });
            this.updateBags();
        }

        public HighlightsSequence getHighlights(int n, int n2) {
            return this.headersBag.getHighlights(n, n2);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.headersBag.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength(), true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.headersBag.removeHighlights(documentEvent.getOffset() - 1, documentEvent.getOffset() + documentEvent.getLength() - 1, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void updateBags() {
            Project project = J2MEProjectUtils.getProjectForDocument((Document)this.document);
            if (project == null || !(project instanceof J2MEProject)) {
                return;
            }
            this.document.render(new Runnable(){

                public void run() {
                    StyledDocument styledDocument = (StyledDocument)HeadersHighlighting.this.document;
                    OffsetsBag offsetsBag = new OffsetsBag(HeadersHighlighting.this.document, true);
                    Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
                    int n = element.getElementCount();
                    for (int i = 0; i < n; ++i) {
                        try {
                            Element element2 = element.getElement(i);
                            if (!BLOCK_HEADER_PATTERN.matcher(styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset()).trim()).find()) continue;
                            offsetsBag.addHighlight(element2.getStartOffset(), element2.getEndOffset(), ConfigurationHighlightsLayerFactory.getAttributes(HeadersHighlighting.this.attributeCache, "pp-command", false, false));
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    HeadersHighlighting.this.headersBag.setHighlights(offsetsBag);
                }
            });
        }
    }

    static interface Highlighting {
        public void updateBags();
    }
}

