/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableFilesIndex {
    public static final ExecutableFilesIndex DEFAULT = new ExecutableFilesIndex();
    private URL lastLoadURL;
    private Set<String> mainSources;
    private Map<ChangeListener, String> listener2File = new WeakHashMap<ChangeListener, String>();
    private Map<String, Set<ChangeListener>> file2Listener = new WeakHashMap<String, Set<ChangeListener>>();

    public synchronized boolean isMainClass(URL uRL, URL uRL2) {
        this.ensureLoad(uRL);
        return this.mainSources.contains(uRL2.toExternalForm());
    }

    public synchronized Iterable<? extends URL> getMainClasses(URL uRL) {
        this.ensureLoad(uRL);
        ArrayList<URL> arrayList = new ArrayList<URL>(this.mainSources.size());
        for (String string : this.mainSources) {
            try {
                arrayList.add(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList;
    }

    public synchronized void setMainClass(URL uRL, URL uRL2, boolean bl) {
        this.ensureLoad(uRL);
        String string = uRL2.toExternalForm();
        boolean bl2 = bl ? this.mainSources.add(string) : this.mainSources.remove(string);
        if (bl2) {
            this.save(uRL);
            Set<ChangeListener> set = this.file2Listener.get(string);
            if (set != null) {
                ChangeEvent changeEvent = null;
                for (ChangeListener changeListener : set) {
                    if (changeEvent == null) {
                        changeEvent = new ChangeEvent(uRL2);
                    }
                    changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    public synchronized void addChangeListener(URL uRL, ChangeListener changeListener) {
        String string = uRL.toExternalForm();
        this.listener2File.put(changeListener, string);
        WeakSet weakSet = this.file2Listener.get(string);
        if (weakSet == null) {
            weakSet = new WeakSet();
            this.file2Listener.put(string, (Set<ChangeListener>)weakSet);
        }
        weakSet.add((ChangeListener)changeListener);
        this.file2Listener.put(string, (Set<ChangeListener>)weakSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoad(URL uRL) {
        if (this.lastLoadURL != null && this.lastLoadURL.equals(uRL)) {
            return;
        }
        try {
            try {
                this.mainSources = ExecutableFilesIndex.unwrap(JavaIndex.getAttribute(uRL, "executable-files", ""));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                this.mainSources = new HashSet<String>();
                Object var4_3 = null;
                this.lastLoadURL = uRL;
            }
            Object var4_2 = null;
            this.lastLoadURL = uRL;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lastLoadURL = uRL;
            throw throwable;
        }
    }

    private void save(URL uRL) {
        try {
            JavaIndex.setAttribute(uRL, "executable-files", ExecutableFilesIndex.wrap(this.mainSources));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    static Set<String> unwrap(String string) {
        if (string.length() == 0) {
            return new HashSet<String>();
        }
        String[] stringArray = string.split("::");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            string2 = string2.replaceAll("\\\\d", ":");
            string2 = string2.replaceAll("\\\\\\\\", "\\\\");
            hashSet.add(string2);
        }
        return hashSet;
    }

    static String wrap(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : set) {
            if (!bl) {
                stringBuilder.append("::");
            }
            string = string.replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll(":", "\\\\d");
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }
}

