/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexFactory;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassIndexImpl {
    public final List<WeakReference<ClassIndexImplListener>> listeners = Collections.synchronizedList(new ArrayList());
    private State state = State.NEW;
    public static ClassIndexFactory FACTORY;

    public abstract <T> void search(String var1, Set<UsageType> var2, ResultConvertor<T> var3, Set<? super T> var4) throws IOException, InterruptedException;

    public abstract <T> void getDeclaredTypes(String var1, ClassIndex.NameKind var2, ResultConvertor<T> var3, Set<? super T> var4) throws IOException, InterruptedException;

    public abstract <T> void getDeclaredElements(String var1, ClassIndex.NameKind var2, ResultConvertor<T> var3, Map<T, Set<String>> var4) throws IOException, InterruptedException;

    public abstract void getPackageNames(String var1, boolean var2, Set<String> var3) throws IOException, InterruptedException;

    public abstract FileObject[] getSourceRoots();

    public abstract BinaryAnalyser getBinaryAnalyser();

    public abstract SourceAnalyser getSourceAnalyser();

    public abstract String getSourceName(String var1) throws IOException;

    public abstract void setDirty(URL var1);

    public abstract boolean isSource();

    public abstract boolean isEmpty();

    protected abstract void close() throws IOException;

    public void addClassIndexImplListener(ClassIndexImplListener classIndexImplListener) {
        assert (classIndexImplListener != null);
        this.listeners.add(new Ref(classIndexImplListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassIndexImplListener(ClassIndexImplListener classIndexImplListener) {
        assert (classIndexImplListener != null);
        List<WeakReference<ClassIndexImplListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<ClassIndexImplListener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ClassIndexImplListener> weakReference = iterator.next();
                ClassIndexImplListener classIndexImplListener2 = (ClassIndexImplListener)weakReference.get();
                if (classIndexImplListener != classIndexImplListener2) continue;
                iterator.remove();
            }
        }
    }

    public void typesEvent(Collection<? extends ElementHandle<TypeElement>> collection, Collection<? extends ElementHandle<TypeElement>> collection2, Collection<? extends ElementHandle<TypeElement>> collection3) {
        ClassIndexImplEvent classIndexImplEvent = collection == null || collection.isEmpty() ? null : new ClassIndexImplEvent(this, collection);
        ClassIndexImplEvent classIndexImplEvent2 = collection2 == null || collection2.isEmpty() ? null : new ClassIndexImplEvent(this, collection2);
        ClassIndexImplEvent classIndexImplEvent3 = collection3 == null || collection3.isEmpty() ? null : new ClassIndexImplEvent(this, collection3);
        this.typesEvent(classIndexImplEvent, classIndexImplEvent2, classIndexImplEvent3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typesEvent(ClassIndexImplEvent classIndexImplEvent, ClassIndexImplEvent classIndexImplEvent2, ClassIndexImplEvent classIndexImplEvent3) {
        WeakReference[] weakReferenceArray = this.listeners;
        synchronized (this.listeners) {
            WeakReference[] weakReferenceArray2 = this.listeners.toArray(new WeakReference[this.listeners.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (WeakReference weakReference : weakReferenceArray2) {
                ClassIndexImplListener classIndexImplListener = (ClassIndexImplListener)weakReference.get();
                if (classIndexImplListener == null) continue;
                if (classIndexImplEvent != null) {
                    classIndexImplListener.typesAdded(classIndexImplEvent);
                }
                if (classIndexImplEvent2 != null) {
                    classIndexImplListener.typesRemoved(classIndexImplEvent2);
                }
                if (classIndexImplEvent3 == null) continue;
                classIndexImplListener.typesChanged(classIndexImplEvent3);
            }
            return;
        }
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        assert (state != null);
        assert (this.state != null);
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException();
        }
        this.state = state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Ref
    extends WeakReference<ClassIndexImplListener>
    implements Runnable {
        public Ref(ClassIndexImplListener classIndexImplListener) {
            super(classIndexImplListener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            ClassIndexImpl.this.listeners.remove(this);
        }
    }

    public static final class IndexAlreadyClosedException
    extends IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        INITIALIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsageType {
        SUPER_CLASS(0),
        SUPER_INTERFACE(1),
        FIELD_REFERENCE(2),
        METHOD_REFERENCE(3),
        TYPE_REFERENCE(4);

        private int offset;

        private UsageType(int n2) {
            this.offset = n2;
        }

        int getOffset() {
            return this.offset;
        }
    }
}

