/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TranslatePositionsVisitor
extends TreeScanner<Void, Void> {
    private final MethodTree changedMethod;
    private final Map<JCTree, Integer> endPos;
    private final int delta;
    boolean active;
    boolean inMethod;

    public TranslatePositionsVisitor(MethodTree methodTree, Map<JCTree, Integer> map, int n) {
        assert (methodTree != null);
        assert (map != null);
        this.changedMethod = methodTree;
        this.endPos = map;
        this.delta = n;
    }

    @Override
    public Void scan(Tree tree, Void void_) {
        Integer n;
        if (this.active && tree != null && ((JCTree)tree).pos >= 0) {
            ((JCTree)tree).pos += this.delta;
        }
        Void void_2 = (Void)super.scan(tree, void_);
        if (this.inMethod && tree != null) {
            this.endPos.remove(tree);
        }
        if (this.active && tree != null && (n = this.endPos.remove(tree)) != null) {
            int n2 = n < 0 ? n : n + this.delta;
            this.endPos.put((JCTree)tree, n2);
        }
        return void_2;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Void void_) {
        return (Void)this.scan(compilationUnitTree.getTypeDecls(), void_);
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void void_) {
        if (this.active || this.inMethod) {
            this.scan((Tree)methodTree.getModifiers(), void_);
            this.scan(methodTree.getReturnType(), void_);
            this.scan(methodTree.getTypeParameters(), void_);
            this.scan(methodTree.getParameters(), void_);
            this.scan(methodTree.getThrows(), void_);
        }
        if (methodTree == this.changedMethod) {
            this.inMethod = true;
        }
        if (this.active || this.inMethod) {
            this.scan((Tree)methodTree.getBody(), void_);
        }
        if (this.inMethod) {
            this.active = this.inMethod;
            this.inMethod = false;
        }
        if (this.active || this.inMethod) {
            this.scan(methodTree.getDefaultValue(), void_);
        }
        return null;
    }
}

