/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileManager
implements JavaFileManager {
    private final ClassPath sourceRoots;
    private final boolean ignoreExcludes;
    private static Logger log = Logger.getLogger(SourceFileManager.class.getName());

    public SourceFileManager(ClassPath classPath, boolean bl) {
        this.sourceRoots = classPath;
        this.ignoreExcludes = bl;
    }

    public List<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) {
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        String string2 = string.replace('.', '/');
        if (string2.length() != 0) {
            string2 = string2 + '/';
        }
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject fileObject;
            FileObject fileObject2;
            if (!this.ignoreExcludes && !entry.includes(string2) || (fileObject2 = entry.getRoot()) == null || (fileObject = fileObject2.getFileObject(string2)) == null || !fileObject.isFolder()) continue;
            Enumeration enumeration = fileObject.getChildren(bl);
            while (enumeration.hasMoreElements()) {
                String string3;
                JavaFileObject.Kind kind;
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                if (!this.ignoreExcludes && !entry.includes(fileObject3) || !set.contains((Object)(kind = "java".equalsIgnoreCase(string3 = fileObject3.getExt()) ? JavaFileObject.Kind.SOURCE : ("class".equalsIgnoreCase(string3) || "sig".equalsIgnoreCase(string3) ? JavaFileObject.Kind.CLASS : ("html".equalsIgnoreCase(string3) ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER))))) continue;
                arrayList.add(SourceFileObject.create(fileObject3, fileObject2));
            }
        }
        return arrayList;
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) {
        String string3 = FileObjects.getRelativePath(string, string2);
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject fileObject;
            FileObject fileObject2;
            if (!this.ignoreExcludes && !entry.includes(string3) || (fileObject2 = entry.getRoot()) == null || (fileObject = fileObject2.getFileObject(string3)) == null) continue;
            return SourceFileObject.create(fileObject, fileObject2);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) {
        String[] stringArray = FileObjects.getParentRelativePathAndName(string);
        if (stringArray == null) {
            return null;
        }
        String string2 = kind == JavaFileObject.Kind.CLASS ? "sig" : kind.extension.substring(1);
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject[] fileObjectArray;
            FileObject fileObject;
            FileObject fileObject2 = entry.getRoot();
            if (fileObject2 == null || (fileObject = fileObject2.getFileObject(stringArray[0])) == null) continue;
            for (FileObject fileObject3 : fileObjectArray = fileObject.getChildren()) {
                if (!stringArray[1].equals(fileObject3.getName()) || !string2.equalsIgnoreCase(fileObject3.getExt()) || !this.ignoreExcludes && !entry.includes(fileObject3)) continue;
                return SourceFileObject.create(fileObject3, fileObject2);
            }
        }
        return null;
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("The SourceFileManager does not support write operations.");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("The SourceFileManager does not support write operations.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        block9: {
            try {
                String string;
                if (javaFileObject instanceof FileObjects.InferableJavaFileObject && (string = ((FileObjects.InferableJavaFileObject)javaFileObject).inferBinaryName()) != null) {
                    return string;
                }
                Object object = null;
                if (javaFileObject instanceof SourceFileObject) {
                    string = ((SourceFileObject)javaFileObject).file;
                    object = ((SourceFileObject)javaFileObject).root;
                } else {
                    string = URLMapper.findFileObject((URL)javaFileObject.toUri().toURL());
                }
                if (object == null) {
                    for (FileObject fileObject : this.sourceRoots.getRoots()) {
                        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)string)) continue;
                        object = fileObject;
                    }
                }
                if (object != null) {
                    String string2 = FileUtil.getRelativePath((FileObject)object, (FileObject)string);
                    int n = string2.lastIndexOf(46);
                    assert (n > 0);
                    String string3 = string2.substring(0, n).replace('/', '.');
                    return string3;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!log.isLoggable(Level.SEVERE)) break block9;
                log.log(Level.SEVERE, malformedURLException.getMessage(), malformedURLException);
            }
        }
        return null;
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject fileObject, javax.tools.FileObject fileObject2) {
        return fileObject instanceof SourceFileObject && fileObject2 instanceof SourceFileObject && ((SourceFileObject)fileObject).file == ((SourceFileObject)fileObject2).file;
    }
}

