/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public final class PatchedHtmlRenderer {
    private static Stack<Color> colorStack = new Stack();
    public static final int STYLE_CLIP = 0;
    public static final int STYLE_TRUNCATE = 1;
    private static final int STYLE_WORDWRAP = 2;
    private static final boolean STRICT_HTML = Boolean.getBoolean("netbeans.lwhtml.strict");
    private static Set<String> badStrings = null;
    private static final Object[] entities = new Object[]{new char[]{'g', 't'}, new char[]{'l', 't'}, new char[]{'q', 'u', 'o', 't'}, new char[]{'a', 'm', 'p'}, new char[]{'l', 's', 'q', 'u', 'o'}, new char[]{'r', 's', 'q', 'u', 'o'}, new char[]{'l', 'd', 'q', 'u', 'o'}, new char[]{'r', 'd', 'q', 'u', 'o'}, new char[]{'n', 'd', 'a', 's', 'h'}, new char[]{'m', 'd', 'a', 's', 'h'}, new char[]{'n', 'e'}, new char[]{'l', 'e'}, new char[]{'g', 'e'}, new char[]{'c', 'o', 'p', 'y'}, new char[]{'r', 'e', 'g'}, new char[]{'t', 'r', 'a', 'd', 'e'}, new char[]{'n', 'b', 's', 'p'}};
    private static final char[] entitySubstitutions = new char[]{'>', '<', '\"', '&', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u2260', '\u2264', '\u2265', '\u00a9', '\u00ae', '\u2122', ' '};

    private PatchedHtmlRenderer() {
    }

    public static double renderPlainString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        if (n5 < 0 || n5 > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + n5);
        }
        return PatchedHtmlRenderer._renderPlainString(string, graphics, n, n2, n3, n4, font, color, n5, bl);
    }

    private static double _renderPlainString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        Object object;
        if (font == null && (font = UIManager.getFont("controlFont")) == null) {
            int n6 = 11;
            object = UIManager.get("customFontSize");
            if (object instanceof Integer) {
                n6 = (Integer)object;
            }
            font = new Font("Dialog", 0, n6);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        object = fontMetrics.getStringBounds(string, graphics);
        if (bl) {
            graphics.setColor(color);
            graphics.setFont(font);
            if (((RectangularShape)object).getWidth() <= (double)n3 || n5 == 0) {
                graphics.drawString(string, n, n2);
            } else {
                char[] cArray = string.toCharArray();
                if (cArray.length == 0) {
                    return 0.0;
                }
                double d = ((RectangularShape)object).getWidth() / (double)cArray.length;
                int n7 = new Double((((RectangularShape)object).getWidth() - (double)n3) / d).intValue();
                if (n5 == 1) {
                    int n8 = cArray.length - n7;
                    if (n8 <= 0) {
                        return 0.0;
                    }
                    if (bl) {
                        if (n8 > 3) {
                            Arrays.fill(cArray, n8 - 3, n8, '.');
                            graphics.drawChars(cArray, 0, n8, n, n2);
                        } else {
                            Shape shape = graphics.getClip();
                            if (string != null) {
                                Area area = new Area(shape);
                                area.intersect(new Area(new Rectangle(n, n2, n3, n4)));
                                graphics.setClip(area);
                            } else {
                                graphics.setClip(new Rectangle(n, n2, n3, n4));
                            }
                            graphics.drawString("...", n, n2);
                            graphics.setClip(shape);
                        }
                    }
                }
            }
        }
        return ((RectangularShape)object).getWidth();
    }

    public static double renderString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        switch (n5) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rendering mode: " + n5);
            }
        }
        if (string.startsWith("<html") || string.startsWith("<HTML")) {
            return PatchedHtmlRenderer._renderHTML(string, 6, graphics, n, n2, n3, n4, font, color, n5, bl, null, false);
        }
        return PatchedHtmlRenderer.renderPlainString(string, graphics, n, n2, n3, n4, font, color, n5, bl);
    }

    public static double renderHTML(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl, boolean bl2) {
        if (n5 < 0 || n5 > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + n5);
        }
        return PatchedHtmlRenderer._renderHTML(string, 0, graphics, n, n2, n3, n4, font, color, n5, bl, null, bl2);
    }

    static double _renderHTML(String string, int n, Graphics graphics, int n2, int n3, int n4, int n5, Font font, Color color, int n6, boolean bl, Color color2, boolean bl2) {
        Object object;
        if (font == null && (font = UIManager.getFont("controlFont")) == null) {
            int n7 = 11;
            object = UIManager.get("customFontSize");
            if (object instanceof Integer) {
                n7 = (Integer)object;
            }
            font = new Font("Dialog", 0, n7);
        }
        Stack<Color> stack = SwingUtilities.isEventDispatchThread() ? colorStack : new Stack<Color>();
        graphics.setColor(color);
        graphics.setFont(font);
        object = string.toCharArray();
        int n8 = n2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl11 = false;
        double d3 = 0.0;
        double d4 = 0.0;
        if (n6 == 1) {
            d4 = graphics.getFontMetrics().stringWidth("...");
        }
        stack.clear();
        while (!bl3) {
            int n9;
            int n10;
            int n11;
            block88: {
                block90: {
                    block89: {
                        boolean bl12;
                        if (n == string.length()) {
                            return d;
                        }
                        try {
                            bl12 = object[n] == 60;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = new ArrayIndexOutOfBoundsException("HTML rendering failed at position " + n + " in String \"" + string + "\".  Please report this at http://www.netbeans.org");
                            if (STRICT_HTML) {
                                throw arrayIndexOutOfBoundsException2;
                            }
                            ErrorManager.getDefault().notify(16, (Throwable)arrayIndexOutOfBoundsException2);
                            return PatchedHtmlRenderer.renderPlainString(string, graphics, n2, n3, n4, n5, font, color, n6, bl);
                        }
                        boolean bl13 = bl5 = (bl4 |= bl12) && n + 1 < ((Object)object).length && object[n + 1] == 47;
                        if (bl10) {
                            graphics.setColor(color);
                            graphics.setFont(font);
                            if (bl) {
                                graphics.drawString("...", n2, n3);
                            }
                            bl3 = true;
                            continue;
                        }
                        if (!bl4) break block88;
                        boolean bl14 = bl3 = (n11 = ++n) >= ((Object)object).length - 1;
                        while (!bl3 && object[n11] != 62) {
                            bl3 = n11 == ((Object)object).length - 1;
                            ++n11;
                        }
                        if (bl3) {
                            throw new IllegalArgumentException("HTML rendering failed on string \"" + string + "\"");
                        }
                        if (!bl5) break block89;
                        block1 : switch (object[++n]) {
                            case 72: 
                            case 80: 
                            case 104: 
                            case 112: {
                                break;
                            }
                            case 66: 
                            case 98: {
                                if (object[n + 1] != 114) {
                                    if (object[n + 1] == 82) break;
                                    if (!bl8) {
                                        PatchedHtmlRenderer.throwBadHTML("Closing bold tag w/o opening bold tag", n, (char[])object);
                                    }
                                    if (bl9) {
                                        graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 2));
                                    } else {
                                        graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 0));
                                    }
                                    bl8 = false;
                                    break;
                                }
                                break block90;
                            }
                            case 69: 
                            case 73: 
                            case 101: 
                            case 105: {
                                if (bl8) {
                                    graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 1));
                                } else {
                                    graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 0));
                                }
                                if (!bl9) {
                                    PatchedHtmlRenderer.throwBadHTML("Closing italics tag w/oopening italics tag", n, (char[])object);
                                }
                                bl9 = false;
                                break;
                            }
                            case 83: 
                            case 115: {
                                switch (object[n + 1]) {
                                    case 84: 
                                    case 116: {
                                        if (bl9) {
                                            graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 2));
                                        } else {
                                            graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 0));
                                        }
                                        bl8 = false;
                                        break block1;
                                    }
                                    case 62: {
                                        bl6 = false;
                                    }
                                }
                                break;
                            }
                            case 85: 
                            case 117: {
                                bl7 = false;
                                break;
                            }
                            case 70: 
                            case 102: {
                                if (stack.isEmpty()) {
                                    graphics.setColor(color);
                                    break;
                                }
                                graphics.setColor((Color)stack.pop());
                                break;
                            }
                            default: {
                                PatchedHtmlRenderer.throwBadHTML("Malformed or unsupported HTML", n, (char[])object);
                                break;
                            }
                        }
                        break block90;
                    }
                    switch (object[n]) {
                        case 66: 
                        case 98: {
                            switch (object[n + 1]) {
                                case 82: 
                                case 114: {
                                    if (n6 != 2) break;
                                    n2 = n8;
                                    int n12 = graphics.getFontMetrics().getHeight();
                                    n3 += n12;
                                    d2 += (double)n12;
                                    d = 0.0;
                                    break;
                                }
                                case 62: {
                                    bl8 = true;
                                    if (bl9) {
                                        graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 3));
                                        break;
                                    }
                                    graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 1));
                                }
                            }
                            break;
                        }
                        case 69: 
                        case 73: 
                        case 101: 
                        case 105: {
                            bl9 = true;
                            if (bl8) {
                                graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 3));
                                break;
                            }
                            graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 2));
                            break;
                        }
                        case 83: 
                        case 115: {
                            switch (object[n + 1]) {
                                case 62: {
                                    bl6 = true;
                                    break;
                                }
                                case 84: 
                                case 116: {
                                    bl8 = true;
                                    if (bl9) {
                                        graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 3));
                                        break;
                                    }
                                    graphics.setFont(PatchedHtmlRenderer.deriveFont(font, 1));
                                }
                            }
                            break;
                        }
                        case 85: 
                        case 117: {
                            bl7 = true;
                            break;
                        }
                        case 70: 
                        case 102: {
                            Color color3 = PatchedHtmlRenderer.findColor((char[])object, n, n11);
                            stack.push(graphics.getColor());
                            if (color2 != null) {
                                // empty if block
                            }
                            if (bl2) break;
                            graphics.setColor(color3);
                            break;
                        }
                        case 80: 
                        case 112: {
                            if (n6 != 2) break;
                            n2 = n8;
                            n10 = graphics.getFontMetrics().getHeight();
                            d2 = (n3 += n10 + n10 / 2) + n10;
                            d = 0.0;
                            break;
                        }
                        case 72: 
                        case 104: {
                            if (n == 1) break;
                        }
                        default: {
                            PatchedHtmlRenderer.throwBadHTML("Malformed or unsupported HTML", n, (char[])object);
                        }
                    }
                }
                n = n11 + (bl3 ? 0 : 1);
                bl4 = false;
                continue;
            }
            if (bl11) {
                while (n < string.length() - 1 && Character.isWhitespace((char)object[n])) {
                    ++n;
                }
                if (n == ((Object)object).length - 1) {
                    return n6 != 2 ? d : d2;
                }
            }
            n11 = 0;
            boolean bl15 = false;
            n10 = ((Object)object).length - 1;
            if (object[n] == 38) {
                int n13 = n9 = n != ((Object)object).length - 1 ? 1 : 0;
                if (n9 != 0) {
                    int n14 = PatchedHtmlRenderer.substEntity((char[])object, n + 1);
                    int n15 = n9 = n14 != -1 ? 1 : 0;
                    if (n9 != 0) {
                        n = n14;
                        n11 = object[n] == 38 ? 1 : 0;
                        bl15 = object[n] == 60;
                    } else {
                        bl15 = false;
                        n11 = 1;
                    }
                }
            } else {
                bl15 = false;
            }
            for (n9 = n; n9 < ((Object)object).length; ++n9) {
                if (object[n9] == 60 && !bl15 || object[n9] == 38 && n11 == 0) {
                    n10 = n9 - 1;
                    break;
                }
                n11 = 0;
                bl15 = false;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds((char[])object, n, n10 + 1, graphics);
            d3 = rectangle2D.getHeight();
            int n16 = n10 + 1 - n;
            boolean bl16 = false;
            boolean bl17 = false;
            double d5 = rectangle2D.getWidth() / (double)n16;
            if (n6 == 1) {
                double d6 = d + rectangle2D.getWidth();
                if (d6 > (double)n4 - d4 && (d6 > (double)n4 || PatchedHtmlRenderer._renderHTML(string, 0, graphics.create(), n2, n3, Integer.MAX_VALUE, n5, font, color, 0, false, color2, bl2) > (double)n4)) {
                    double d7 = d + rectangle2D.getWidth() - (double)n4 - d4;
                    double d8 = d7 / d5;
                    n16 = new Double(((double)n4 - d4 - d) / d5).intValue();
                    if (n16 < 0) {
                        n16 = 0;
                    }
                    rectangle2D = fontMetrics.getStringBounds((char[])object, n, n + n16, graphics);
                    bl10 = true;
                }
            } else if (n6 == 2 && d + rectangle2D.getWidth() > (double)n4 && d5 > 3.0) {
                int n17;
                double d9 = d + (rectangle2D.getWidth() + 5.0) - (double)n4;
                double d10 = d9 / d5;
                bl16 = true;
                int n18 = new Double((double)n10 - d10).intValue();
                bl17 = n2 == 0;
                for (n17 = n18; n17 > n; --n17) {
                    --n18;
                    if (!Character.isWhitespace((char)object[n17])) continue;
                    n16 = n18 - n + 1;
                    bl17 = false;
                    break;
                }
                if (n18 <= n && (double)n16 > d10 && !bl17) {
                    n2 = n8;
                    n3 = (int)((double)n3 + rectangle2D.getHeight());
                    d2 += rectangle2D.getHeight();
                    n17 = 0;
                    while (!bl3 && Character.isWhitespace((char)object[n]) && n < n10) {
                        n17 = 1;
                        bl3 = ++n == ((Object)object).length - 1;
                    }
                    if (n == n10) {
                        bl11 = true;
                    }
                    if (n17 != 0) {
                        rectangle2D = fontMetrics.getStringBounds((char[])object, n, n10 + 1, graphics);
                    }
                    bl16 = false;
                    d = 0.0;
                    if (object[n - 1 + n16] == 60) {
                        --n16;
                    }
                } else if (bl17) {
                    n16 = new Double(((double)n4 - d) / d5).intValue();
                    if (n + n16 > n10) {
                        n16 = n10 - n;
                    }
                    bl16 = true;
                }
            }
            if (bl3) continue;
            if (bl) {
                graphics.drawChars((char[])object, n, n16, n2, n3);
            }
            if (bl6 || bl7) {
                LineMetrics lineMetrics = fontMetrics.getLineMetrics((char[])object, n, n16 - 1, graphics);
                int n19 = new Double((double)n2 + rectangle2D.getWidth()).intValue();
                if (bl) {
                    if (bl6) {
                        int n20 = Math.round(lineMetrics.getStrikethroughOffset()) + graphics.getFont().getBaselineFor((char)object[n]) + 1;
                        graphics.drawLine(n2, n3 + n20, n19, n3 + n20);
                    }
                    if (bl7) {
                        int n21 = Math.round(lineMetrics.getUnderlineOffset()) + graphics.getFont().getBaselineFor((char)object[n]) + 1;
                        graphics.drawLine(n2, n3 + n21, n19, n3 + n21);
                    }
                }
            }
            if (bl16) {
                n2 = n8;
                n3 = (int)((double)n3 + rectangle2D.getHeight());
                d2 += rectangle2D.getHeight();
                d = 0.0;
                n += n16;
                while (n < ((Object)object).length && Character.isWhitespace((char)object[n]) && object[n] != 60) {
                    ++n;
                }
                bl11 = true;
                bl3 |= n >= ((Object)object).length;
            } else {
                n2 = (int)((double)n2 + rectangle2D.getWidth());
                d += rectangle2D.getWidth();
                bl11 = Character.isWhitespace((char)object[n10]);
                n = n10 + 1;
            }
            bl3 |= n10 == ((Object)object).length;
        }
        if (n6 != 2) {
            return d;
        }
        return d2 + d3;
    }

    private static Color findColor(char[] cArray, int n, int n2) {
        String string;
        int n3;
        int n4 = n;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != 'c') continue;
            n4 = i + 6;
            if (cArray[n4] == '\'' || cArray[n4] == '\"') {
                ++n4;
            }
            if (cArray[n4] == '#') {
                ++n4;
                break;
            }
            if (cArray[n4] != '!') break;
            bl = true;
            ++n4;
            break;
        }
        if (n4 == n) {
            Color color = UIManager.getColor("textText");
            if (color == null) {
                color = Color.BLACK;
            }
            return color;
        }
        if (bl) {
            int n5 = cArray.length - 1;
            for (n3 = n4; n3 < cArray.length; ++n3) {
                if (cArray[n3] != '\"' && cArray[n3] != '\'') continue;
                n5 = n3;
                break;
            }
            string = new String(cArray, n4, n5 - n4);
        } else {
            string = new String(cArray, n4, 6);
        }
        Color color = null;
        if (bl) {
            color = UIManager.getColor(string);
            if (color == null) {
                PatchedHtmlRenderer.throwBadHTML("Could not resolve logical font declared in HTML: " + string, n, cArray);
                color = UIManager.getColor("textText");
                if (color == null) {
                    color = Color.BLACK;
                }
            }
        } else {
            try {
                n3 = Integer.parseInt(string, 16);
                color = new Color(n3);
            }
            catch (NumberFormatException numberFormatException) {
                PatchedHtmlRenderer.throwBadHTML("Illegal hexadecimal color text: " + string + " in HTML string", n4, cArray);
            }
        }
        if (color == null) {
            PatchedHtmlRenderer.throwBadHTML("Unresolvable html color: " + string + " in HTML string \n  ", n, cArray);
        }
        return color;
    }

    private static final Font deriveFont(Font font, int n) {
        Font font2 = Utilities.isMac() ? new Font(font.getName(), n, font.getSize()) : font.deriveFont(n);
        return font2;
    }

    private static final int substEntity(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            return -1;
        }
        if (cArray[n] == '#') {
            return PatchedHtmlRenderer.substNumericEntity(cArray, n + 1);
        }
        for (int i = 0; i < entities.length; ++i) {
            char[] cArray2 = (char[])entities[i];
            boolean bl = true;
            if (cArray2.length < cArray.length - n) {
                for (int j = 0; j < cArray2.length; ++j) {
                    bl &= cArray2[j] == cArray[j + n];
                }
            } else {
                bl = false;
            }
            if (!bl || cArray[n + cArray2.length] != ';') continue;
            cArray[n + cArray2.length] = entitySubstitutions[i];
            return n + cArray2.length;
        }
        return -1;
    }

    private static final int substNumericEntity(char[] cArray, int n) {
        for (int i = n; i < cArray.length; ++i) {
            if (cArray[i] != ';') continue;
            try {
                cArray[i] = (char)Integer.parseInt(new String(cArray, n, i - n));
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                PatchedHtmlRenderer.throwBadHTML("Unparsable numeric entity: " + new String(cArray, n, i - n), n, cArray);
            }
        }
        return -1;
    }

    private static void throwBadHTML(String string, int n, char[] cArray) {
        char[] cArray2 = new char[n];
        Arrays.fill(cArray2, ' ');
        cArray2[n - 1] = 94;
        String string2 = string + "\n  " + new String(cArray) + "\n  " + new String(cArray2) + "\n Full HTML string:" + new String(cArray);
        if (!STRICT_HTML) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                if (badStrings == null) {
                    badStrings = new HashSet<String>();
                }
                if (!badStrings.contains(string)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        ErrorManager.getDefault().log(16, stringTokenizer.nextToken());
                    }
                    badStrings.add(string.intern());
                }
            }
        } else {
            throw new IllegalArgumentException(string2);
        }
    }
}

