/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserServletContext
implements ServletContext {
    public static final String JSP_TAGLIBRARY_CACHE = "com.sun.jsp.taglibraryCache";
    public static final String JSP_TAGFILE_JAR_URLS_CACHE = "com.sun.jsp.tagFileJarUrlsCache";
    private static final Logger LOGGER = Logger.getLogger(ParserServletContext.class.getName());
    protected Hashtable<String, Object> myAttributes;
    protected FileObject wmRoot;
    private final WebModuleProvider webModuleProvider;
    protected boolean useEditorVersion;

    public ParserServletContext(FileObject fileObject, WebModuleProvider webModuleProvider, boolean bl) {
        LOGGER.log(Level.FINE, "ParserServletContext created");
        this.myAttributes = new Hashtable();
        this.wmRoot = fileObject;
        this.webModuleProvider = webModuleProvider;
        this.useEditorVersion = bl;
        this.setAttribute(JSP_TAGLIBRARY_CACHE, new ConcurrentHashMap());
        this.setAttribute(JSP_TAGFILE_JAR_URLS_CACHE, new ConcurrentHashMap());
    }

    public Object getAttribute(String string) {
        LOGGER.log(Level.FINE, "getAttribute({0}) = {1}", new Object[]{string, this.myAttributes.get(string)});
        return this.myAttributes.get(string);
    }

    public Enumeration<String> getAttributeNames() {
        return this.myAttributes.keys();
    }

    public ServletContext getContext(String string) {
        return null;
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String string) {
        return null;
    }

    public int getMinorVersion() {
        return 3;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    protected FileObject getResourceAsObject(String string) {
        LOGGER.log(Level.FINE, "getResourceAsObject({0})", string);
        FileObject fileObject = null;
        if (this.wmRoot != null) {
            fileObject = this.wmRoot.getFileObject(string);
        }
        WebModule webModule = this.webModuleProvider.getWebModule();
        if (fileObject == null && string != null && webModule != null && webModule.getWebInf() != null) {
            int n = string.toLowerCase().indexOf("web-inf");
            if (n > -1) {
                String string2 = string.substring(n + 7);
                fileObject = webModule.getWebInf().getFileObject(string2);
            } else {
                fileObject = webModule.getWebInf().getFileObject(string);
            }
        }
        return fileObject;
    }

    public String getRealPath(String string) {
        File file;
        LOGGER.log(Level.FINE, "getRealPath({0})", string);
        if (!string.startsWith("/")) {
            return null;
        }
        FileObject fileObject = this.getResourceAsObject(string);
        if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public URL getResource(String string) throws MalformedURLException {
        LOGGER.log(Level.FINE, "getResource({0})", string);
        if (!string.startsWith("/")) {
            throw new MalformedURLException(NbBundle.getMessage(ParserServletContext.class, (String)"EXC_PathMustStartWithSlash", (Object)string));
        }
        FileObject fileObject = this.getResourceAsObject(string);
        if (fileObject == null) {
            return null;
        }
        return URLMapper.findURL((FileObject)fileObject, (int)1);
    }

    public InputStream getResourceAsStream(String string) {
        Object object;
        LOGGER.log(Level.FINE, "getResourceAsStream({0})", string);
        FileObject fileObject = this.getResourceAsObject(string);
        if (fileObject != null && this.useEditorVersion && (object = this.getEditorInputStream(fileObject)) != null) {
            return object;
        }
        try {
            object = this.getResource(string);
            if (object == null) {
                return null;
            }
            return ((URL)object).openStream();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.INFO, null, throwable);
            return null;
        }
    }

    private InputStream getEditorInputStream(FileObject fileObject) {
        InputStream inputStream = null;
        EditorCookie editorCookie = null;
        try {
            editorCookie = (EditorCookie)DataObject.find((FileObject)fileObject).getCookie(EditorCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOGGER.log(Level.INFO, null, dataObjectNotFoundException);
        }
        if (editorCookie != null && editorCookie instanceof CloneableEditorSupport) {
            try {
                inputStream = ((CloneableEditorSupport)editorCookie).getInputStream();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
        return inputStream;
    }

    public Set<String> getResourcePaths(String string) {
        String string2;
        LOGGER.log(Level.FINE, "getResourcePaths({0})", string);
        HashSet<String> hashSet = new HashSet<String>();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((string2 = this.getRealPath(string)) == null) {
            return hashSet;
        }
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return hashSet;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string2 + File.separator + stringArray[i]);
            if (file2.isFile()) {
                hashSet.add(string + stringArray[i]);
                continue;
            }
            if (!file2.isDirectory()) continue;
            hashSet.add(string + stringArray[i] + "/");
        }
        return hashSet;
    }

    public String getServerInfo() {
        return "NB.ParserServletContext/1.0";
    }

    public Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    public Enumeration getServletNames() {
        return new Vector().elements();
    }

    public Enumeration getServlets() {
        return new Vector().elements();
    }

    public void log(String string) {
        LOGGER.log(Level.INFO, string);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string, Throwable throwable) {
        LOGGER.log(Level.INFO, string);
        LOGGER.log(Level.INFO, null, throwable);
    }

    public void removeAttribute(String string) {
        this.myAttributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.myAttributes.put(string, object);
    }

    public String getContextPath() {
        return "";
    }

    public static interface WebModuleProvider {
        public WebModule getWebModule();
    }
}

