/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.upgrade.systemoptions.ContentProcessor;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.Result;
import org.netbeans.upgrade.systemoptions.SerParser;
import org.netbeans.upgrade.systemoptions.SettingsRecognizer;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemOptionsParser {
    static final String EXPECTED_INSTANCE = "org.openide.options.SystemOption";
    private String systemOptionInstanceName;
    private boolean types;

    private SystemOptionsParser(String string, boolean bl) {
        this.systemOptionInstanceName = string;
        this.types = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultResult parse(FileObject fileObject, boolean bl) throws IOException, ClassNotFoundException {
        SettingsRecognizer settingsRecognizer = SystemOptionsParser.getRecognizer(fileObject);
        SystemOptionsParser systemOptionsParser = null;
        InputStream inputStream = settingsRecognizer.getSerializedInstance();
        try {
            SerParser serParser = new SerParser(inputStream);
            SerParser.Stream stream = serParser.parse();
            systemOptionsParser = new SystemOptionsParser(settingsRecognizer.instanceName(), bl);
            DefaultResult defaultResult = (DefaultResult)systemOptionsParser.processContent(stream.contents.iterator(), false);
            defaultResult.setModuleName(settingsRecognizer.getCodeNameBase().replace('.', '/'));
            DefaultResult defaultResult2 = defaultResult;
            return defaultResult2;
        }
        finally {
            inputStream.close();
        }
    }

    private Result processContent(Iterator<Object> iterator, boolean bl) {
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3 = iterator.next();
            if (!bl && object3 instanceof SerParser.ObjectWrapper) {
                object2 = (SerParser.ObjectWrapper)object3;
                object = ((SerParser.ObjectWrapper)object2).classdesc.name;
                if (!((String)object).endsWith("org.openide.util.SharedClassObject$WriteReplace;")) continue;
                return this.processContent(((SerParser.ObjectWrapper)object2).data.iterator(), true);
            }
            if (!bl || !(object3 instanceof SerParser.NameValue)) continue;
            object2 = (SerParser.NameValue)object3;
            if (!this.systemOptionInstanceName.equals(((SerParser.NameValue)object2).value)) continue;
            object = ContentProcessor.parseContent(this.systemOptionInstanceName, this.types, iterator);
            return object;
        }
        return null;
    }

    private static SettingsRecognizer getRecognizer(FileObject fileObject) throws IOException {
        SettingsRecognizer settingsRecognizer = new SettingsRecognizer(false, fileObject);
        settingsRecognizer.parse();
        Set set = settingsRecognizer.getInstanceOf();
        String string = settingsRecognizer.instanceName();
        if (!set.contains(EXPECTED_INSTANCE)) {
            throw new IOException(string);
        }
        return settingsRecognizer;
    }
}

