/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.openide.util.NbBundle;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SchemaXsdBasedValidator
extends XsdBasedValidator {
    private static Schema schema;

    protected Schema getSchema(Model model) {
        block4: {
            if (!(model instanceof SchemaModel)) {
                return null;
            }
            if (schema == null) {
                try {
                    schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
                }
                catch (SAXException sAXException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"Error while creating compiled schema for");
                }
            }
        }
        return schema;
    }

    public String getName() {
        return NbBundle.getMessage(SchemaXsdBasedValidator.class, (String)"LBL_Schema_Validator");
    }

    protected void validate(Model model, Schema schema, XsdBasedValidator.Handler handler) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            CatalogModel catalogModel = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
            if (catalogModel != null) {
                schemaFactory.setResourceResolver((LSResourceResolver)catalogModel);
            }
            schemaFactory.setErrorHandler((ErrorHandler)handler);
            Source source = this.getSource(model, handler);
            if (source == null) {
                return;
            }
            schemaFactory.newSchema(source);
        }
        catch (SAXException sAXException) {
        }
        catch (Exception exception) {
            handler.logValidationErrors(Validator.ResultType.ERROR, exception.getMessage());
        }
    }

    public DocumentModel resolveResource(String string, Model model) {
        try {
            CatalogModel catalogModel = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
            ModelSource modelSource = catalogModel.getModelSource(new URI(string));
            if (modelSource != null) {
                return SchemaModelFactory.getDefault().getModel(modelSource);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", uRISyntaxException);
        }
        catch (CatalogModelException catalogModelException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", catalogModelException);
        }
        return null;
    }
}

