/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.GlobalComponentsIndexSupport;
import org.netbeans.modules.xml.schema.model.impl.RefCacheSupport;
import org.netbeans.modules.xml.schema.model.impl.SchemaAttributes;
import org.netbeans.modules.xml.schema.model.impl.SchemaComponentFactoryImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaElements;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SyncUnitReviewVisitor;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.ChamelionResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.ImportResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.IncludeResolver;
import org.netbeans.modules.xml.schema.model.impl.xdm.SyncUpdateVisitor;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelImpl
extends AbstractDocumentModel<SchemaComponent>
implements SchemaModel {
    private SchemaImpl mSchema;
    private SchemaComponentFactory csef = new SchemaComponentFactoryImpl(this);
    private RefCacheSupport mRefCacheSupport = new RefCacheSupport(this);
    private GlobalComponentsIndexSupport mGlobalIndexSupport = new GlobalComponentsIndexSupport(this);

    public SchemaModelImpl(ModelSource modelSource) {
        super(modelSource);
    }

    public RefCacheSupport getRefCacheSupport() {
        return this.mRefCacheSupport;
    }

    public GlobalComponentsIndexSupport getGlobalComponentsIndexSupport() {
        return this.mGlobalIndexSupport;
    }

    @Override
    public SchemaImpl getSchema() {
        return (SchemaImpl)this.getRootComponent();
    }

    @Override
    public SchemaComponentFactory getFactory() {
        return this.csef;
    }

    public SchemaComponent createRootComponent(Element element) {
        SchemaImpl schemaImpl = (SchemaImpl)this.csef.create(element, null);
        if (schemaImpl == null) {
            return null;
        }
        this.mSchema = schemaImpl;
        return this.getSchema();
    }

    public SchemaComponent getRootComponent() {
        return this.mSchema;
    }

    @Override
    public <T extends NamedReferenceable> T resolve(String string, String string2, Class<T> clazz) {
        if ("http://www.w3.org/2001/XMLSchema".equals(string) && "http://www.w3.org/2001/XMLSchema".equals(this.getSchema().getTargetNamespace())) {
            return this.resolveImpl(string, string2, clazz);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            return schemaModel.findByNameAndType(string2, clazz);
        }
        return this.resolveImpl(string, string2, clazz);
    }

    protected <T extends NamedReferenceable> T resolveImpl(String string, String string2, Class<T> clazz) {
        if (this.getState() != Model.State.VALID) {
            return null;
        }
        SchemaImpl schemaImpl = this.getSchema();
        if (schemaImpl == null) {
            return null;
        }
        String string3 = schemaImpl.getTargetNamespace();
        if (Util.equal(string3, string)) {
            return IncludeResolver.resolve(this, string, string2, clazz);
        }
        if (string3 == null) {
            return ChamelionResolver.resolve(this, string, string2, clazz);
        }
        return ImportResolver.resole(this, string, string2, clazz);
    }

    public SchemaModelImpl resolve(SchemaModelReference schemaModelReference) {
        if (this.mRefCacheSupport == null) {
            try {
                return (SchemaModelImpl)schemaModelReference.resolveReferencedModel();
            }
            catch (CatalogModelException catalogModelException) {
                return null;
            }
        }
        return this.mRefCacheSupport.optimizedResolve(schemaModelReference);
    }

    public Collection<SchemaModelReference> getSchemaModelReferences() {
        ArrayList<SchemaModelReference> arrayList = new ArrayList<SchemaModelReference>();
        SchemaImpl schemaImpl = this.getSchema();
        if (schemaImpl != null) {
            arrayList.addAll(schemaImpl.getRedefines());
            arrayList.addAll(schemaImpl.getIncludes());
            arrayList.addAll(schemaImpl.getImports());
        }
        return arrayList;
    }

    public Collection<SchemaModelReference> getNotImportRefrences() {
        ArrayList<SchemaModelReference> arrayList = new ArrayList<SchemaModelReference>();
        SchemaImpl schemaImpl = this.getSchema();
        if (schemaImpl != null) {
            arrayList.addAll(schemaImpl.getRedefines());
            arrayList.addAll(schemaImpl.getIncludes());
        }
        return arrayList;
    }

    @Override
    public <T extends NamedReferenceable> T findByNameAndType(String string, Class<T> clazz) {
        return this.mGlobalIndexSupport.findByNameAndType(string, clazz);
    }

    public Set<Schema> findSchemas(String string) {
        HashSet<Schema> hashSet = new HashSet<Schema>();
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            hashSet.add(schemaModel.getSchema());
            return hashSet;
        }
        return this._findSchemas(string, hashSet, null);
    }

    Set<Schema> _findSchemas(String string, Set<Schema> set, ReferenceType referenceType) {
        SchemaImpl schemaImpl = this.getSchema();
        if (schemaImpl == null) {
            return set;
        }
        String string2 = schemaImpl.getTargetNamespace();
        if (string2 != null && string2.equals(string) || string2 == null && string == null) {
            set.add(schemaImpl);
        }
        if (referenceType != ReferenceType.IMPORT) {
            this.checkIncludeSchemas(string, set);
            this.checkRedefineSchemas(string, set);
            this.checkImportedSchemas(string, set);
        }
        return set;
    }

    private void checkIncludeSchemas(String string, Set<Schema> set) {
        Collection<Include> collection = this.getSchema().getIncludes();
        for (Include include : collection) {
            try {
                SchemaModel schemaModel = include.resolveReferencedModel();
                if (schemaModel.getState() == Model.State.NOT_WELL_FORMED || set.contains(schemaModel.getSchema())) continue;
                set.addAll(((SchemaModelImpl)schemaModel)._findSchemas(string, set, ReferenceType.INCLUDE));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    private void checkRedefineSchemas(String string, Set<Schema> set) {
        Collection<Redefine> collection = this.getSchema().getRedefines();
        for (Redefine redefine : collection) {
            try {
                SchemaModel schemaModel = redefine.resolveReferencedModel();
                if (schemaModel.getState() == Model.State.NOT_WELL_FORMED || set.contains(schemaModel.getSchema())) continue;
                set.addAll(((SchemaModelImpl)schemaModel)._findSchemas(string, set, ReferenceType.REDEFINE));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    private void checkImportedSchemas(String string, Set<Schema> set) {
        Collection<Import> collection = this.getSchema().getImports();
        for (Import import_ : collection) {
            try {
                SchemaModel schemaModel = import_.resolveReferencedModel();
                if (schemaModel.getState() == Model.State.NOT_WELL_FORMED || set.contains(schemaModel.getSchema())) continue;
                set.addAll(((SchemaModelImpl)schemaModel)._findSchemas(string, set, ReferenceType.IMPORT));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    @Override
    public String getEffectiveNamespace(SchemaComponent schemaComponent) {
        SchemaModel schemaModel = schemaComponent.getModel();
        SchemaImpl schemaImpl = this.getSchema();
        Schema schema = schemaModel.getSchema();
        String string = schemaImpl.getTargetNamespace();
        String string2 = schema.getTargetNamespace();
        if (this == schemaModel) {
            return string;
        }
        if (string2 == null && string != null) {
            Collection<Import> collection = schemaImpl.getImports();
            for (Import import_ : collection) {
                String string3;
                SchemaModel schemaModel2 = null;
                try {
                    schemaModel2 = import_.resolveReferencedModel();
                }
                catch (CatalogModelException catalogModelException) {
                    // empty catch block
                }
                if (schemaModel.equals(schemaModel2)) {
                    return null;
                }
                if (schemaModel2 == null || schemaModel2.getState() == Model.State.NOT_WELL_FORMED || (string3 = schemaModel2.getSchema().getTargetNamespace()) == null) continue;
                Collection collection2 = this.findSchemas(string3);
                for (Schema schema2 : collection2) {
                    if (!schemaModel.equals(schema2.getModel())) continue;
                    return null;
                }
            }
            return string;
        }
        return string2;
    }

    public SchemaComponent createComponent(SchemaComponent schemaComponent, Element element) {
        return (SchemaComponent)this.csef.create(element, schemaComponent);
    }

    protected ComponentUpdater<SchemaComponent> getComponentUpdater() {
        return new SyncUpdateVisitor<SchemaComponent>();
    }

    public Set<QName> getQNames() {
        return SchemaElements.allQNames();
    }

    public SyncUnit prepareSyncUnit(ChangeInfo changeInfo, SyncUnit syncUnit) {
        if ((syncUnit = super.prepareSyncUnit(changeInfo, syncUnit)) != null) {
            return new SyncUnitReviewVisitor().review(syncUnit);
        }
        return null;
    }

    public DocumentModelAccess getAccess() {
        if (this.access == null) {
            super.getAccess().setAutoSync(true);
        }
        return super.getAccess();
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return SchemaAttributes.getQNameValuedAttributes();
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    public String toString() {
        FileObject fileObject;
        Lookup lookup;
        ModelSource modelSource = this.getModelSource();
        if (modelSource != null && (lookup = modelSource.getLookup()) != null && (fileObject = (FileObject)lookup.lookup(FileObject.class)) != null) {
            return fileObject.getNameExt();
        }
        return super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ReferenceType {
        IMPORT,
        INCLUDE,
        REDEFINE;

    }
}

