/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScanningScopeList {
    public static final String PROP_SCOPE_LIST = "scopeList";
    private static final String SCOPE_LIST_PATH = "TaskList/ScanningScopes";
    private static ScanningScopeList theInstance;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Lookup.Result<TaskScanningScope> lookupRes;

    private ScanningScopeList() {
    }

    public static ScanningScopeList getDefault() {
        if (null == theInstance) {
            theInstance = new ScanningScopeList();
        }
        return theInstance;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public List<TaskScanningScope> getTaskScanningScopes() {
        if (null == this.lookupRes) {
            this.lookupRes = this.initLookup();
            this.lookupRes.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ScanningScopeList.this.fireScopeListChange();
                }
            });
        }
        return new ArrayList<TaskScanningScope>(this.lookupRes.allInstances());
    }

    public TaskScanningScope getDefaultScope() {
        List<TaskScanningScope> list = this.getTaskScanningScopes();
        for (TaskScanningScope taskScanningScope : list) {
            if (!Accessor.isDefault(taskScanningScope)) continue;
            return taskScanningScope;
        }
        return list.isEmpty() ? null : list.get(0);
    }

    private Lookup.Result<TaskScanningScope> initLookup() {
        Lookup lookup = Lookups.forPath((String)SCOPE_LIST_PATH);
        Lookup.Template template = new Lookup.Template(TaskScanningScope.class);
        Lookup.Result result = lookup.lookup(template);
        return result;
    }

    private void fireScopeListChange() {
        this.propertySupport.firePropertyChange(PROP_SCOPE_LIST, null, this.getTaskScanningScopes());
    }
}

