/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import org.openide.ErrorManager;

public final class CodeSupport {
    private CodeSupport() {
    }

    public static String encryptStringToJavaCode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block6;
                }
                default: {
                    if (c < ' ') {
                        stringBuffer.append("\\");
                        stringBuffer.append(CodeSupport.alignWithZeros(Integer.toOctalString(c), 3));
                        continue block6;
                    }
                    if (c >= '\u0080') {
                        stringBuffer.append("\\u");
                        stringBuffer.append(CodeSupport.alignWithZeros(Integer.toHexString(c).toUpperCase(), 4));
                        continue block6;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String alignWithZeros(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n -= string.length();
        while (n > 0) {
            stringBuffer.append('0');
            --n;
        }
        if (n < 0) {
            return string.substring(-n);
        }
        return stringBuffer.append(string).toString();
    }

    public static String decryptStringFromJavaCode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        block11: while (n2 < n) {
            char c = string.charAt(n2);
            ++n2;
            if (c != '\\') {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(n2);
            ++n2;
            switch (c) {
                case 'r': {
                    stringBuffer.append('\r');
                    continue block11;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block11;
                }
                case 't': {
                    stringBuffer.append('\t');
                    continue block11;
                }
                case 'u': {
                    if (n2 + 4 > n) {
                        ErrorManager.getDefault().log(1, "WARNING: Invalid hex number at the end: " + string.substring(n2));
                        continue block11;
                    }
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 4), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager.getDefault().log(1, "WARNING: Invalid hex number format: " + string.substring(n2, n2 + 4));
                    }
                    n2 += 4;
                    continue block11;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append(c);
                    continue block11;
                }
            }
            if (c < '0' || c > '9') {
                ErrorManager.getDefault().log(1, "WARNING: Invalid character after slash: " + c);
                continue;
            }
            if (--n2 + 3 > n) {
                ErrorManager.getDefault().log(1, "WARNING: Invalid octal number at the end: " + string.substring(n2));
                continue;
            }
            try {
                stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 3), 8));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager.getDefault().log(1, "WARNING: Invalid octal number format: " + string.substring(n2, n2 + 3));
            }
            n2 += 3;
        }
        return stringBuffer.toString();
    }

    public static int compareStrings(String string, String string2) {
        if (string != null) {
            return string2 != null ? string.compareTo(string2) : 1;
        }
        return string2 != null ? -1 : 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }
}

