/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class Hyperlinker {
    private static final Logger LOG = Logger.getLogger(Hyperlinker.class.getName());
    private final HudsonLogger.HudsonLogSession[] sessions;

    public Hyperlinker(HudsonJob hudsonJob) {
        ArrayList<HudsonLogger.HudsonLogSession> arrayList = new ArrayList<HudsonLogger.HudsonLogSession>();
        for (HudsonLogger hudsonLogger : Lookup.getDefault().lookupAll(HudsonLogger.class)) {
            arrayList.add(hudsonLogger.createSession(hudsonJob));
        }
        this.sessions = arrayList.toArray(new HudsonLogger.HudsonLogSession[arrayList.size()]);
    }

    public void handleLine(String string, OutputWriter outputWriter) {
        for (HudsonLogger.HudsonLogSession hudsonLogSession : this.sessions) {
            if (hudsonLogSession.handle(string, outputWriter)) break;
        }
    }

    private static class URLHyperlink
    implements OutputListener {
        private final URL u;

        URLHyperlink(URL uRL) {
            this.u = uRL;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.u);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public String toString() {
            return this.u.toString();
        }
    }

    private static class Hyperlink
    implements OutputListener {
        private final HudsonJob job;
        private final String path;
        private final String message;
        private final int row;
        private final int col;

        public Hyperlink(HudsonJob hudsonJob, String string, String string2, int n, int n2) {
            this.job = hudsonJob;
            this.path = string;
            this.message = string2;
            this.row = n;
            this.col = n2;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.acted(false);
        }

        private void acted(final boolean bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    FileObject fileObject = null;
                    Project project = ProjectHudsonProvider.getDefault().findAssociatedProject(ProjectHudsonProvider.Association.forJob(Hyperlink.this.job));
                    if (project != null) {
                        String string = null;
                        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                        if (file != null) {
                            for (HudsonSCM hudsonSCM : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                                string = hudsonSCM.translateWorkspacePath(Hyperlink.this.job, Hyperlink.this.path, file);
                                if (string == null) continue;
                                LOG.log(Level.FINE, "Translating remote path {0} to {1} using {2}", new Object[]{Hyperlink.this.path, string, hudsonSCM});
                                break;
                            }
                        }
                        if (string == null) {
                            LOG.fine("Falling back to guess that remote workspace is a project root");
                            string = Hyperlink.this.path;
                        }
                        fileObject = project.getProjectDirectory().getFileObject(string);
                        LOG.log(Level.FINE, "Tried to find local file in {0} at {1} using {2}", new Object[]{project, fileObject, string});
                    }
                    if (fileObject == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Hyperlinker.class, (String)"Hyperlinker.looking_for", (Object)Hyperlink.this.path));
                        fileObject = Hyperlink.this.job.getRemoteWorkspace().findResource(Hyperlink.this.path);
                        LOG.log(Level.FINE, "Tried to find remote file at {0} using {1}", new Object[]{fileObject, Hyperlink.this.path});
                    }
                    if (fileObject == null) {
                        if (bl) {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Hyperlinker.class, (String)"Hyperlinker.not_found", (Object)Hyperlink.this.path));
                            Toolkit.getDefaultToolkit().beep();
                        }
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(Hyperlink.this.message);
                    HudsonLogger.Helper.openAt(fileObject, Hyperlink.this.row, Hyperlink.this.col, bl);
                }
            });
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public String toString() {
            return this.path + ":" + this.row + ":" + this.col + ":" + this.message;
        }
    }

    public static final class PlainLogger
    implements HudsonLogger {
        public HudsonLogger.HudsonLogSession createSession(final HudsonJob hudsonJob) {
            return new HudsonLogger.HudsonLogSession(){
                final PlainLoggerLogic logic;
                {
                    this.logic = new PlainLoggerLogic(hudsonJob, hudsonJob.getName());
                }

                public boolean handle(String string, OutputWriter outputWriter) {
                    OutputListener outputListener = this.logic.findHyperlink(string);
                    if (outputListener != null) {
                        try {
                            outputWriter.println(string, outputListener);
                            return true;
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.INFO, null, iOException);
                        }
                    }
                    outputWriter.println(string);
                    return true;
                }
            };
        }
    }

    static class PlainLoggerLogic {
        private static final Pattern REMOTE_URL = Pattern.compile("\\b(https?://[^\\s)>]+)");
        private final HudsonJob job;
        private final Pattern hyperlinkable;

        PlainLoggerLogic(HudsonJob hudsonJob, String string) {
            this.job = hudsonJob;
            String string2 = Pattern.quote(string);
            this.hyperlinkable = Pattern.compile("\\s*(?:\\[.+\\] )?/.+?/(?:jobs/" + string2 + "/workspace|workspace/" + string2 + ")/([^:]+):(?:\\[?([0-9]+)[:,](?:([0-9]+)[]:])?)? (?:warning: )?(.+)");
        }

        OutputListener findHyperlink(String string) {
            try {
                Matcher matcher = this.hyperlinkable.matcher(string);
                if (matcher.matches()) {
                    String string2 = matcher.group(1);
                    int n = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) - 1 : -1;
                    int n2 = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) - 1 : -1;
                    String string3 = matcher.group(4);
                    return new Hyperlink(this.job, string2, string3, n, n2);
                }
                matcher = REMOTE_URL.matcher(string);
                if (matcher.matches()) {
                    return new URLHyperlink(new URL(matcher.group()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.FINE, null, malformedURLException);
            }
            return null;
        }
    }
}

