/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonJobBuildImpl;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.impl.HudsonViewImpl;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonConnector {
    private static final Logger LOG = Logger.getLogger(HudsonConnector.class.getName());
    private HudsonInstanceImpl instance;
    private HudsonVersion version;
    private boolean connected = false;
    private Map<String, HudsonView> cache = new HashMap<String, HudsonView>();
    private static final Map<String, Pattern> tailPatterns = new HashMap<String, Pattern>();

    public HudsonConnector(HudsonInstanceImpl hudsonInstanceImpl) {
        this.instance = hudsonInstanceImpl;
    }

    public synchronized Collection<HudsonJob> getAllJobs() {
        Document document = this.getDocument(this.instance.getUrl() + "api/xml" + "?depth=1&xpath=/&exclude=//primaryView&exclude=//view[name='All']" + "&exclude=//view/job/url&exclude=//view/job/color&exclude=//description&exclude=//job/build&exclude=//healthReport" + "&exclude=//firstBuild&exclude=//keepDependencies&exclude=//nextBuildNumber&exclude=//property&exclude=//action" + "&exclude=//upstreamProject&exclude=//downstreamProject&exclude=//queueItem&exclude=//scm");
        if (null == document) {
            return new ArrayList<HudsonJob>();
        }
        this.cache.clear();
        Collection<HudsonView> collection = this.getViews(document);
        if (null == collection) {
            collection = new ArrayList<HudsonView>();
        }
        this.instance.setViews(collection);
        Collection<HudsonJob> collection2 = this.getJobs(document);
        if (null == collection2) {
            collection2 = new ArrayList<HudsonJob>();
        }
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startJob(HudsonJob hudsonJob) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HudsonInstanceImpl.class, (String)"MSG_Starting", (Object)hudsonJob.getName()));
        progressHandle.start();
        try {
            new ConnectionBuilder().instance(this.instance).url(hudsonJob.getUrl() + "build").postData("delay=0sec".getBytes()).connection();
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Could not start {0}: {1}", new Object[]{hudsonJob, iOException});
        }
        finally {
            progressHandle.finish();
        }
        this.instance.synchronize();
    }

    Collection<? extends HudsonJobBuild> getBuilds(HudsonJobImpl hudsonJobImpl) {
        Document document = this.getDocument(hudsonJobImpl.getUrl() + "api/xml" + "?depth=1&xpath=/*/build&wrapper=root&exclude=//artifact&exclude=//action&exclude=//changeSet&exclude=//culprit" + "&exclude=//duration&exclude=//fullDisplayName&exclude=//keepLog&exclude=//timestamp&exclude=//url&exclude=//builtOn" + "&exclude=//id&exclude=//description");
        if (document == null) {
            return Collections.emptySet();
        }
        ArrayList<HudsonJobBuildImpl> arrayList = new ArrayList<HudsonJobBuildImpl>();
        NodeList nodeList = document.getElementsByTagName("build");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            int n = 0;
            boolean bl = false;
            HudsonJobBuild.Result result = null;
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                Node node3 = node2.getFirstChild();
                if (node3 == null) {
                    LOG.warning("#170267: unexpected empty <build> child: " + string);
                    continue;
                }
                String string2 = node3.getTextContent();
                if (string.equals("number")) {
                    n = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("building")) {
                    bl = Boolean.valueOf(string2);
                    continue;
                }
                if (string.equals("result")) {
                    result = HudsonJobBuild.Result.valueOf(string2);
                    continue;
                }
                LOG.warning("unexpected <build> child: " + string);
            }
            arrayList.add(new HudsonJobBuildImpl(this, hudsonJobImpl, n, bl, result));
        }
        return arrayList;
    }

    protected synchronized HudsonVersion getHudsonVersion() {
        if (null == this.version) {
            this.version = this.retrieveHudsonVersion();
        }
        return this.version;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    private Collection<HudsonView> getViews(Document document) {
        ArrayList<HudsonView> arrayList = new ArrayList<HudsonView>();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("view")) continue;
            String string = null;
            String string2 = null;
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                object = node.getChildNodes().item(j);
                if (object.getNodeType() != 1) continue;
                if (object.getNodeName().equals("name")) {
                    string = object.getFirstChild().getTextContent();
                    continue;
                }
                if (!object.getNodeName().equals("url")) continue;
                string2 = this.normalizeUrl(object.getFirstChild().getTextContent(), "view/[^/]+/");
            }
            if (null == string || null == string2) continue;
            Element element = (Element)node;
            object = new HudsonViewImpl(this.instance, string, string2);
            NodeList nodeList2 = element.getElementsByTagName("job");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                for (int k = 0; k < node2.getChildNodes().getLength(); ++k) {
                    Node node3 = node2.getChildNodes().item(k);
                    if (node3.getNodeType() != 1) continue;
                    String string3 = node3.getNodeName();
                    if (string3.equals("name")) {
                        this.cache.put(((HudsonViewImpl)object).getName() + "/" + node3.getFirstChild().getTextContent(), (HudsonView)object);
                        continue;
                    }
                    LOG.fine("unexpected view <job> child: " + string3);
                }
            }
            arrayList.add((HudsonView)object);
        }
        return arrayList;
    }

    private Collection<HudsonJob> getJobs(Document document) {
        ArrayList<HudsonJob> arrayList = new ArrayList<HudsonJob>();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("job")) continue;
            HudsonJobImpl hudsonJobImpl = new HudsonJobImpl(this.instance);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                String string2 = node2.getNodeName();
                if (string2.equals("name")) {
                    hudsonJobImpl.putProperty("job_name", node2.getFirstChild().getTextContent());
                    continue;
                }
                if (string2.equals("url")) {
                    hudsonJobImpl.putProperty("job_url", this.normalizeUrl(node2.getFirstChild().getTextContent(), "job/[^/]+/"));
                    continue;
                }
                if (string2.equals("color")) {
                    string = node2.getFirstChild().getTextContent().trim();
                    try {
                        hudsonJobImpl.putProperty("job_color", (Object)HudsonJob.Color.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("http://www.netbeans.org/nonav/issues/show_bug.cgi?id=126166 - no Color value '" + string + "' among " + Arrays.toString((Object[])HudsonJob.Color.values())));
                        Exceptions.printStackTrace((Throwable)illegalArgumentException);
                        hudsonJobImpl.putProperty("job_color", (Object)HudsonJob.Color.red_anime);
                    }
                    continue;
                }
                if (string2.equals("displayName")) {
                    hudsonJobImpl.putProperty("job_display_name", node2.getFirstChild().getTextContent());
                    continue;
                }
                if (string2.equals("buildable")) {
                    hudsonJobImpl.putProperty("job_buildable", Boolean.valueOf(node2.getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("inQueue")) {
                    hudsonJobImpl.putProperty("job_in_queue", Boolean.valueOf(node2.getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("lastBuild")) {
                    hudsonJobImpl.putProperty("job_last_build", Integer.valueOf(node2.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("lastFailedBuild")) {
                    hudsonJobImpl.putProperty("job_last_failed_build", Integer.valueOf(node2.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("lastStableBuild")) {
                    hudsonJobImpl.putProperty("job_last_stable_build", Integer.valueOf(node2.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("lastSuccessfulBuild")) {
                    hudsonJobImpl.putProperty("job_last_successful_build", Integer.valueOf(node2.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("lastCompletedBuild")) {
                    hudsonJobImpl.putProperty("job_last_completed_build", Integer.valueOf(node2.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (string2.equals("module")) {
                    string = null;
                    String string3 = null;
                    String string4 = null;
                    HudsonJob.Color color = null;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1) continue;
                        String string5 = node3.getNodeName();
                        String string6 = node3.getFirstChild().getTextContent();
                        if (string5.equals("name")) {
                            string = string6;
                            continue;
                        }
                        if (string5.equals("displayName")) {
                            string3 = string6;
                            continue;
                        }
                        if (string5.equals("url")) {
                            string4 = this.normalizeUrl(string6, "job/[^/]+/[^/]+/");
                            continue;
                        }
                        if (string5.equals("color")) {
                            color = HudsonJob.Color.valueOf(string6);
                            continue;
                        }
                        LOG.fine("unexpected <module> child: " + string2);
                    }
                    hudsonJobImpl.addModule(string, string3, color, string4);
                    continue;
                }
                LOG.fine("unexpected global <job> child: " + string2);
            }
            for (HudsonView hudsonView : this.instance.getViews()) {
                if (null == this.cache.get(hudsonView.getName() + "/" + hudsonJobImpl.getName())) continue;
                hudsonJobImpl.addView(hudsonView);
            }
            arrayList.add(hudsonJobImpl);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String normalizeUrl(String string, String string2) {
        Pattern pattern;
        Object object = tailPatterns;
        synchronized (object) {
            pattern = tailPatterns.get(string2);
            if (pattern == null) {
                pattern = Pattern.compile(".+/(" + string2 + ")");
                tailPatterns.put(string2, pattern);
            }
        }
        object = pattern.matcher(string);
        if (((Matcher)object).matches()) {
            String string3 = this.instance.getUrl() + ((Matcher)object).group(1);
            if (!string3.equals(string)) {
                LOG.log(Level.FINER, "Normalizing {0} -> {1}", new Object[]{string, string3});
            }
            return string3;
        }
        LOG.warning("Anomalous URL " + string + " not ending with " + string2 + " from " + this.instance);
        return string;
    }

    private synchronized HudsonVersion retrieveHudsonVersion() {
        HudsonVersion hudsonVersion = null;
        try {
            String string = new ConnectionBuilder().instance(this.instance).url(this.instance.getUrl()).httpConnection().getHeaderField("X-Hudson");
            if (string != null) {
                hudsonVersion = new HudsonVersion(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hudsonVersion;
    }

    Document getDocument(String string) {
        Document document = null;
        try {
            HttpURLConnection httpURLConnection = new ConnectionBuilder().instance(this.instance).url(string).httpConnection();
            if (!this.isConnected()) {
                this.connected = true;
                this.version = this.retrieveHudsonVersion();
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                    LOG.log(Level.FINE, "{0}:{1}: {2}", new Object[]{sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getMessage()});
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    this.warning(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    this.warning(sAXParseException);
                    throw sAXParseException;
                }
            }, null);
            if (!Utilities.isSupportedVersion(this.getHudsonVersion())) {
                HudsonVersion hudsonVersion = this.retrieveHudsonVersion();
                if (!Utilities.isSupportedVersion(hudsonVersion)) {
                    return null;
                }
                this.version = hudsonVersion;
            }
            httpURLConnection.disconnect();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, string, exception);
        }
        return document;
    }
}

