/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.modules.editor.indent.FormatterWriterImpl;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.netbeans.modules.editor.indent.TaskHandler;
import org.netbeans.modules.editor.indent.api.IndentUtils;

public final class FormatterImpl
extends ExtFormatter {
    private final Document doc;
    private final Formatter defaultFormatter;
    private final IndentImpl indentImpl;
    private final boolean tabSizeOverriden;
    private final boolean shiftWidthOverriden;
    private final boolean expandTabsOverriden;

    FormatterImpl(Formatter formatter, Document document) {
        super(formatter.getKitClass());
        this.defaultFormatter = formatter;
        this.tabSizeOverriden = FormatterImpl.isOverriden(formatter.getClass(), "getTabSize");
        this.shiftWidthOverriden = FormatterImpl.isOverriden(formatter.getClass(), "getShiftWidth");
        this.expandTabsOverriden = FormatterImpl.isOverriden(formatter.getClass(), "expandTabs");
        this.doc = document;
        assert (document != null);
        this.indentImpl = IndentImpl.get(document);
        this.indentImpl.setDefaultFormatter(formatter);
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).getReformatBlock(jTextComponent, string) : null;
    }

    public void indentLock() {
        this.indentImpl.indentLock();
    }

    public void indentUnlock() {
        this.indentImpl.indentUnlock();
    }

    public void reformatLock() {
        this.indentImpl.reformatLock();
    }

    public void reformatUnlock() {
        this.indentImpl.reformatUnlock();
    }

    public int getTabSize() {
        if (this.tabSizeOverriden) {
            return this.defaultFormatter.getTabSize();
        }
        return IndentUtils.tabSize(this.doc);
    }

    public int getSpacesPerTab() {
        return this.defaultFormatter.getSpacesPerTab();
    }

    public int getShiftWidth() {
        if (this.shiftWidthOverriden) {
            return this.defaultFormatter.getShiftWidth();
        }
        return IndentUtils.indentLevelSize(this.doc);
    }

    public boolean expandTabs() {
        if (this.expandTabsOverriden) {
            return this.defaultFormatter.expandTabs();
        }
        return IndentUtils.isExpandTabs(this.doc);
    }

    public int indentLine(Document document, int n) {
        return this.indentLine(document, n, false);
    }

    public int indentNewLine(Document document, int n) {
        return this.indentLine(document, n, true);
    }

    private int indentLine(Document document, int n, boolean bl) {
        try {
            return this.indentImpl.reindent(n, n, n, bl);
        }
        catch (GuardedException guardedException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
        return n;
    }

    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).reformat(baseDocument, n, n2, bl) : null;
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if (baseDocument != this.indentImpl.document()) {
            return n2 - n;
        }
        this.indentImpl.reformat(n, n2);
        TaskHandler taskHandler = this.indentImpl.reformatHandler();
        return taskHandler != null && taskHandler.hasItems() ? Math.max(taskHandler.endPos().getOffset() - n, 0) : n2 - n;
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        if (document != this.indentImpl.document()) {
            throw new IllegalStateException("Unexpected document doc=" + document);
        }
        return new FormatterWriterImpl(this.indentImpl, n, writer);
    }

    private static boolean isOverriden(Class clazz, String string) {
        while (clazz != Formatter.class && clazz != ExtFormatter.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string) || method.getParameterTypes().length != 0) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

