/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ActionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ControllerProvider;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LineBreakpointPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private final LBController controller = new LBController();
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();
    private JLabel lFileName;
    private JLabel lLineNumber;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        Object object;
        String string = null;
        String string2 = lineBreakpoint.getURL();
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        try {
            object = URLMapper.findFileObject((URL)new URL(string2));
            if (object != null) {
                string = object.getMIMEType();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2.length() > 0 && MIMENames.isFortranOrHeaderOrCppOrC(string)) {
            try {
                object = new URI(string2);
                String string3 = ((URI)object).getPath();
                if (Utilities.isWindows() && string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
                this.tfFileName.setText(string3);
            }
            catch (Exception exception) {
                this.tfFileName.setText(string2);
            }
        } else {
            this.tfFileName.setEditable(true);
        }
        if (lineBreakpoint.getLineNumber() > 0) {
            this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        }
        this.conditionsPanel = new ConditionsPanel(lineBreakpoint);
        this.pConditions.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel(lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.tfFileName.getDocument().addDocumentListener(this.validityDocumentListener);
        this.tfLineNumber.getDocument().addDocumentListener(this.validityDocumentListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LineBreakpointPanel.this.controller.checkValid();
            }
        });
    }

    private static LineBreakpoint createBreakpoint() {
        String string = EditorContextBridge.getMostRecentURL();
        int n = EditorContextBridge.getMostRecentLineNumber();
        LineBreakpoint lineBreakpoint = string.length() != 0 ? LineBreakpoint.create(string, n) : LineBreakpoint.create();
        return lineBreakpoint;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineGDB");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lFileName = new JLabel();
        this.tfFileName = new JTextField();
        this.lLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 105));
        this.pSettings.setPreferredSize(new Dimension(144, 105));
        this.pSettings.setLayout(new GridBagLayout());
        this.lFileName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.lFileName.setLabelFor(this.tfFileName);
        this.lFileName.setText(resourceBundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lFileName, gridBagConstraints);
        this.lFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.tfFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.lLineNumber.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.lLineNumber.setLabelFor(this.tfLineNumber);
        this.lLineNumber.setText(resourceBundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lLineNumber, gridBagConstraints);
        this.lLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    public Controller getController() {
        return this.controller;
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }
    }

    private class LBController
    implements Controller {
        private boolean valid;
        private String errMsg = null;

        private LBController() {
        }

        public boolean ok() {
            if (!this.valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.errMsg));
                return false;
            }
            String string = LineBreakpointPanel.this.tfFileName.getText().trim();
            string = this.correctURL(string);
            LineBreakpointPanel.this.breakpoint.setURL(string);
            LineBreakpointPanel.this.breakpoint.setLineNumber(Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim()));
            LineBreakpointPanel.this.conditionsPanel.ok();
            LineBreakpointPanel.this.actionsPanel.ok();
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3;
                if (!(breakpointArray[i] instanceof LineBreakpoint)) continue;
                LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
                if (LineBreakpointPanel.this.breakpoint.getLineNumber() != lineBreakpoint.getLineNumber() || !(string3 = LineBreakpointPanel.this.breakpoint.getURL()).equals(lineBreakpoint.getURL()) || ((string2 = LineBreakpointPanel.this.breakpoint.getCondition()) == null ? lineBreakpoint.getCondition() != null : !string2.equals(lineBreakpoint.getCondition()))) continue;
                if (!lineBreakpoint.isEnabled()) {
                    breakpointArray[i].enable();
                }
                return true;
            }
            if (LineBreakpointPanel.this.createBreakpoint) {
                debuggerManager.addBreakpoint((Breakpoint)LineBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        private String correctURL(String string) {
            String string2;
            String string3 = string2 = Utilities.isWindows() ? "/" : "";
            if (new File(string).exists()) {
                string = "file:" + string2 + string;
            }
            return string;
        }

        public boolean cancel() {
            return true;
        }

        private void checkValid() {
            int n;
            String string = LineBreakpointPanel.this.tfFileName.getText().trim();
            if (string.length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                string = this.correctURL(string);
                URL uRL = new URL(string);
                try {
                    File file = new File(uRL.toURI());
                    if (!file.isFile()) {
                        this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                        this.setValid(false);
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                this.setValid(false);
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_Malformed_File_Spec"));
                this.setValid(false);
                return;
            }
            catch (IOException iOException) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_Invalid_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                n = Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            if (n <= 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }

        private void setErrorMessage(String string) {
            this.errMsg = string;
            LineBreakpointPanel.this.firePropertyChange("errorNotification", null, string);
        }

        private void setValid(boolean bl) {
            this.valid = bl;
            LineBreakpointPanel.this.firePropertyChange("valid", !bl, bl);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LineBreakpointPanel.this.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LineBreakpointPanel.this.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

