/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{CndBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        CndBreakpoint cndBreakpoint;
        CndBreakpoint cndBreakpoint2 = null;
        if (string.equals(LineBreakpoint.class.getName()) || string.equals(LineBreakpoint.class.getName() + "$LineBreakpointComparable")) {
            cndBreakpoint2 = cndBreakpoint = LineBreakpoint.create(properties.getString("url", null), properties.getInt("lineNumber", 1));
        }
        if (string.equals(FunctionBreakpoint.class.getName()) || string.equals(FunctionBreakpoint.class.getName() + "$FunctionBreakpointComparable")) {
            cndBreakpoint = FunctionBreakpoint.create(properties.getString("functionName", ""));
            ((FunctionBreakpoint)cndBreakpoint).setBreakpointType(properties.getInt("breakpointType", 1));
            cndBreakpoint2 = cndBreakpoint;
        }
        if (string.equals(AddressBreakpoint.class.getName()) || string.equals(AddressBreakpoint.class.getName() + "$AddressBreakpointComparable")) {
            cndBreakpoint2 = cndBreakpoint = AddressBreakpoint.create(properties.getString("address", ""));
        }
        cndBreakpoint2.setCondition(properties.getString("condition", ""));
        cndBreakpoint2.setSkipCount(properties.getInt("skipCount", 0));
        cndBreakpoint2.setPrintText(properties.getString("printText", ""));
        cndBreakpoint2.setGroupName(properties.getString("groupName", ""));
        cndBreakpoint2.setSuspend(properties.getInt("suspend", 2), properties.getString("threadID", "1"));
        if (properties.getBoolean("enabled", true)) {
            cndBreakpoint2.enable();
        } else {
            cndBreakpoint2.disable();
        }
        return cndBreakpoint2;
    }

    public void write(Object object, Properties properties) {
        CndBreakpoint cndBreakpoint = (CndBreakpoint)((Object)object);
        properties.setString("printText", cndBreakpoint.getPrintText());
        properties.setString("groupName", cndBreakpoint.getGroupName());
        properties.setInt("suspend", cndBreakpoint.getSuspend());
        properties.setString("threadID", cndBreakpoint.getThreadID());
        properties.setBoolean("enabled", cndBreakpoint.isEnabled());
        properties.setString("condition", cndBreakpoint.getCondition());
        properties.setInt("skipCount", cndBreakpoint.getSkipCount());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            properties.setString("url", lineBreakpoint.getURL());
            properties.setInt("lineNumber", lineBreakpoint.getLineNumber());
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            properties.setString("functionName", functionBreakpoint.getFunctionName());
            properties.setInt("breakpointType", functionBreakpoint.getBreakpointType());
        } else if (object instanceof AddressBreakpoint) {
            AddressBreakpoint addressBreakpoint = (AddressBreakpoint)object;
            properties.setString("address", addressBreakpoint.getAddress());
        }
    }
}

