/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.tools.api.Log;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class DebugProjectPanel
extends JPanel {
    private static final String WEB_PROJECT = "org.netbeans.modules.web.project.WebProject";
    private static final String RAILS_PROJECT = "org.netbeans.modules.ruby.railsprojects.RailsProject";
    private static final String PHP_PROJECT = "org.netbeans.modules.php.project";
    private String serverDebugMsg;
    private String serverDebugMsgWithMnemonic;
    private Project project;
    private boolean ffBrowserSupported;
    private boolean ieBrowserSupported;
    private ButtonGroup browserButtonGroup;
    private JRadioButton clientServerRadioButton;
    private JLabel debugProjectLabel;
    private JCheckBox doNotShowAgain;
    private JLabel extensionInstallLabel;
    private JRadioButton firefoxRadioButton;
    private JRadioButton ieRadioButton;
    private JLabel jLabel1;
    private ButtonGroup serverClientButtonGroup;
    private JRadioButton serverOnlyRadioButton;

    public DebugProjectPanel(Project project) {
        this.project = project;
        this.initComponentMessages(project);
        this.initComponents();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.adjustBrowserRadioButtons(true);
        this.clientServerRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DebugProjectPanel.this.adjustBrowserRadioButtons(false);
            }
        });
    }

    private void initComponentMessages(Project project) {
        String string;
        String string2;
        Project project2 = (Project)project.getLookup().lookup(Project.class);
        project2 = project2 != null ? project2 : project;
        String string3 = project2.getClass().getName();
        if (string3.startsWith(PHP_PROJECT)) {
            string2 = "DebugProjectPanel_PhpMessage";
            string = "DebugProjectPanel_PhpMessageMnemonic";
        } else if (string3.startsWith(WEB_PROJECT)) {
            string2 = "DebugProjectPanel_WebMessage";
            string = "DebugProjectPanel_WebMessageMnemonic";
        } else if (string3.startsWith(RAILS_PROJECT)) {
            string2 = "DebugProjectPanel_RailsMessage";
            string = "DebugProjectPanel_RailsMessageMnemonic";
        } else {
            string2 = "DebugProjectPanel_GenericMessage";
            string = "DebugProjectPanel_GenericMessageMnemonic";
        }
        this.serverDebugMsg = NbBundle.getMessage(DebugProjectPanel.class, (String)string2);
        this.serverDebugMsgWithMnemonic = NbBundle.getMessage(DebugProjectPanel.class, (String)string);
    }

    private void adjustBrowserRadioButtons(boolean bl) {
        if (bl) {
            boolean bl2 = WebClientToolsProjectUtils.isFirefox(this.project);
            ButtonModel buttonModel = bl2 ? this.firefoxRadioButton.getModel() : this.ieRadioButton.getModel();
            this.browserButtonGroup.setSelected(buttonModel, true);
            if (!this.ffBrowserSupported && !this.ieBrowserSupported) {
                this.serverClientButtonGroup.setSelected(this.serverOnlyRadioButton.getModel(), true);
                this.clientServerRadioButton.setEnabled(false);
            } else {
                boolean bl3 = WebClientToolsProjectUtils.getClientDebugProperty(this.project);
                ButtonModel buttonModel2 = bl3 ? this.clientServerRadioButton.getModel() : this.serverOnlyRadioButton.getModel();
                this.serverClientButtonGroup.setSelected(buttonModel2, true);
            }
        }
        this.firefoxRadioButton.setEnabled(this.clientServerRadioButton.isSelected() && this.ffBrowserSupported);
        this.ieRadioButton.setEnabled(this.clientServerRadioButton.isSelected() && this.ieBrowserSupported);
    }

    public ActionListener getPanelCloseHandler(final Object object) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == object) {
                    boolean bl = DebugProjectPanel.this.clientServerRadioButton.isSelected();
                    boolean bl2 = !DebugProjectPanel.this.doNotShowAgain.isSelected();
                    WebClientToolsProjectUtils.Browser browser = DebugProjectPanel.this.firefoxRadioButton.isSelected() ? WebClientToolsProjectUtils.Browser.FIREFOX : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER;
                    WebClientToolsProjectUtils.setProjectProperties(DebugProjectPanel.this.project, true, bl, browser);
                    Preferences preferences = WebClientToolsProjectUtils.getPreferencesForProject(DebugProjectPanel.this.project);
                    preferences.putBoolean("dialogShowDebugPanel", bl2);
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        Log.getLogger().log(Level.WARNING, "Could not save preferences", backingStoreException);
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.serverClientButtonGroup = new ButtonGroup();
        this.browserButtonGroup = new ButtonGroup();
        this.debugProjectLabel = new JLabel();
        this.serverOnlyRadioButton = new JRadioButton();
        this.clientServerRadioButton = new JRadioButton();
        this.firefoxRadioButton = new JRadioButton();
        this.ieRadioButton = new JRadioButton();
        this.extensionInstallLabel = new JLabel();
        this.doNotShowAgain = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.debugProjectLabel.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.debugProjectLabel.text"));
        this.serverClientButtonGroup.add(this.serverOnlyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.serverOnlyRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.serverOnlyRadioButton.text", (Object[])new Object[]{this.serverDebugMsgWithMnemonic}));
        this.serverClientButtonGroup.add(this.clientServerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.clientServerRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.clientServerRadioButton.text", (Object[])new Object[]{this.serverDebugMsg}));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.ieRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.ieRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.ieRadioButton.text"));
        this.extensionInstallLabel.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.extensionInstallLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.doNotShowAgain, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.doNotShowAgain.text"));
        this.jLabel1.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(24, 24, 24).add((Component)this.jLabel1)).add((Component)this.doNotShowAgain).add((Component)this.debugProjectLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.clientServerRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ieRadioButton).add((Component)this.firefoxRadioButton).add((Component)this.extensionInstallLabel))).add((Component)this.serverOnlyRadioButton)))).addContainerGap(40, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.debugProjectLabel).addPreferredGap(0).add((Component)this.serverOnlyRadioButton).addPreferredGap(0).add((Component)this.clientServerRadioButton).addPreferredGap(0).add((Component)this.firefoxRadioButton).addPreferredGap(0).add((Component)this.ieRadioButton).addPreferredGap(0).add((Component)this.extensionInstallLabel, -2, 16, -2).add(18, 18, 18).add((Component)this.doNotShowAgain).addPreferredGap(0).add((Component)this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.serverOnlyRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.serverOnlyRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.clientServerRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.clientServerRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.firefoxRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.ieRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.ieRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.doNotShowAgain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.doNotShowAgain.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
    }
}

