/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.netbeans.modules.mobility.cldcplatform.startup.SolarisRoutines;
import org.netbeans.modules.mobility.cldcplatform.startup.Util;
import org.openide.util.Utilities;

public class RunCommand {
    private final Runtime runTime = Runtime.getRuntime();
    protected boolean interrupted = false;
    protected Process thisProcess = null;
    protected String cmdString;
    private BufferedReader inputReader = null;
    private BufferedReader errorReader = null;
    protected OutputStream out = null;

    public void execute(String string) {
        this.execute(string, null, null);
    }

    public void execute(String string, String[] stringArray, File file) {
        this.cmdString = string;
        try {
            this.thisProcess = this.runTime.exec(string, stringArray, file);
            this.initIOStreams();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public void execute(String[] stringArray, String[] stringArray2, File file) {
        this.cmdString = Util.arrayToString(stringArray, " ");
        try {
            this.thisProcess = this.runTime.exec(stringArray, stringArray2, file);
            this.initIOStreams();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public void initIOStreams() {
        this.interrupted = false;
        try {
            InputStream inputStream = this.thisProcess.getInputStream();
            InputStream inputStream2 = this.thisProcess.getErrorStream();
            this.out = this.thisProcess.getOutputStream();
            this.inputReader = new BufferedReader(new InputStreamReader(inputStream));
            this.errorReader = new BufferedReader(new InputStreamReader(inputStream2));
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public void interrupt() {
        this.interrupted = true;
        if (Utilities.getOperatingSystem() == 256) {
            try {
                SolarisRoutines.killProcess(this.cmdString);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.thisProcess.destroy();
        this.thisProcess = null;
    }

    public int getReturnStatus() {
        if (this.interrupted) {
            return -1;
        }
        try {
            this.thisProcess.waitFor();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return -2;
        }
        if (this.thisProcess != null) {
            return this.thisProcess.exitValue();
        }
        return -3;
    }

    public boolean isRunning() {
        try {
            this.thisProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public BufferedReader getErrorReader() {
        return this.errorReader;
    }

    public BufferedReader getInputReader() {
        return this.inputReader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() {
        try {
            if (!this.interrupted) {
                if (this.inputReader.ready()) {
                    while (this.inputReader.read() != -1) {
                    }
                }
                if (this.errorReader != null && this.errorReader.ready()) {
                    while (this.errorReader.read() != -1) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getLocalizedMessage());
            iOException.printStackTrace();
        }
    }

    public String getOutputLine() {
        String string = null;
        try {
            string = this.inputReader.readLine();
            if (string != null) {
                string = string + "\n";
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getLocalizedMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    public String getErrorLine() {
        String string = null;
        try {
            string = this.errorReader.readLine();
            if (string != null) {
                string = string + "\n";
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getLocalizedMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    public void print() {
        String string = null;
        System.out.println("------------------------------  Command Print  -----------------------");
        System.out.println(" command: ");
        System.out.println("    " + this.cmdString);
        System.out.println(" Command Output:");
        while ((string = this.getOutputLine()) != null) {
            System.out.println("    " + string);
        }
        System.out.println(" Command Error:");
        while ((string = this.getErrorLine()) != null) {
            System.out.println("    " + string);
        }
        System.out.println(" Return Status: " + this.getReturnStatus());
        System.out.println("------------------------------------------------------------------------");
    }
}

