/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ZipUtil {
    private static final int READ_BUF_SIZE = 65536;
    private static final int WRITE_BUF_SIZE = 65536;
    private List<UnZipFilter> filters = new ArrayList<UnZipFilter>();

    public void addFilter(UnZipFilter unZipFilter) {
        this.filters.add(unZipFilter);
    }

    private boolean allow(ZipEntry zipEntry) {
        for (UnZipFilter unZipFilter : this.filters) {
            if (unZipFilter.allow(zipEntry)) continue;
            return false;
        }
        return true;
    }

    public void zip(File file, String[] stringArray, String[] stringArray2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                this.addEntry(file2, stringArray2[i], zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void addEntry(File file, String string, ZipOutputStream zipOutputStream) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file + File.separator + stringArray[i]);
                this.addEntry(file2, string + File.separator + file.getName(), zipOutputStream);
            }
        } else {
            int n;
            byte[] byArray = new byte[65536];
            BufferedInputStream bufferedInputStream = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
            ZipEntry zipEntry = new ZipEntry(string + File.separator + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 65536)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzip(InputStream inputStream, FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = true;
        FileSystem fileSystem = fileObject.getFileSystem();
        File file = FileUtil.toFile((FileObject)fileObject);
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            final byte[] byArray = new byte[65536];
            final ZipInputStream zipInputStream2 = zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 65536));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2;
                if (!this.allow(zipEntry)) continue;
                final File file3 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file3.exists()) continue;
                    try {
                        file2 = FileUtil.createFolder((File)file3);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file3.getName() + ".  Terminating archive installation.");
                    }
                }
                if (file3.exists() && bl && !file3.delete()) {
                    throw new RuntimeException("Failed to delete file: " + file3.getName() + ".  Terminating archive installation.");
                }
                file2 = file3.getParentFile();
                if (!file2.exists()) {
                    try {
                        FileObject fileObject2 = FileUtil.createFolder((File)file2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file2.getName() + ".  Terminating archive installation.");
                    }
                }
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        FileOutputStream fileOutputStream = null;
                        try {
                            int n;
                            fileOutputStream = new FileOutputStream(file3);
                            while ((n = zipInputStream2.read(byArray)) >= 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                        finally {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                        }
                    }
                });
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return bl2;
    }

    public static interface UnZipFilter {
        public boolean allow(ZipEntry var1);
    }
}

