/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class OpenCookieFactory {
    public static OpenCookie create(Project project, String string) {
        return OpenCookieFactory.create(project, string, null);
    }

    public static OpenCookie create(Project project, String string, String string2) {
        try {
            FileObject fileObject = SourceGroupSupport.getFileObjectFromClassName(string, project);
            return new OpenCookieImpl(fileObject, string, string2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private static class OpenCookieImpl
    implements OpenCookie {
        private DataObject dataObj;
        private JavaSource javaSource;
        private String className;
        private String methodName;

        public OpenCookieImpl(FileObject fileObject, String string, String string2) {
            try {
                this.dataObj = DataObject.find((FileObject)fileObject);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            this.javaSource = JavaSource.forFileObject((FileObject)fileObject);
            this.className = string;
            this.methodName = string2;
        }

        public void open() {
            LineCookie lineCookie;
            if (this.dataObj == null) {
                return;
            }
            OpenCookie openCookie = (OpenCookie)this.dataObj.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
            if ((lineCookie = (LineCookie)this.dataObj.getCookie(LineCookie.class)) != null) {
                long[] lArray = JavaSourceHelper.getPosition(this.javaSource, this.methodName);
                Line line = lineCookie.getLineSet().getOriginal((int)lArray[0]);
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)lArray[1]);
            }
        }
    }
}

