/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.deviceanywhere;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPI;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIDeviceWrapper;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIGetLockedDevicesReturn;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIService;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceChooser
extends JPanel {
    protected ChangeListener changeListener;
    private List<ApplicationAPIDeviceWrapper> devices;
    private JList deviceList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public DeviceChooser(String string, String string2, ApplicationAPIDeviceWrapper applicationAPIDeviceWrapper) {
        this.initComponents();
        this.initView(string, string2, applicationAPIDeviceWrapper);
    }

    private void initView(final String string, final String string2, final ApplicationAPIDeviceWrapper applicationAPIDeviceWrapper) {
        this.deviceList.setSelectionMode(0);
        this.deviceList.setListData(this.getWarmupList());
        this.deviceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DeviceChooser.this.changeListener != null) {
                    DeviceChooser.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.deviceList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && DeviceChooser.this.getSelectedDevice() != null && DeviceChooser.this.changeListener != null) {
                    DeviceChooser.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    ApplicationAPIService applicationAPIService = new ApplicationAPIService();
                    ApplicationAPI applicationAPI = applicationAPIService.getApplicationAPI();
                    ApplicationAPIGetLockedDevicesReturn applicationAPIGetLockedDevicesReturn = applicationAPI.getLockedDevices(string, string2);
                    final int n = applicationAPIGetLockedDevicesReturn.getReturnCode();
                    if (n != 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                String string = null;
                                if (n == 1) {
                                    string = NbBundle.getMessage(DeviceChooser.class, (String)"MSG_InternalError");
                                } else if (n == 2) {
                                    string = NbBundle.getMessage(DeviceChooser.class, (String)"MSG_BadLogin");
                                }
                                DeviceChooser.this.deviceList.setListData(new String[]{string});
                            }
                        });
                        return;
                    }
                    DeviceChooser.this.devices = applicationAPIGetLockedDevicesReturn.getDeviceWrappers().getDeviceWrappers();
                    if (DeviceChooser.this.devices.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DeviceChooser.this.deviceList.setListData(new String[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_NoDevice")});
                            }
                        });
                        return;
                    }
                    final String[] stringArray = new String[DeviceChooser.this.devices.size()];
                    int n2 = 0;
                    for (ApplicationAPIDeviceWrapper applicationAPIDeviceWrapper2 : DeviceChooser.this.devices) {
                        stringArray[n2++] = applicationAPIDeviceWrapper2.getName();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeviceChooser.this.deviceList.setListData(stringArray);
                            if (applicationAPIDeviceWrapper != null) {
                                DeviceChooser.this.deviceList.setSelectedValue(applicationAPIDeviceWrapper.getName(), true);
                            } else {
                                DeviceChooser.this.deviceList.setSelectedIndex(0);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeviceChooser.this.deviceList.setListData(new String[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_ConnectionError")});
                        }
                    });
                    if (exception instanceof ClassNotFoundException) {
                        ErrorManager.getDefault().notify(256, (Throwable)exception);
                    }
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.deviceList = new JList();
        this.jLabel1.setLabelFor(this.deviceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DeviceChooser.class, (String)"LBL_AvailableDevices"));
        this.jScrollPane1.setViewportView(this.deviceList);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 362, Short.MAX_VALUE).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 149, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceChooser.class, (String)"ACSN_AvailableDevices"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceChooser.class, (String)"ACSD_AvailableDevices"));
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_LoadingDevices")};
    }

    public ApplicationAPIDeviceWrapper getSelectedDevice() {
        if (this.isValidDeviceName(this.deviceList.getSelectedValue())) {
            return this.devices.get(this.deviceList.getSelectedIndex());
        }
        return null;
    }

    public List<ApplicationAPIDeviceWrapper> getLockedDevices() {
        return this.devices;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    private boolean isValidDeviceName(Object object) {
        return this.devices != null && !this.devices.isEmpty();
    }
}

