/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceParser;

public final class WorkspaceFactory {
    private static Map<File, WeakReference<Workspace>> cache = new HashMap<File, WeakReference<Workspace>>();
    private static WorkspaceFactory instance = new WorkspaceFactory();

    private WorkspaceFactory() {
    }

    public static WorkspaceFactory getInstance() {
        return instance;
    }

    public void resetCache() {
        cache = new HashMap<File, WeakReference<Workspace>>();
    }

    public Workspace load(File file) throws ProjectImporterException {
        Workspace workspace;
        Workspace workspace2;
        WeakReference<Workspace> weakReference = cache.get(file);
        Workspace workspace3 = workspace2 = weakReference != null ? (Workspace)weakReference.get() : null;
        if (workspace2 == null && (workspace = Workspace.createWorkspace(file)) != null) {
            WorkspaceParser workspaceParser = new WorkspaceParser(workspace);
            workspaceParser.parse();
            cache.put(file, new WeakReference<Workspace>(workspace));
            workspace2 = workspace;
        }
        return workspace2;
    }
}

