/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.Util;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectParser {
    ProjectParser() {
    }

    public static String parse(File file, Set<String> set, List<Link> list, Set<Workspace.Variable> set2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Document document;
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"projectDescription".equals(element.getLocalName())) {
            throw new IllegalStateException("given file is not eclipse .project file");
        }
        Element element2 = Util.findElement(element, "natures", null);
        if (element2 != null && (object3 = Util.findSubElements(element2)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Element)object2.next();
                set.add(object.getTextContent());
            }
        }
        if ((object3 = Util.findElement(element, "linkedResources", null)) != null && (object2 = Util.findSubElements((Element)object3)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                String string;
                Element element3 = (Element)object.next();
                Element element4 = Util.findElement(element3, "location", null);
                if (element4 == null) {
                    assert (Util.findElement(element3, "locationURI", null) != null) : Util.findSubElements(element3);
                    string = ProjectParser.resolveLink(Util.findElement(element3, "locationURI", null).getTextContent(), set2);
                } else {
                    string = element4.getTextContent();
                }
                list.add(new Link(Util.findElement(element3, "name", null).getTextContent(), "1".equals(Util.findElement(element3, "type", null).getTextContent()), string));
            }
        }
        return Util.findElement(element, "name", null).getTextContent();
    }

    public static Facets readProjectFacets(File file, Set<String> set) throws IOException {
        Document document;
        if (!set.contains("org.eclipse.wst.common.project.facet.core.nature")) {
            return null;
        }
        File file2 = new File(file, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        if (!file2.exists()) {
            return null;
        }
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file2 + ": " + sAXException.toString()).initCause(sAXException);
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"faceted-project".equals(element.getLocalName())) {
            return null;
        }
        ArrayList<Facets.Facet> arrayList = new ArrayList<Facets.Facet>();
        List<Element> list = Util.findSubElements(element);
        for (Element element2 : list) {
            if (!"installed".equals(element2.getNodeName())) continue;
            String string = element2.getAttribute("facet");
            String string2 = element2.getAttribute("version");
            if (string == null || string2 == null) continue;
            arrayList.add(new Facets.Facet(string, string2));
        }
        return new Facets(arrayList);
    }

    private static String resolveLink(String string, Set<Workspace.Variable> set) {
        for (Workspace.Variable variable : set) {
            if (!string.startsWith(variable.getName())) continue;
            return variable.getLocation() + string.substring(variable.getName().length());
        }
        return string;
    }
}

