/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.io.InputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.awt.StatusDisplayer;
import org.xhtmlrenderer.simple.XHTMLPanel;

public class CssPreviewPanel
extends JPanel
implements CssPreviewComponent {
    private static final Logger LOGGER = Logger.getLogger(CssPreviewPanel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.INFO);
    private Handler FS_HANDLER = new FlyingSaucerLoggersHandler();
    private XHTMLPanel xhtmlPanel = new XHTMLPanel(){

        public void paintComponent(Graphics graphics) {
            try {
                super.paintComponent(graphics);
            }
            catch (Throwable throwable) {
                if (LOG) {
                    LOGGER.log(Level.INFO, "It seems there is a bug in FlyinSaucer XHTML renderer.", throwable);
                }
                CssPreviewTopComponent.getDefault().setError();
            }
        }
    };
    private JScrollPane jScrollPane1;

    public CssPreviewPanel() {
        this.initComponents();
        this.jScrollPane1.setViewportView((Component)this.xhtmlPanel);
        this.configureFlyingSaucerLoggers();
    }

    public XHTMLPanel panel() {
        return this.xhtmlPanel;
    }

    public void setDocument(InputStream inputStream, String string) throws Exception {
        this.xhtmlPanel.setDocument(inputStream, string);
    }

    public JComponent getComponent() {
        return this;
    }

    public void dispose() {
    }

    private void configureFlyingSaucerLoggers() {
        Logger logger = Logger.getLogger("plumbing.exception");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        logger.setUseParentHandlers(false);
        logger.addHandler(this.FS_HANDLER);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
    }

    private class FlyingSaucerLoggersHandler
    extends Handler {
        private FlyingSaucerLoggersHandler() {
        }

        public void publish(LogRecord logRecord) {
            if (LOG) {
                logRecord.setLevel(Level.INFO);
                LOGGER.log(logRecord);
                LOGGER.log(Level.WARNING, logRecord.getMessage());
                StatusDisplayer.getDefault().setStatusText(logRecord.getMessage());
            }
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }
    }
}

