/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.MarginPaddingModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class PaddingWidthField
extends JPanel {
    PropertyWithUnitData borderPaddingData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private JComboBox borderPaddingCombo;
    private JComboBox borderPaddingUnitCombo;

    public PaddingWidthField() {
        this.initComponents();
        this.borderPaddingCombo.setModel(this.marginPaddingModel.getPaddingList());
        this.borderPaddingUnitCombo.setModel(this.marginPaddingModel.getPaddingUnitList());
        final JTextField jTextField = (JTextField)this.borderPaddingCombo.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PaddingWidthField.this.borderPaddingUnitCombo.setEnabled(Utils.isInteger(jTextField.getText()));
                    }
                });
            }
        });
    }

    public void setPaddingString(String string) {
        if (string != null && !string.equals("")) {
            if (Utils.isInteger(string)) {
                this.setWidthValue(string);
            } else {
                String string2 = this.getUnit(string);
                this.setWidthUnit(string2);
                this.setWidthValue(string.replaceAll(string2, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getPaddingString() {
        return this.borderPaddingData.toString();
    }

    private String getUnit(String string) {
        DefaultComboBoxModel defaultComboBoxModel = this.marginPaddingModel.getPaddingUnitList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string.trim().endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public void setWidthValue(String string) {
        if (string == null || string.equals("")) {
            this.borderPaddingCombo.setSelectedIndex(0);
        } else {
            this.borderPaddingCombo.setSelectedItem(string);
            this.borderPaddingData.setValue(string);
        }
    }

    public void setWidthUnit(String string) {
        if (string == null || string.equals("")) {
            this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(string) != -1) {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf(string));
            } else {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
            }
            this.borderPaddingData.setUnit(string);
        }
    }

    private void initComponents() {
        this.borderPaddingCombo = new JComboBox();
        this.borderPaddingUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(5, 0));
        this.borderPaddingCombo.setEditable(true);
        this.borderPaddingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PaddingWidthField.this.borderPaddingComboActionPerformed(actionEvent);
            }
        });
        this.borderPaddingCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PaddingWidthField.this.borderPaddingComboFocusLost(focusEvent);
            }
        });
        this.borderPaddingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PaddingWidthField.this.borderPaddingComboItemStateChanged(itemEvent);
            }
        });
        this.add((Component)this.borderPaddingCombo, "Center");
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDIN_WIDTH_ACCESS_NAME"));
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_FIELD_ACCESS_DESC"));
        this.borderPaddingUnitCombo.setEnabled(false);
        this.borderPaddingUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PaddingWidthField.this.borderPaddingUnitComboItemStateChanged(itemEvent);
            }
        });
        this.borderPaddingUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PaddingWidthField.this.borderPaddingUnitComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderPaddingUnitCombo, "East");
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_UNIT_ACCESS_NAME"));
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderPaddingUnitComboFocusLost(FocusEvent focusEvent) {
        this.setBorderPadding();
    }

    private void borderPaddingUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBorderPadding();
        }
    }

    public void setAccessibleName(String string, String string2) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(string);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(string2);
    }

    public void setAccessibleDescription(String string, String string2) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(string);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(string2);
    }

    private void borderPaddingComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.borderPaddingUnitCombo.setEnabled(Utils.isInteger(this.borderPaddingCombo.getSelectedItem().toString()));
            this.setBorderPadding();
        }
    }

    private void borderPaddingComboFocusLost(FocusEvent focusEvent) {
        this.setBorderPadding();
    }

    private void borderPaddingComboActionPerformed(ActionEvent actionEvent) {
        this.setBorderPadding();
    }

    private void setBorderPadding() {
        String string = this.borderPaddingData.toString();
        this.borderPaddingData.setUnit(this.borderPaddingUnitCombo.getSelectedItem().toString());
        this.borderPaddingData.setValue(this.borderPaddingCombo.getSelectedItem().toString());
        this.firePropertyChange("margin-width", string, this.borderPaddingData.toString());
    }
}

