/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.util.StringTokenizer;

public class TextDecorationData {
    private boolean noDecorationEnabled = false;
    private boolean underlineEnabled = false;
    private boolean overlineEnabled = false;
    private boolean lineThroughEnabled = false;
    private boolean blinkEnabled = false;

    public void setDecoration(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.enableUnderline(false);
        this.enableOverline(false);
        this.enableLineThrough(false);
        this.enableBlink(false);
        this.enableNoDecoration(false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().equals("underline")) {
                this.enableUnderline(true);
            }
            if (string2.trim().equals("overline")) {
                this.enableOverline(true);
            }
            if (string2.trim().equals("line-through")) {
                this.enableLineThrough(true);
            }
            if (string2.trim().equals("blink")) {
                this.enableBlink(true);
            }
            if (!string2.trim().equals("none")) continue;
            this.enableNoDecoration(true);
        }
    }

    public boolean enableUnderline(boolean bl) {
        boolean bl2 = this.underlineEnabled() != bl && !this.noDecorationEnabled();
        this.underlineEnabled = bl;
        return bl2;
    }

    public boolean underlineEnabled() {
        return this.underlineEnabled;
    }

    public boolean enableOverline(boolean bl) {
        boolean bl2 = this.overlineEnabled() != bl && !this.noDecorationEnabled();
        this.overlineEnabled = bl;
        return bl2;
    }

    public boolean overlineEnabled() {
        return this.overlineEnabled;
    }

    public boolean enableLineThrough(boolean bl) {
        boolean bl2 = this.lineThroughEnabled() != bl && !this.noDecorationEnabled();
        this.lineThroughEnabled = bl;
        return bl2;
    }

    public boolean lineThroughEnabled() {
        return this.lineThroughEnabled;
    }

    public boolean enableBlink(boolean bl) {
        boolean bl2 = this.blinkEnabled() != bl && !this.noDecorationEnabled();
        this.blinkEnabled = bl;
        return bl2;
    }

    public boolean blinkEnabled() {
        return this.blinkEnabled;
    }

    public void enableNoDecoration(boolean bl) {
        this.noDecorationEnabled = bl;
        if (bl) {
            this.enableUnderline(false);
            this.enableOverline(false);
            this.enableLineThrough(false);
            this.enableBlink(false);
        }
    }

    public boolean noDecorationEnabled() {
        return this.noDecorationEnabled;
    }

    public String toString() {
        String string = "";
        if (this.noDecorationEnabled) {
            return "none";
        }
        if (this.underlineEnabled) {
            string = string + " underline";
        }
        if (this.overlineEnabled) {
            string = string + " overline";
        }
        if (this.lineThroughEnabled) {
            string = string + " line-through";
        }
        if (this.blinkEnabled) {
            string = string + " blink";
        }
        return string;
    }
}

