/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.actions.CssDisplayer;
import org.netbeans.modules.css.actions.XMLDisplayer;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.flute.parser.Parser;

public class CheckStyleAction
extends BaseAction
implements ErrorHandler,
DocumentHandler {
    public static final String checkStyleAction = NbBundle.getMessage(CheckStyleAction.class, (String)"NAME_check_CSS");
    private boolean failed;
    private int warnings;
    private DataObject csso;
    private CssDisplayer disp;

    public CheckStyleAction() {
        super(checkStyleAction);
        this.putValue("helpID", CheckStyleAction.class.getName());
        this.putValue("ShortDescription", checkStyleAction);
        this.putValue("IconResource", "org/netbeans/modules/css/resources/checkStyleAction.gif");
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        this.failed = false;
        this.warnings = 0;
        this.disp = new CssDisplayer();
        Parser parser = new Parser();
        parser.setErrorHandler(this);
        parser.setDocumentHandler(this);
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        if (baseDocument == null) {
            return;
        }
        this.csso = NbEditorUtilities.getDataObject((Document)baseDocument);
        if (this.csso == null) {
            return;
        }
        try {
            SaveCookie saveCookie = (SaveCookie)this.csso.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            String string = this.csso.getPrimaryFile().getURL().toExternalForm();
            parser.parseStyleSheet(string);
        }
        catch (IOException iOException) {
            this.failed = true;
        }
        catch (CSSParseException cSSParseException) {
            this.failed = true;
        }
        catch (Throwable throwable) {
            this.disp.display("Unexpected exception from CSS parser: " + throwable.getMessage());
            Logger.global.log(Level.INFO, "Unexpected exception from CSS parser", throwable);
            this.failed = true;
        }
        if (this.failed || this.warnings > 0) {
            this.disp.moveToFront();
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_CSS_checking") + " " + this.getStatus() + ".");
    }

    private String getStatus() {
        return this.failed ? NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_failed") : (this.warnings > 1 ? NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_finished_with_warnings") : NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_finished"));
    }

    public void warning(CSSParseException cSSParseException) throws CSSException {
        this.disp.display(this.csso, cSSParseException);
        ++this.warnings;
    }

    public void error(CSSParseException cSSParseException) throws CSSException {
        this.disp.display(this.csso, cSSParseException);
        this.failed = true;
    }

    public void fatalError(CSSParseException cSSParseException) throws CSSException {
        this.disp.display(this.csso, cSSParseException);
        this.failed = true;
    }

    public void startDocument(InputSource inputSource) throws CSSException {
    }

    public void endDocument(InputSource inputSource) throws CSSException {
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void startPage(String string, String string2) throws CSSException {
    }

    public void endPage(String string, String string2) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
    }
}

