/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

public abstract class RubyBreakpoint
extends Breakpoint
implements IRubyBreakpoint {
    private static final Logger LOGGER = Logger.getLogger(RubyBreakpoint.class.getName());
    static final String PROP_UPDATED = "updated";
    private boolean enabled = true;

    protected RubyBreakpoint() {
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.updateBreakpoint();
            this.firePropertyChange("enabled", true, false);
        }
    }

    public final void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.updateBreakpoint();
            this.firePropertyChange("enabled", false, true);
        }
    }

    protected final void updateBreakpoint() {
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            try {
                rubyDebuggerProxy.updateBreakpoint((IRubyBreakpoint)this);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                LOGGER.log(Level.WARNING, "Exception during breakpoint update: " + rubyDebuggerException.getLocalizedMessage(), rubyDebuggerException);
            }
        }
    }

    protected final void notifyUpdated() {
        ContextProviderWrapper.getBreakpointModel().fireChanges();
        this.fireUpdated();
    }

    protected void fireUpdated() {
        this.firePropertyChange(PROP_UPDATED, null, null);
    }
}

