/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final Boolean SKIP_BALLOON_EVAL = Boolean.getBoolean("ruby.debugger.skip.balloon.evaluation");
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        RubySession rubySession = Util.getCurrentSession();
        if (rubySession == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        StyledDocument styledDocument;
        if (SKIP_BALLOON_EVAL.booleanValue()) {
            return;
        }
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            styledDocument = this.ec.openDocument();
        }
        catch (IOException iOException) {
            return;
        }
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return;
        }
        String string = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (string == null) {
            return;
        }
        RubySession rubySession = Util.getCurrentSession();
        if (rubySession == null) {
            return;
        }
        RubyVariable rubyVariable = rubySession.inspectExpression(string);
        if (rubyVariable == null) {
            return;
        }
        RubyValue rubyValue = rubyVariable.getValue();
        if (rubyValue == null) {
            return;
        }
        String string2 = rubyValue.getValueString();
        if (string2 == null || string2.equals(string)) {
            return;
        }
        String string3 = string + " = " + string2;
        this.firePropertyChange("shortDescription", null, string3);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            return jEditorPane.getSelectedText();
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
        if (element == null) {
            return null;
        }
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset() - n4;
        if (n3 + 1 >= n5) {
            return null;
        }
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        return ToolTipAnnotation.getExpressionToEvaluate(fileObject, n);
    }

    static String getExpressionToEvaluate(FileObject fileObject, int n) {
        Node node = AstUtilities.getRoot((FileObject)fileObject);
        if (node == null) {
            return null;
        }
        Node node2 = AstUtilities.findNodeAtOffset((Node)node, (int)n);
        if (node2 == null) {
            return null;
        }
        if (node2.getNodeType() == NodeType.NEWLINENODE) {
            node2 = AstUtilities.findNodeAtOffset((Node)node, (int)(n + 1));
        }
        if (ToolTipAnnotation.shouldEvaluate(node2) && node2 instanceof INameNode) {
            return AstUtilities.getName((Node)node2);
        }
        return null;
    }

    private static boolean shouldEvaluate(Node node) {
        if (node.getNodeType() == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case ARGUMENTNODE: 
            case DVARNODE: 
            case DASGNNODE: 
            case SELFNODE: 
            case LOCALVARNODE: 
            case LOCALASGNNODE: 
            case INSTVARNODE: 
            case INSTASGNNODE: 
            case GLOBALVARNODE: 
            case GLOBALASGNNODE: 
            case CONSTNODE: 
            case CONSTDECLNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case NILNODE: 
            case TRUENODE: 
            case FALSENODE: {
                return true;
            }
        }
        return false;
    }
}

