/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeMap {
    Map<String, byte[]> map;

    static AttributeMap load(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        return AttributeMap.load(dataInputStream, constantPool, false);
    }

    static AttributeMap load(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(n + 1, 1.0f);
        for (int i = 0; i < n; ++i) {
            int n2;
            CPEntry cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
            if (!(cPEntry instanceof CPUTF8Info)) {
                throw new InvalidClassFormatException();
            }
            CPUTF8Info cPUTF8Info = (CPUTF8Info)cPEntry;
            String string = cPUTF8Info.getName();
            if (!bl && "Code".equals(string)) {
                int n3;
                for (n2 = dataInputStream.readInt(); (n3 = (int)dataInputStream.skip(n2)) > 0 && n3 < n2; n2 -= n3) {
                }
                continue;
            }
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            hashMap.put(string, byArray);
        }
        return new AttributeMap(hashMap);
    }

    AttributeMap(Map<String, byte[]> map) {
        this.map = map;
    }

    DataInputStream getStream(String string) {
        byte[] byArray = this.map.get(string);
        return byArray != null ? new DataInputStream(new ByteArrayInputStream(byArray)) : null;
    }

    byte[] get(String string) {
        return this.map.get(string);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsAttribute(String string) {
        return this.map.containsKey(string);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }
}

